/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.config.ITxcManagerListener;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.executor.api.IAtExcutor;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcPrepareStatement;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import java.sql.SQLException;
import java.util.concurrent.Executor;
import org.apache.commons.lang.StringUtils;

public class DefaultExecutor<T>
implements IAtExcutor<T> {
    private static final LoggerWrap logger = LoggerInit.logger;
    private final ITxcVisitor sqlVisitor;
    private final ITxcDataSource txcDataSource;
    private final ITxcConnection txcConn;
    private final ITxcStatement txcSt;
    private final ISqlExecutor<T> sqlExecutor;
    protected static String skipTablePattern = null;

    public DefaultExecutor(ITxcConnection conn, ITxcStatement st, ISqlExecutor<T> sqlExecutor, ITxcVisitor sqlVisitor) throws SQLException {
        this.txcSt = st;
        this.txcConn = conn;
        this.txcDataSource = this.txcConn.getTxcDataSource();
        this.sqlExecutor = sqlExecutor;
        this.sqlVisitor = sqlVisitor;
        if (this.sqlVisitor != null) {
            this.sqlVisitor.setTxcStatement(st);
        }
    }

    @Override
    public T execute(Object ... args) throws SQLException {
        if (logger.isAnalyzeEnabled()) {
            T t;
            AnalyzeLogger.getInstance().getLastCost();
            SQLException e2 = null;
            try {
                t = this.sqlExecutor.execute(this.txcSt.getTargetStatement(), args);
            }
            catch (SQLException e) {
                try {
                    e2 = e;
                    throw e;
                }
                catch (Throwable throwable) {
                    if (this.txcSt instanceof ITxcPrepareStatement) {
                        if (e2 == null) {
                            logger.analyze("tran.read", TxcContext.getCurrentXid(), "1", AnalyzeLogger.getInstance().getLastCost(), "", AnalyzeLogger.getInstance().getNextSequence(), this.txcSt.getTargetSql(), ((ITxcPrepareStatement)this.txcSt).getParametersString());
                        } else {
                            logger.analyze("tran.read", TxcContext.getCurrentXid(), "0", AnalyzeLogger.getInstance().getLastCost(), e2.getMessage(), AnalyzeLogger.getInstance().getNextSequence(), this.txcSt.getTargetSql(), ((ITxcPrepareStatement)this.txcSt).getParametersString());
                        }
                    } else if (e2 == null) {
                        logger.analyze("tran.read", TxcContext.getCurrentXid(), "1", AnalyzeLogger.getInstance().getLastCost(), "", AnalyzeLogger.getInstance().getNextSequence(), this.txcSt.getTargetSql(), "");
                    } else {
                        logger.analyze("tran.read", TxcContext.getCurrentXid(), "0", AnalyzeLogger.getInstance().getLastCost(), e2.getMessage(), AnalyzeLogger.getInstance().getNextSequence(), this.txcSt.getTargetSql(), "");
                    }
                    throw throwable;
                }
            }
            if (this.txcSt instanceof ITxcPrepareStatement) {
                if (e2 == null) {
                    logger.analyze("tran.read", TxcContext.getCurrentXid(), "1", AnalyzeLogger.getInstance().getLastCost(), "", AnalyzeLogger.getInstance().getNextSequence(), this.txcSt.getTargetSql(), ((ITxcPrepareStatement)this.txcSt).getParametersString());
                } else {
                    logger.analyze("tran.read", TxcContext.getCurrentXid(), "0", AnalyzeLogger.getInstance().getLastCost(), e2.getMessage(), AnalyzeLogger.getInstance().getNextSequence(), this.txcSt.getTargetSql(), ((ITxcPrepareStatement)this.txcSt).getParametersString());
                }
            } else if (e2 == null) {
                logger.analyze("tran.read", TxcContext.getCurrentXid(), "1", AnalyzeLogger.getInstance().getLastCost(), "", AnalyzeLogger.getInstance().getNextSequence(), this.txcSt.getTargetSql(), "");
            } else {
                logger.analyze("tran.read", TxcContext.getCurrentXid(), "0", AnalyzeLogger.getInstance().getLastCost(), e2.getMessage(), AnalyzeLogger.getInstance().getNextSequence(), this.txcSt.getTargetSql(), "");
            }
            return t;
        }
        return this.sqlExecutor.execute(this.txcSt.getTargetStatement(), args);
    }

    public ITxcDataSource getTxcDataSource() {
        return this.txcDataSource;
    }

    public ITxcConnection getTxcConn() {
        return this.txcConn;
    }

    public ITxcStatement getTxcSt() {
        return this.txcSt;
    }

    public ITxcVisitor getSqlVisitor() {
        if (this.sqlVisitor == null) {
            throw new TxcException("sqlVisitor is null");
        }
        return this.sqlVisitor;
    }

    public ISqlExecutor<T> getSqlExecutor() {
        return this.sqlExecutor;
    }

    static {
        try {
            try {
                String result = TxcConfigHolder.getInstance().getConfig("com.taobao.txc.skip.tables", "TXC_GROUP");
                if (!StringUtils.isEmpty((String)result)) {
                    skipTablePattern = result;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            TxcConfigHolder.getInstance().addListener("com.taobao.txc.skip.tables", "TXC_GROUP", new ITxcManagerListener(){

                @Override
                public Executor getExecutor() {
                    return null;
                }

                @Override
                public void receiveConfigInfo(String content) {
                    skipTablePattern = content;
                    logger.info(String.format("Skip table change to: %s", content));
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

