/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcIsolation;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.parser.hint.TxcHint;
import com.taobao.txc.parser.visitor.TxcVisitorFactory;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.executor.DefaultExecutor;
import com.taobao.txc.resourcemanager.executor.TxcLogManager;
import com.taobao.txc.resourcemanager.executor.api.IExecutor;
import com.taobao.txc.resourcemanager.executor.rc.AtExecutorRC;
import com.taobao.txc.resourcemanager.executor.rc.DeleteRC;
import com.taobao.txc.resourcemanager.executor.rc.InsertDupKeyRC;
import com.taobao.txc.resourcemanager.executor.rc.InsertRC;
import com.taobao.txc.resourcemanager.executor.rc.SelectForUpdateRC;
import com.taobao.txc.resourcemanager.executor.rc.SelectRCWithTxcHint;
import com.taobao.txc.resourcemanager.executor.rc.UpdateRC;
import com.taobao.txc.resourcemanager.executor.rt.RtExecutor;
import com.taobao.txc.resourcemanager.executor.unrc.AtExecutorUnRC;
import com.taobao.txc.resourcemanager.executor.unrc.DeleteUnRC;
import com.taobao.txc.resourcemanager.executor.unrc.InsertDupKeyUnRC;
import com.taobao.txc.resourcemanager.executor.unrc.InsertUnRC;
import com.taobao.txc.resourcemanager.executor.unrc.UpdateUnRC;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcPrepareStatement;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import com.taobao.txc.rpc.impl.RpcClient;
import java.sql.SQLException;

public class ExecutorFactory<T> {
    private static final LoggerWrap logger = LoggerInit.logger;
    private final ISqlExecutor<T> sqlExecutor;

    public ExecutorFactory(ISqlExecutor<T> sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    private IExecutor<T> getUnRCExector(ITxcConnection txcConn, ITxcStatement txcSt) throws SQLException {
        ITxcVisitor v = TxcVisitorFactory.getSqlVisitor(txcConn.getDsType(), txcSt.getTargetSql());
        AtExecutorUnRC execute = null;
        switch (v.getSQLExplain().getSqlType()) {
            case DELETE: {
                execute = new DeleteUnRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
            case INSERT: {
                execute = new InsertUnRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
            case UPDATE: {
                execute = new UpdateUnRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
            case INSERT_INGORE: {
                break;
            }
            case INSERT_ON_DUPLICATE_UPDATE: {
                execute = new InsertDupKeyUnRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
        }
        return execute;
    }

    private IExecutor<T> getRCExector(ITxcConnection txcConn, ITxcStatement txcSt) throws SQLException {
        ITxcVisitor v = TxcVisitorFactory.getSqlVisitor(txcConn.getDsType(), txcSt.getTargetSql());
        AtExecutorRC execute = null;
        switch (v.getSQLExplain().getSqlType()) {
            case SELECT: {
                if (!TxcHint.isReadCommited(v.getSQLExplain().getInputSql()) && !TxcHint.isReadCommited(TxcContext.getTxcHint() + v.getSQLExplain().getInputSql())) break;
                execute = new SelectRCWithTxcHint<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
            case SELECT_FOR_UPDATE: {
                execute = new SelectForUpdateRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
            case DELETE: {
                execute = new DeleteRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
            case INSERT: {
                execute = new InsertRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
            case UPDATE: {
                execute = new UpdateRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
            case INSERT_INGORE: {
                break;
            }
            case INSERT_ON_DUPLICATE_UPDATE: {
                execute = new InsertDupKeyRC<T>(txcConn, txcSt, this.sqlExecutor, v);
                break;
            }
        }
        return execute;
    }

    private IExecutor<T> getRTExector(ITxcConnection txcConn, ITxcStatement txcSt) throws SQLException {
        ITxcVisitor v = TxcVisitorFactory.getSqlVisitor(txcConn.getDsType(), txcSt.getTargetSql());
        RtExecutor<T> execute = null;
        switch (v.getSQLExplain().getSqlType()) {
            case DELETE: 
            case INSERT: 
            case UPDATE: {
                execute = new RtExecutor<T>(txcConn, txcSt, this.sqlExecutor);
                break;
            }
        }
        return execute;
    }

    private IExecutor<T> getTxcExcutor(ITxcConnection txcConn, ITxcStatement txcSt) throws SQLException {
        if (!TxcContext.inTxcEnv()) {
            throw TxcException.nestedException(new TxcException("not in txc env!"));
        }
        if (TxcContext.inTxcTransaction() && TxcContext.inRetryContext()) {
            throw TxcException.nestedException(new TxcException("Both in AT/MT & RT is not support!"));
        }
        IExecutor<T> execute = null;
        if (TxcContext.inTxcTransaction()) {
            TxcIsolation iso = TxcConfigHolder.getInstance().getTxcGolbalLockMode(RpcClient.getVgroup());
            switch (iso) {
                case READ_UNCOMMITED: {
                    execute = this.getUnRCExector(txcConn, txcSt);
                    break;
                }
                case READ_COMMITED: {
                    execute = this.getRCExector(txcConn, txcSt);
                    break;
                }
                case REPEATABLE: {
                    throw TxcException.nestedException(new TxcException("repeatable isolation is not supported."));
                }
                case SERIALIZABLE: {
                    throw TxcException.nestedException(new TxcException("serializable isolation is not supported."));
                }
                default: {
                    throw TxcException.nestedException(new TxcException("unknown isolation."));
                }
            }
        } else if (TxcContext.inRetryContext()) {
            execute = this.getRTExector(txcConn, txcSt);
        }
        return execute == null ? new DefaultExecutor<T>(txcConn, txcSt, this.sqlExecutor, null) : execute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T execute(ITxcConnection txcConn, ITxcStatement txcSt, String logType, Object ... args) throws SQLException {
        T t;
        try {
            if (txcSt instanceof ITxcPrepareStatement) {
                ITxcPrepareStatement txcPst = (ITxcPrepareStatement)txcSt;
                logger.info(String.format("[start] [%s] [%s] [%d] [%s] [%s] [%s] [%s] [%s] [%s] [%s]", RpcClient.getVgroup(), logType, TxcContext.getTransactionId(), TxcLogManager.getConnInfor(txcConn), TxcLogManager.getDbKey(txcConn), txcPst.getTargetSql(), txcPst.getParametersString(), TxcContext.getTxcHint(), TxcContext.getTxcRule(), txcPst.getRtFromStart()));
            } else {
                logger.info(String.format("[start] [%s] [%s] [%d] [%s] [%s] [%s] [%s]", RpcClient.getVgroup(), logType, TxcContext.getTransactionId(), TxcLogManager.getConnInfor(txcConn), TxcLogManager.getDbKey(txcConn), txcSt.getTargetSql(), txcSt.getRtFromStart()));
            }
            IExecutor<T> execute = this.getTxcExcutor(txcConn, txcSt);
            logger.info(String.format("[parse] [%d] [%s] [%s]", TxcContext.getTransactionId(), execute.getClass().getName(), txcSt.getRtFromStart()));
            t = execute.execute(args);
        }
        catch (Throwable throwable) {
            logger.info(String.format("[end] [%d] [%s]", TxcContext.getTransactionId(), txcSt.getRtFromStart()));
            throw throwable;
        }
        logger.info(String.format("[end] [%d] [%s]", TxcContext.getTransactionId(), txcSt.getRtFromStart()));
        return t;
    }
}

