/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.ContextStep2;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.common.util.string.TxcString;
import com.taobao.txc.parser.struct.RollbackInfor;
import com.taobao.txc.parser.struct.SqlType;
import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.parser.struct.UndoLogMode;
import com.taobao.txc.parser.visitor.cache.TxcMetaCache;
import com.taobao.txc.resourcemanager.executor.api.ITxcLogManager;
import com.taobao.txc.resourcemanager.executor.rt.RtExecutor;
import com.taobao.txc.resourcemanager.jdbc.TxcAtomDataSourceHelper;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import com.taobao.txc.resourcemanager.undo.AbstractUndoExcutor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class TxcLogManager
implements ITxcLogManager {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static String txcLogTableName = "txc_undo_log";
    private static int committedNum = 0;
    private static String hostIp = TxcLogManager.getHostIp();
    private static final int TXC_UNDO_LOG_VALID_DAYS = 3;

    private static String getHostIp() {
        String hostIp = "";
        try {
            hostIp = InetAddress.getLocalHost().toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostIp;
    }

    public static Set<String> getAtServerList(JdbcTemplate template) {
        int size = 1000;
        HashSet<String> serverList = new HashSet<String>();
        String targetDate = TxcString.getDateBeforeNow(3);
        List ret = null;
        String baseSql = "select id, server, status from " + txcLogTableName;
        StringBuilder[] sql = new StringBuilder[]{new StringBuilder(baseSql).append(" WHERE gmt_modified > '").append(targetDate).append("' limit ").append(size), new StringBuilder(baseSql).append(" WHERE gmt_modified > to_date('").append(targetDate).append("','yyyy-mm-dd')")};
        for (int i = 0; i < 2; ++i) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(sql[i].toString());
                }
                ret = template.queryForList(sql[i].toString());
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        if (ret == null) {
            return serverList;
        }
        for (Object o : ret) {
            String server = (String)((Map)o).get("server");
            if (server == null) {
                server = (String)((Map)o).get("SERVER");
            }
            serverList.add(server);
        }
        if (serverList.size() > 0) {
            logger.info(((Object)serverList).toString());
        }
        return serverList;
    }

    public static Set<String> getRtServerList(JdbcTemplate template) {
        int size = 1000;
        HashSet<String> serverList = new HashSet<String>();
        String targetDate = TxcString.getDateBeforeNow(3);
        List ret = null;
        String baseSql = "select id, server, status from " + txcLogTableName;
        StringBuilder[] sql = new StringBuilder[]{new StringBuilder(baseSql).append(" WHERE gmt_modified > '").append(targetDate).append("' limit ").append(size), new StringBuilder(baseSql).append(" WHERE gmt_modified > to_date('").append(targetDate).append("','yyyy-mm-dd')")};
        for (int i = 0; i < 2; ++i) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug(sql[i].toString());
                }
                ret = template.queryForList(sql[i].toString());
                break;
            }
            catch (Exception exception) {
                continue;
            }
        }
        if (ret == null) {
            return serverList;
        }
        for (Object o : ret) {
            String server;
            Number status = (Number)((Map)o).get("status");
            if (status == null) {
                status = (Number)((Map)o).get("STATUS");
            }
            if ((server = (String)((Map)o).get("server")) == null) {
                server = (String)((Map)o).get("SERVER");
            }
            if (!status.toString().equalsIgnoreCase(String.valueOf(UndoLogMode.RT_JOURNEL.getValue()))) continue;
            serverList.add(server);
        }
        if (serverList.size() > 0) {
            logger.info(((Object)serverList).toString());
        }
        return serverList;
    }

    public static List<?> getServerList(JdbcTemplate template, String xid, long bid) {
        String sql = String.format("select server from %s where xid='%s' and branch_Id=%s", txcLogTableName, xid, bid);
        if (logger.isDebugEnabled()) {
            logger.debug(sql);
        }
        return template.queryForList(sql);
    }

    public static void flushUndoLog(ITxcConnection conn, TxcRuntimeContext txcLog) throws SQLException {
        block7: {
            block8: {
                SQLException e2;
                String log;
                block6: {
                    log = txcLog == null ? "null txc_undo_log" : txcLog.encode();
                    logger.info(String.format("[%d] %s [%s] [%s]", TxcContext.getTransactionId(), log, TxcLogManager.getDbKey(conn), hostIp));
                    if (!logger.isAnalyzeEnabled()) break block7;
                    AnalyzeLogger.getInstance().getLastCost();
                    e2 = null;
                    try {
                        conn.flushUndoLog(txcLog, txcLogTableName);
                        if (e2 != null) break block6;
                    }
                    catch (SQLException e) {
                        try {
                            e2 = e;
                            throw e;
                        }
                        catch (Throwable throwable) {
                            if (e2 == null) {
                                logger.analyze("tran.undolog", TxcContext.getCurrentXid(), "1", AnalyzeLogger.getInstance().getLastCost(), txcLog.getInforCosts(), "", TxcLogManager.getDbKey(conn), log);
                            } else {
                                logger.analyze("tran.undolog", TxcContext.getCurrentXid(), "0", AnalyzeLogger.getInstance().getLastCost(), txcLog.getInforCosts(), e2.getMessage(), TxcLogManager.getDbKey(conn), log);
                            }
                            throw throwable;
                        }
                    }
                    logger.analyze("tran.undolog", TxcContext.getCurrentXid(), "1", AnalyzeLogger.getInstance().getLastCost(), txcLog.getInforCosts(), "", TxcLogManager.getDbKey(conn), log);
                    break block8;
                }
                logger.analyze("tran.undolog", TxcContext.getCurrentXid(), "0", AnalyzeLogger.getInstance().getLastCost(), txcLog.getInforCosts(), e2.getMessage(), TxcLogManager.getDbKey(conn), log);
            }
            return;
        }
        conn.flushUndoLog(txcLog, txcLogTableName);
        txcLog.setUndoLogFlushed(true);
    }

    @Override
    public void branchCommit(ContextStep2 context) throws SQLException {
        this.branchCommit(Arrays.asList(context));
    }

    public List<List> createList(List targe, int size) {
        ArrayList<List> listArr = new ArrayList<List>();
        int arrSize = targe.size() % size == 0 ? targe.size() / size : targe.size() / size + 1;
        for (int i = 0; i < arrSize; ++i) {
            ArrayList sub = new ArrayList();
            for (int j = i * size; j <= size * (i + 1) - 1; ++j) {
                if (j > targe.size() - 1) continue;
                sub.add(targe.get(j));
            }
            listArr.add(sub);
        }
        return listArr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void branchCommit(List<ContextStep2> contexts) throws SQLException {
        if (contexts == null || contexts.size() <= 0) {
            return;
        }
        StringBuilder dbs = new StringBuilder();
        dbs.append("total:").append(contexts.size());
        HashMap<String, ArrayList<ContextStep2>> maps = new HashMap<String, ArrayList<ContextStep2>>();
        List<ContextStep2> list = contexts;
        synchronized (list) {
            for (ContextStep2 c : contexts) {
                if (c.getCommitMode().getValue() == CommitMode.COMMIT_RETRY_MODE.getValue()) {
                    RtExecutor.executeSql(c.getXid(), c.getBranchId(), c.getDbname(), c.getRetrySql());
                    continue;
                }
                ArrayList<ContextStep2> list2 = (ArrayList<ContextStep2>)maps.get(c.getDbname());
                if (list2 == null) {
                    list2 = new ArrayList<ContextStep2>();
                    maps.put(c.getDbname(), list2);
                }
                list2.add(c);
            }
        }
        for (String dbname : maps.keySet()) {
            dbs.append(", ").append(dbname).append(":").append(maps.get(dbname) == null ? 0 : ((List)maps.get(dbname)).size());
        }
        logger.info(dbs.toString());
        String errorMessage = null;
        for (String dbname : maps.keySet()) {
            List lists = (List)maps.get(dbname);
            if (lists == null || lists.size() <= 0) continue;
            List<List> lls = this.createList(lists, 100);
            for (List l : lls) {
                if (logger.isDebugEnabled()) {
                    for (ContextStep2 c : l) {
                        logger.debug(String.format("%s:%d branchCommit %s", c.getXid(), c.getBranchId(), dbname));
                    }
                }
                ITxcConnection txcConn = null;
                if (l.size() <= 0) continue;
                try {
                    txcConn = (ITxcConnection)TxcAtomDataSourceHelper.getTxcDataSource(dbname).getConnection();
                    this.deleteUndoLog(l, txcConn);
                    if (logger.isDebugEnabled()) {
                        logger.debug("total committed branches:" + (committedNum += l.size()));
                    }
                    contexts.removeAll(l);
                    l.clear();
                }
                catch (Exception e) {
                    if (e.getMessage() != null) {
                        if (e instanceof TxcException && e.getMessage().indexOf("not find datasource") != -1) {
                            logger.info(String.format("branchCommit error code:%s message:%s", ((TxcException)e).getErrcode().errCode, e.getMessage()));
                            contexts.removeAll(l);
                            l.clear();
                            continue;
                        }
                        if (e instanceof SQLException && (e.getMessage().indexOf("read-only") != -1 || e.getMessage().indexOf("command denied") != -1 || e.getMessage().indexOf("not allowed") != -1)) {
                            logger.info(String.format("branchCommit error code:%d state:%s message:%s", ((SQLException)e).getErrorCode(), ((SQLException)e).getSQLState(), e.getMessage()));
                            contexts.removeAll(l);
                            l.clear();
                            continue;
                        }
                    }
                    if (errorMessage != null) continue;
                    errorMessage = e.getMessage();
                }
                finally {
                    if (txcConn == null) continue;
                    txcConn.close();
                }
            }
        }
        if (errorMessage != null) {
            throw new TxcException(errorMessage);
        }
    }

    @Override
    public void branchRollback(ContextStep2 context) throws SQLException {
        ITxcDataSource db = TxcAtomDataSourceHelper.getTxcDataSource(context.getDbname());
        logger.info(String.format("[%d:%d] start branchRollback [%s]", TxcXID.getTransactionId(context.getXid()), context.getBranchId(), db.getDbName()));
        try {
            this._branchRollback(context, db);
        }
        catch (Exception e) {
            if (e instanceof TxcException) {
                throw (TxcException)e;
            }
            if (e instanceof SQLException) {
                logger.info(String.format("branchRollback error code:%d state:%s message:%s", ((SQLException)e).getErrorCode(), ((SQLException)e).getSQLState(), e.getMessage()));
                if (e.getMessage() != null && (e.getMessage().indexOf("read-only") != -1 || e.getMessage().indexOf("command denied") != -1 || e.getMessage().indexOf("not allowed") != -1)) {
                    logger.info(String.format("Start failOver rollback branchId:[%d] [%s]", context.getBranchId(), db.getDbName()));
                    Iterator<ITxcDataSource> failOverDsList = TxcAtomDataSourceHelper.getOtherDsInSameGroup(db);
                    if (this.failOverBranchRollback(context, failOverDsList)) {
                        return;
                    }
                }
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
    }

    @Override
    public void deleteUndoLog(ContextStep2 context, ITxcConnection template) throws SQLException {
        this.deleteUndoLog(Arrays.asList(context), template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cleanOldTxcLog(Integer cleanOldTxcDays) throws SQLException {
        int cleanRequire = 100;
        int cleanDays = 7;
        if (cleanOldTxcDays != null) {
            if (cleanOldTxcDays <= 0) {
                return;
            }
            cleanDays = cleanOldTxcDays;
        }
        for (String dbKey : TxcAtomDataSourceHelper.getCacheDataSourceMap().keySet()) {
            long endTime;
            ITxcDataSource db = TxcAtomDataSourceHelper.getCacheDataSourceMap().get(dbKey);
            long startTime = System.currentTimeMillis();
            CleanResult cleanResult = new CleanResult();
            try {
                this._cleanOldTxcLog(db, cleanOldTxcDays, cleanRequire, cleanResult);
                logger.info("TxcLogManager _cleanOldTxcLog invoked.");
            }
            catch (Exception e) {
                try {
                    logger.info(String.format("clean old undo log ignore failed on dbKey:%s %s", dbKey, e.getMessage()));
                }
                catch (Throwable throwable) {
                    long endTime2 = System.currentTimeMillis();
                    logger.info(String.format("clean old undo log dbKey:%s appName:%s dbName:%s total:%d with days:%d cost:%d ms", dbKey, db.getAppName(), db.getDbName(), cleanResult.totalClean, cleanDays, endTime2 - startTime));
                    throw throwable;
                }
                endTime = System.currentTimeMillis();
                logger.info(String.format("clean old undo log dbKey:%s appName:%s dbName:%s total:%d with days:%d cost:%d ms", dbKey, db.getAppName(), db.getDbName(), cleanResult.totalClean, cleanDays, endTime - startTime));
                continue;
            }
            endTime = System.currentTimeMillis();
            logger.info(String.format("clean old undo log dbKey:%s appName:%s dbName:%s total:%d with days:%d cost:%d ms", dbKey, db.getAppName(), db.getDbName(), cleanResult.totalClean, cleanDays, endTime - startTime));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void deleteUndoLog(List<ContextStep2> contexts, ITxcConnection txcConn) throws SQLException {
        long start;
        String ids;
        block9: {
            if (contexts.isEmpty()) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            StringBuilder sqlsb = new StringBuilder("delete from ");
            sqlsb.append(txcLogTableName);
            sqlsb.append(" where id in (");
            boolean flag = false;
            for (ContextStep2 c : contexts) {
                if (flag) {
                    sb.append(",");
                } else {
                    flag = true;
                }
                sb.append(c.getBranchId());
            }
            ids = sb.toString();
            sqlsb.append(ids).append(")");
            start = System.currentTimeMillis();
            PreparedStatement pst = null;
            try {
                pst = txcConn.getTargetConnection().prepareStatement(sqlsb.toString());
                pst.executeUpdate();
                if (pst == null) break block9;
            }
            catch (Throwable e) {
                try {
                    logger.error(TxcErrCode.DBDeleteUndoError, e);
                    if (!(e instanceof SQLException)) throw new SQLException(e);
                    throw (SQLException)e;
                }
                catch (Throwable throwable) {
                    if (pst != null) {
                        pst.close();
                    }
                    long end = System.currentTimeMillis();
                    logger.info(String.format("delete [%s] cost %d ms.", ids, end - start));
                    throw throwable;
                }
            }
            pst.close();
        }
        long end = System.currentTimeMillis();
        logger.info(String.format("delete [%s] cost %d ms.", ids, end - start));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TxcRuntimeContext selectUndoLog(String txid, long branchId, ITxcConnection conn) throws SQLException, IOException {
        ArrayList<TxcRuntimeContext> contents;
        block9: {
            String sql = String.format("select * from %s where status = 0 and id = %d order by id desc for update", txcLogTableName, branchId);
            logger.info(String.format("[%d:%d] [%s]", TxcXID.getTransactionId(txid), branchId, sql));
            contents = new ArrayList<TxcRuntimeContext>();
            long start = 0L;
            if (logger.isDebugEnabled()) {
                start = System.currentTimeMillis();
            }
            try {
                String log = conn.getUndoLog(conn, sql);
                if (StringUtils.isNotEmpty((String)log)) {
                    TxcRuntimeContext c = TxcRuntimeContext.decode(log);
                    contents.add(c);
                }
                if (!logger.isDebugEnabled()) break block9;
            }
            catch (Throwable throwable) {
                if (logger.isDebugEnabled()) {
                    long end = System.currentTimeMillis();
                    logger.debug(String.format("selectUndoLog:[%s] cost %d ms.", sql, end - start));
                }
                throw throwable;
            }
            long end = System.currentTimeMillis();
            logger.debug(String.format("selectUndoLog:[%s] cost %d ms.", sql, end - start));
        }
        if (contents == null || contents.size() == 0) {
            logger.info(String.format("[%s:%d] no txc_undo_log", txid, branchId));
            return null;
        }
        if (contents.size() > 1) {
            String errorLog = String.format("[%s:%d] check txc_undo_log, trx info duplicate", txid, branchId);
            logger.info(errorLog);
            throw new TxcException(errorLog);
        }
        int no = 0;
        TxcRuntimeContext resultContext = (TxcRuntimeContext)contents.get(0);
        Iterator<RollbackInfor> iterator = resultContext.getInforList().iterator();
        while (iterator.hasNext()) {
            RollbackInfor info = iterator.next();
            logger.info(String.format("[%d:%d] [%d/%d] [%s]", TxcXID.getTransactionId(txid), branchId, ++no, resultContext.getInforList().size(), info.getSql()));
        }
        return resultContext;
    }

    protected void setTableMeta(ITxcConnection conn, RollbackInfor info) throws SQLException {
        TxcTable o = info.getFrontImage();
        TxcTable p = info.getRearImage();
        String tablename = o.getTableName() == null ? p.getTableName() : o.getTableName();
        TxcTableMeta tablemeta = TxcMetaCache.getTableMeta(conn, tablename);
        o.setTableMeta(tablemeta);
        p.setTableMeta(tablemeta);
    }

    protected void checkDirtyRead(ITxcConnection conn, RollbackInfor info) throws SQLException {
        String selectSql = String.format("%s %s FOR UPDATE", info.getSelectSql(), info.getWhereCondition());
        String valueByLog = "";
        String valueBySql = "";
        StringBuilder retLog = new StringBuilder();
        long start = System.currentTimeMillis();
        try {
            TxcTable p = info.getRearImage();
            valueByLog = p.toString();
            retLog.append("--Log:[");
            retLog.append(valueByLog);
            retLog.append("]");
            TxcTable t = new TxcTable();
            t.setTableMeta(p.getTableMeta());
            t.addLines(conn, selectSql);
            valueBySql = t.toString();
            retLog.append("--Db_:[");
            retLog.append(valueBySql);
            retLog.append("]");
        }
        catch (SQLException e) {
            throw new TxcException(e, info.getXid() + ":" + info.getBid() + "checkDirtyWrite error:" + retLog.toString());
        }
        finally {
            logger.info("[" + TxcXID.getTransactionId(info.getXid()) + ":" + info.getBid() + "]  [" + selectSql + "]  [ cost " + (System.currentTimeMillis() - start) + " ms]");
        }
        if (!(valueByLog.equals(valueBySql) || info.sqlType == SqlType.INSERT && StringUtils.isEmpty((String)valueBySql))) {
            throw new TxcException(ResultCode.LOGICERROR.getValue(), info.getXid() + ":" + info.getBid() + " dirty write: " + retLog.toString());
        }
    }

    public static String getConnInfor(ITxcConnection txcConn) {
        String infor = null;
        try {
            Connection conn = txcConn.getTargetConnection();
            infor = String.format("conn:%d:%B", conn.hashCode(), conn.getAutoCommit());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return infor;
    }

    public static String getDbKey(ITxcConnection txcConn) {
        String dbkey = null;
        try {
            dbkey = txcConn.getTxcDataSource().getDbName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return dbkey;
    }

    private void _branchRollback(ContextStep2 context, ITxcDataSource db) throws Exception {
        ITxcConnection conn = null;
        try {
            conn = (ITxcConnection)db.getConnection();
            conn.getTargetConnection().setAutoCommit(false);
            TxcRuntimeContext undolog = this.selectUndoLog(context.getXid(), context.getBranchId(), conn);
            if (undolog == null) {
                return;
            }
            for (int i = undolog.getInforList().size(); i > 0; --i) {
                RollbackInfor info = undolog.getInforList().get(i - 1);
                info.setXid(context.getXid());
                info.setBid(context.getBranchId());
                logger.info(String.format("[%d:%d] [%s]", TxcXID.getTransactionId(context.getXid()), context.getBranchId(), info.getSql()));
                this.setTableMeta(conn, info);
                if (info.getRollbackRule() == null || info.getRollbackRule().isEmpty()) {
                    this.checkDirtyRead(conn, info);
                }
                AbstractUndoExcutor.createTxcUndoExcutor(info).rollback(conn);
            }
            this.deleteUndoLog(context, conn);
            conn.getTargetConnection().commit();
        }
        catch (Exception e) {
            if (conn != null) {
                conn.getTargetConnection().rollback();
            }
            throw e;
        }
        finally {
            if (conn != null) {
                conn.getTargetConnection().setAutoCommit(true);
                conn.close();
            }
        }
    }

    private boolean failOverBranchRollback(ContextStep2 context, Iterator<ITxcDataSource> dbList) throws SQLException {
        while (dbList.hasNext()) {
            ITxcDataSource db = dbList.next();
            try {
                logger.info(String.format("[%d:%d] start failOver branchRollback [%s]", TxcXID.getTransactionId(context.getXid()), context.getBranchId(), db.getDbName()));
                this._branchRollback(context, db);
                return true;
            }
            catch (Exception e) {
                logger.info(String.format("failOver rollback branchId:[%d] [%s] failed.", context.getBranchId(), db.getDbName()));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _cleanOldTxcLog(ITxcDataSource db, int cleanDays, int cleanRequire, CleanResult cleanResult) throws SQLException {
        ITxcConnection conn = null;
        try {
            conn = (ITxcConnection)db.getConnection();
            while (true) {
                int count = conn.cleanOldUndoLog(txcLogTableName, cleanDays, cleanRequire);
                logger.info("_cleanOldTxcLog just cleaned " + count + " while requiring " + cleanRequire);
                cleanResult.totalClean += (long)count;
                ++cleanResult.round;
                if (count < cleanRequire) {
                    logger.info("_cleanOldTxcLog exit when count: " + count + " totalClean: " + cleanResult.totalClean + " round: " + cleanResult.round);
                    break;
                }
                if (conn != null) {
                    logger.info("_cleanOldTxcLog connection[AutoCommit=" + conn.getAutoCommit() + "] released.");
                    conn.close();
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                conn = (ITxcConnection)db.getConnection();
                logger.info("_cleanOldTxcLog got a new connection");
            }
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    class CleanResult {
        long totalClean = 0L;
        long round = 0L;

        CleanResult() {
        }
    }
}

