/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor.rc;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.exception.TxcLockConflictException;
import com.taobao.txc.common.util.string.TxcString;
import com.taobao.txc.parser.struct.SqlType;
import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.struct.UndoLogMode;
import com.taobao.txc.parser.visitor.api.ITxcUpdateVisitor;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.executor.DefaultExecutor;
import com.taobao.txc.resourcemanager.executor.SpinLockHelper;
import com.taobao.txc.resourcemanager.executor.TxcLogManager;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang.exception.ExceptionUtils;

public class AtExecutorRC<T>
extends DefaultExecutor<T> {
    private static final LoggerWrap logger = LoggerInit.logger;

    public AtExecutorRC(ITxcConnection conn, ITxcStatement st, ISqlExecutor<T> sqlExecutor, ITxcVisitor sqlVisitor) throws SQLException {
        super(conn, st, sqlExecutor, sqlVisitor);
    }

    public T updateAutoCommitFalse(Object ... args) throws SQLException {
        ITxcVisitor sqlVisitor = this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        ISqlExecutor sqlExecutor = this.getSqlExecutor();
        Object bRet = sqlExecutor.mockExecute(0);
        Statement statement = txcSt.getTargetStatement();
        TxcRuntimeContext context = txcConn.getTxcRuntimeContext();
        sqlVisitor.getFrontImage().clear();
        sqlVisitor.getRearImage().clear();
        if (logger.isAnalyzeEnabled()) {
            AnalyzeLogger.getInstance().getLastCost();
        }
        String writeKeys = null;
        SqlType sqlType = sqlVisitor.getSQLExplain().getSqlType();
        if (sqlType != SqlType.INSERT && sqlType != SqlType.UPDATE && sqlType != SqlType.DELETE) {
            throw new SQLException("unsupported sqltype:" + sqlType.value());
        }
        TxcTable frontImage = null;
        frontImage = bRet instanceof Integer && sqlVisitor instanceof ITxcUpdateVisitor ? ((ITxcUpdateVisitor)sqlVisitor).executeAndGetFrontImage(txcSt, true) : sqlVisitor.executeAndGetFrontImage(txcSt);
        if (logger.isAnalyzeEnabled()) {
            context.setFrontImageCost(AnalyzeLogger.getInstance().getLastCost());
        }
        boolean updateAndCommitOnSuccess = false;
        if (bRet instanceof Integer && sqlVisitor instanceof ITxcUpdateVisitor && (updateAndCommitOnSuccess = ((ITxcUpdateVisitor)sqlVisitor).isCommitOnSuccess())) {
            logger.info("COMMIT_ON_SUCCESS_BRANCH ON :" + context.getXid());
            context.addUndoLog(sqlVisitor);
            this.getTxcConn().registTrxBranchWithLocksRetry(context.getWriteKeys());
            logger.info("COMMIT_ON_SUCCESS_BRANCH:" + context.getBranchId() + "/" + context.getXid() + " is registered");
            context.setServer(TxcXID.getServerAddress(context.getXid()));
            context.setStatus(UndoLogMode.COMMON_LOG.getValue());
            if (context.getInforList().size() > 0) {
                TxcLogManager.flushUndoLog(this.getTxcConn(), context);
            }
            logger.info(String.format("[%d:%d] COMMIT_ON_SUCCESS_BRANCH rt cost %d ms", TxcContext.getTransactionId(), context.getBranchId(), context.getRT()));
            this.getTxcConn().reportBranchStatus(true);
            logger.info("COMMIT_ON_SUCCESS_BRANCH:" + context.getBranchId() + "/" + context.getXid() + " is reported");
        }
        bRet = sqlExecutor.execute(statement, args);
        if (updateAndCommitOnSuccess) {
            return bRet;
        }
        boolean rearImageNeeded = true;
        if (bRet instanceof Integer && sqlVisitor instanceof ITxcUpdateVisitor) {
            boolean hotDataResolved = ((ITxcUpdateVisitor)sqlVisitor).isHotDataResolved();
            if (logger.isDebugEnabled()) {
                logger.debug("hotDataResolved: " + hotDataResolved + " bRet: " + bRet);
            }
            if (hotDataResolved) {
                int affectRowCount;
                int n = affectRowCount = bRet == null ? 0 : (Integer)bRet;
                if (affectRowCount > 1) {
                    throw new TxcException("Should Never Happen. affectRowCount(" + affectRowCount + ") for hot data.");
                }
                if (affectRowCount < 1) {
                    sqlVisitor.getFrontImage().clear();
                    if (logger.isDebugEnabled()) {
                        logger.debug("FrontImage is cleaned");
                    }
                } else {
                    rearImageNeeded = false;
                    if (logger.isDebugEnabled()) {
                        logger.debug("RearImage Ignore For Resovled Hot Data");
                    }
                }
            }
        }
        if (rearImageNeeded && (sqlType != SqlType.UPDATE && sqlType != SqlType.DELETE || frontImage.linesNum() != 0)) {
            if (logger.isAnalyzeEnabled()) {
                context.setSqlCost(AnalyzeLogger.getInstance().getLastCost());
            }
            TxcTable rearImage = sqlVisitor.executeAndGetRearImage(txcSt);
            if (logger.isAnalyzeEnabled()) {
                context.setRearImageCost(AnalyzeLogger.getInstance().getLastCost());
            }
            if (sqlType == SqlType.DELETE) {
                if (frontImage != null) {
                    writeKeys = txcConn.getWriteKeys(frontImage);
                }
            } else if (rearImage != null) {
                writeKeys = txcConn.getWriteKeys(rearImage);
            }
        }
        context.appendWriteKeys(writeKeys);
        context.addUndoLog(sqlVisitor);
        return bRet;
    }

    public T updateAutoCommitTrue(Object ... args) throws SQLException {
        ITxcVisitor sqlVisitor = this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        ISqlExecutor sqlExecutor = this.getSqlExecutor();
        Object bRet = sqlExecutor.mockExecute(0);
        SpinLockHelper sh = new SpinLockHelper();
        Connection conn = txcConn.getTargetConnection();
        Statement statement = txcSt.getTargetStatement();
        TxcRuntimeContext context = txcConn.getTxcRuntimeContext();
        try {
            while (true) {
                try {
                    txcConn.setAutoCommit(false);
                    sqlVisitor.getFrontImage().clear();
                    sqlVisitor.getRearImage().clear();
                    if (logger.isAnalyzeEnabled()) {
                        context.setFrontImageCost(0L).setSqlCost(0L).setRearImageCost(0L);
                        AnalyzeLogger.getInstance().getLastCost();
                    }
                    String writeKeys = null;
                    SqlType sqlType = sqlVisitor.getSQLExplain().getSqlType();
                    if (sqlType != SqlType.INSERT && sqlType != SqlType.UPDATE && sqlType != SqlType.DELETE) {
                        throw new SQLException("unsupported sqltype:" + sqlType.value());
                    }
                    TxcTable frontImage = sqlVisitor.executeAndGetFrontImage(txcSt);
                    if (logger.isAnalyzeEnabled()) {
                        context.setFrontImageCost(AnalyzeLogger.getInstance().getLastCost());
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("will execute user sql");
                    }
                    bRet = sqlExecutor.execute(statement, args);
                    if ((sqlType == SqlType.UPDATE || sqlType == SqlType.DELETE) && frontImage.linesNum() == 0) {
                        logger.info("update or delete affect lines zero.");
                        break;
                    }
                    if (logger.isAnalyzeEnabled()) {
                        context.setSqlCost(AnalyzeLogger.getInstance().getLastCost());
                    }
                    TxcTable rearImage = sqlVisitor.executeAndGetRearImage(txcSt);
                    if (logger.isAnalyzeEnabled()) {
                        context.setRearImageCost(AnalyzeLogger.getInstance().getLastCost());
                    }
                    if (sqlType == SqlType.DELETE) {
                        if (frontImage != null) {
                            writeKeys = txcConn.getWriteKeys(frontImage);
                        }
                    } else if (rearImage != null) {
                        writeKeys = txcConn.getWriteKeys(rearImage);
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("will register branch, writeKeys:" + writeKeys);
                    }
                    txcConn.registTrxBranchWithLocks(writeKeys);
                }
                catch (TxcLockConflictException e) {
                    conn.rollback();
                    sh.sleep(e);
                    continue;
                }
                break;
            }
            context.addUndoLog(sqlVisitor);
            txcConn.commit();
        }
        catch (Throwable e) {
            txcConn.rollback();
            logger.error("null", ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new SQLException(e);
        }
        finally {
            txcConn.setAutoCommit(true);
        }
        return bRet;
    }

    @Override
    public T execute(Object ... args) throws SQLException {
        String tableName = this.getSqlVisitor().getSQLExplain().getTableName();
        if (skipTablePattern == null ? "sequence".compareToIgnoreCase(tableName) == 0 || "sequence_opt".compareToIgnoreCase(tableName) == 0 || tableName.toLowerCase().startsWith("sequence_opt_mem_") : TxcString.isMatchTable(tableName.toLowerCase(), skipTablePattern.toLowerCase())) {
            return this.getSqlExecutor().execute(this.getTxcSt().getTargetStatement(), args);
        }
        if (this.getTxcConn().getAutoCommit()) {
            return this.updateAutoCommitTrue(args);
        }
        return this.updateAutoCommitFalse(args);
    }
}

