/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor.rc;

import com.taobao.txc.common.exception.TxcLockConflictException;
import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.executor.SpinLockHelper;
import com.taobao.txc.resourcemanager.executor.rc.AtExecutorRC;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertDupKeyRC<T>
extends AtExecutorRC<T> {
    public InsertDupKeyRC(ITxcConnection conn, ITxcStatement st, ISqlExecutor<T> sqlExecutor, ITxcVisitor sqlVisitor) throws SQLException {
        super(conn, st, sqlExecutor, sqlVisitor);
    }

    @Override
    public T updateAutoCommitFalse(Object ... args) throws SQLException {
        ITxcVisitor sqlVisitor = this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        ISqlExecutor sqlExecutor = this.getSqlExecutor();
        Object bRet = sqlExecutor.mockExecute(0);
        Statement statement = txcSt.getTargetStatement();
        TxcRuntimeContext context = txcConn.getTxcRuntimeContext();
        sqlVisitor.getFrontImage().clear();
        sqlVisitor.getRearImage().clear();
        String selectForUpdate = sqlVisitor.getSelectSql() + sqlVisitor.getWhereCondition(txcSt) + " FOR UPDATE";
        sqlVisitor.setFrontImage(sqlVisitor.executeFront(txcSt, selectForUpdate));
        bRet = sqlExecutor.execute(statement, args);
        sqlVisitor.setRearImage(sqlVisitor.executeRear(txcSt, selectForUpdate));
        String writeKeys = txcConn.getWriteKeys(sqlVisitor.getRearImage());
        context.appendWriteKeys(writeKeys);
        context.addUndoLog(sqlVisitor);
        return bRet;
    }

    @Override
    public T updateAutoCommitTrue(Object ... args) throws SQLException {
        ITxcVisitor sqlVisitor = this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        ISqlExecutor sqlExecutor = this.getSqlExecutor();
        Object bRet = sqlExecutor.mockExecute(0);
        SpinLockHelper sh = new SpinLockHelper();
        Connection conn = txcConn.getTargetConnection();
        Statement statement = txcSt.getTargetStatement();
        try {
            while (true) {
                try {
                    txcConn.setAutoCommit(false);
                    sqlVisitor.getFrontImage().clear();
                    sqlVisitor.getRearImage().clear();
                    String selectForUpdate = sqlVisitor.getSelectSql() + sqlVisitor.getWhereCondition(txcSt) + " FOR UPDATE";
                    sqlVisitor.setFrontImage(sqlVisitor.executeFront(txcSt, selectForUpdate));
                    bRet = sqlExecutor.execute(statement, args);
                    sqlVisitor.setRearImage(sqlVisitor.executeRear(txcSt, selectForUpdate));
                    String writeKeys = txcConn.getWriteKeys(sqlVisitor.getRearImage());
                    txcConn.registTrxBranchWithLocks(writeKeys);
                }
                catch (TxcLockConflictException e) {
                    conn.rollback();
                    sh.sleep(e);
                    continue;
                }
                break;
            }
            TxcRuntimeContext context = txcConn.getTxcRuntimeContext();
            context.addUndoLog(sqlVisitor);
            txcConn.commit();
        }
        catch (Throwable e) {
            txcConn.rollback();
            throw new SQLException(e);
        }
        finally {
            txcConn.setAutoCommit(true);
        }
        return bRet;
    }
}

