/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor.rc;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcLockConflictException;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.parser.visitor.api.ITxcSelectVisitor;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.parser.visitor.cache.TxcMetaCache;
import com.taobao.txc.resourcemanager.executor.SpinLockHelper;
import com.taobao.txc.resourcemanager.executor.rc.AtExecutorRC;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class SelectForUpdateRC<T>
extends AtExecutorRC<T> {
    private static final LoggerWrap logger = LoggerInit.logger;

    public SelectForUpdateRC(ITxcConnection conn, ITxcStatement st, ISqlExecutor<T> sqlExecutor, ITxcVisitor sqlVisitor) throws SQLException {
        super(conn, st, sqlExecutor, sqlVisitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T execute(Object ... args) throws SQLException {
        ITxcSelectVisitor sqlVisitor = (ITxcSelectVisitor)this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        Connection conn = txcConn.getTargetConnection();
        Statement statement = txcSt.getTargetStatement();
        TxcTableMeta tableMeta = TxcMetaCache.getTableMeta(sqlVisitor, txcConn);
        TxcDbType dbType = txcConn.getDsType();
        ResultSet rs = null;
        Savepoint sp = null;
        SpinLockHelper sh = new SpinLockHelper();
        boolean originalAutoCommit = conn.getAutoCommit();
        try {
            if (originalAutoCommit) {
                conn.setAutoCommit(false);
            }
            sp = conn.setSavepoint();
            while (true) {
                try {
                    rs = statement.executeQuery(sqlVisitor.getUserSql0());
                    TxcTable thisTable = new TxcTable();
                    thisTable.setTableMeta(tableMeta);
                    thisTable.setTableName(tableMeta.getTableName());
                    thisTable.setAlias(tableMeta.getAlias());
                    thisTable.setSchemaName(tableMeta.getSchemaName());
                    String sqlSelectAll = sqlVisitor.getSelectSql(true) + sqlVisitor.getWhereCondition((ITxcStatement)null);
                    thisTable.addLines(txcConn, sqlSelectAll);
                    String writeKeys = txcConn.getWriteKeys(thisTable);
                    txcConn.queryReadLocks(txcSt, writeKeys, sqlVisitor);
                }
                catch (TxcLockConflictException e) {
                    conn.rollback(sp);
                    sh.sleep(e);
                    continue;
                }
                catch (Throwable e) {
                    logger.error("AT mode ", e.getMessage(), e);
                    throw new SQLException(e);
                }
                break;
            }
        }
        finally {
            if (null != sp && dbType != TxcDbType.ORACLE) {
                conn.releaseSavepoint(sp);
            }
            if (originalAutoCommit) {
                conn.setAutoCommit(true);
            }
        }
        return (T)(rs == null ? null : rs);
    }
}

