/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor.rc;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcLockConflictException;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.parser.visitor.api.ITxcSelectVisitor;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.parser.visitor.cache.TxcMetaCache;
import com.taobao.txc.resourcemanager.executor.SpinLockHelper;
import com.taobao.txc.resourcemanager.executor.rc.AtExecutorRC;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;

public class SelectRCWithTxcHint<T>
extends AtExecutorRC<T> {
    private static final LoggerWrap logger = LoggerInit.logger;

    public SelectRCWithTxcHint(ITxcConnection conn, ITxcStatement st, ISqlExecutor<T> sqlExecutor, ITxcVisitor sqlVisitor) throws SQLException {
        super(conn, st, sqlExecutor, sqlVisitor);
    }

    /*
     * Loose catch block
     */
    @Override
    public T execute(Object ... args) throws SQLException {
        ITxcSelectVisitor sqlVisitor = (ITxcSelectVisitor)this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        Connection conn = txcConn.getTargetConnection();
        Statement statement = txcSt.getTargetStatement();
        TxcTableMeta tableMeta = TxcMetaCache.getTableMeta(sqlVisitor, txcConn);
        if (conn.getAutoCommit()) {
            throw new SQLException("txc ReadCommited level should set autocommit false first.");
        }
        ResultSet rs0 = null;
        ResultSet rs = null;
        Savepoint sp = null;
        SpinLockHelper sh = new SpinLockHelper();
        while (true) {
            try {
                String sql = sqlVisitor.getUserSql0() + " LOCK IN SHARE MODE";
                sp = conn.setSavepoint();
                rs = statement.executeQuery(sql);
                TxcTable thisTable = new TxcTable();
                thisTable.setTableMeta(tableMeta);
                thisTable.setTableName(tableMeta.getTableName());
                thisTable.setAlias(tableMeta.getAlias());
                thisTable.setSchemaName(tableMeta.getSchemaName());
                String sqlSelectAll = sqlVisitor.getSelectSql() + sqlVisitor.getWhereCondition((ITxcStatement)null);
                thisTable.addLines(txcConn, sqlSelectAll);
                String writeKeys = txcConn.getWriteKeys(thisTable);
                txcConn.queryReadLocks(txcSt, writeKeys, sqlVisitor);
                rs0 = statement.executeQuery(sqlVisitor.getSelectSqlByPK(thisTable));
                conn.releaseSavepoint(sp);
                if (rs == null) break;
            }
            catch (TxcLockConflictException e) {
                conn.rollback(sp);
                sh.sleep(e);
                continue;
            }
            catch (Throwable e2) {
                logger.error("AT mode ", e2.getMessage(), e2);
                throw new SQLException(e2);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                conn.releaseSavepoint(sp);
                if (rs == null) continue;
                rs.close();
                continue;
            }
            rs.close();
            break;
        }
        return (T)(rs0 == null ? null : rs0);
    }
}

