/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor.rt;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.message.BeginRetryBranchResultMessage;
import com.taobao.txc.parser.visitor.TxcVisitorFactory;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.executor.api.IRtExecutor;
import com.taobao.txc.resourcemanager.jdbc.TxcAtomDataSourceHelper;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import com.taobao.txc.resourcemanager.jdbc.warpper.TxcPreparedStatementWrapper;
import com.taobao.txc.resourcemanager.rt.RtResourceManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class RtExecutor<T>
implements IRtExecutor<T> {
    private static final LoggerWrap logger = LoggerInit.logger;
    private final ITxcStatement txcSt;
    private final ITxcConnection txcConn;
    private final ISqlExecutor<T> sqlExecutor;

    public RtExecutor(ITxcConnection txcConn, ITxcStatement txcSt, ISqlExecutor<T> sqlExecutor) throws SQLException {
        this.txcSt = txcSt;
        this.txcConn = txcConn;
        this.sqlExecutor = sqlExecutor;
        logger.info(String.format("%s", txcSt.getTargetSql()));
    }

    public String getFullSql() throws SQLException {
        if (this.txcSt instanceof TxcPreparedStatementWrapper) {
            TxcPreparedStatementWrapper pst = (TxcPreparedStatementWrapper)this.txcSt;
            ITxcVisitor visitor = TxcVisitorFactory.getSqlVisitor(pst.getTargetSql());
            visitor.setTxcStatement(this.txcSt);
            return visitor.getUserSql0();
        }
        return this.txcSt.getTargetSql();
    }

    public static void executeSql(String xid, long branchId, String dbName, String retrySql) throws SQLException {
        if (retrySql == null) {
            return;
        }
        logger.info(String.format("RtExecutor retry %s:%d %s", xid, branchId, retrySql));
        try {
            DataSource db = TxcAtomDataSourceHelper.getTxcDataSource(dbName).getTargetDataSource();
            JdbcTemplate jdbcTemplate = new JdbcTemplate(db);
            jdbcTemplate.execute(retrySql);
        }
        catch (DataAccessException e) {
            SQLException sqle = (SQLException)e.getCause();
            if (sqle.getErrorCode() == 1062) {
                logger.info("RtExecutor retry sql:" + e.getMessage() + ":" + retrySql);
            }
            throw sqle;
        }
    }

    @Override
    public T execute(Object ... args) throws SQLException {
        T bRet;
        block2: {
            bRet = this.sqlExecutor.mockExecute(0);
            try {
                bRet = this.sqlExecutor.execute(this.txcSt.getTargetStatement(), args);
            }
            catch (SQLException e) {
                String fullSql = this.getFullSql();
                BeginRetryBranchResultMessage resultMessage = RtResourceManager.getRtResourceManager().beginRtBranch(this.txcConn.getTxcDataSource(), fullSql);
                if (resultMessage != null) break block2;
                logger.error(TxcErrCode.BeginRtBranch.errCode, e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return bRet;
    }
}

