/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor.template;

import com.alibaba.fastjson.JSON;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.parser.struct.TxcField;
import com.taobao.txc.parser.struct.TxcLine;
import com.taobao.txc.parser.struct.TxcTableMeta;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.StatementCreatorUtils;

public class MySQLExecutorTemplate {
    private static final LoggerWrap logger = LoggerInit.logger;
    private final ITxcConnection conn;

    public MySQLExecutorTemplate(ITxcConnection conn) throws SQLException {
        this.conn = conn;
    }

    private void appendEscape(StringBuilder sb) throws SQLException {
        if (this.conn.getDsType() != TxcDbType.ORACLE) {
            sb.append('`');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByPks(TxcLine line, TxcTableMeta meta) throws SQLException {
        String name;
        StringBuilder appender = new StringBuilder();
        appender.append("UPDATE ");
        appender.append(meta.getTableName());
        appender.append(" SET ");
        List<TxcField> fields = line.getFieldsList();
        boolean bStokFlag = true;
        for (TxcField field : fields) {
            if (this.conn.getDsType() == TxcDbType.PETADATA && field.isKey(meta.getPkName()) || (name = field.getName()) == null) continue;
            if (bStokFlag) {
                bStokFlag = false;
            } else {
                appender.append(", ");
            }
            if (name.charAt(0) == '`' || name.charAt(0) == '\"') {
                appender.append(name);
            } else if (this.conn.getDsType() == TxcDbType.POSTGRESQL) {
                appender.append(name.toLowerCase());
            } else {
                this.appendEscape(appender);
                appender.append(name);
                this.appendEscape(appender);
            }
            appender.append("=");
            appender.append('?');
        }
        appender.append(" WHERE ");
        bStokFlag = true;
        for (TxcField field : fields) {
            if (!field.isKey(meta.getPkName()) || (name = field.getName()) == null) continue;
            if (bStokFlag) {
                bStokFlag = false;
            } else {
                appender.append(" AND ");
            }
            if (name.charAt(0) == '`' || name.charAt(0) == '\"') {
                appender.append(name);
            } else if (this.conn.getDsType() == TxcDbType.POSTGRESQL) {
                appender.append(name.toLowerCase());
            } else {
                this.appendEscape(appender);
                appender.append(name);
                this.appendEscape(appender);
            }
            appender.append(" = ");
            appender.append('?');
        }
        Statement pst = null;
        try {
            logger.info("sql:" + appender.toString());
            pst = this.conn.getTargetConnection().prepareStatement(appender.toString());
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            if (this.conn.getDsType() == TxcDbType.PETADATA) {
                this.appendValuesAndTypesExcludingPK(fields, values, types, meta);
            } else {
                this.getValuesAndTypesAll(fields, values, types);
            }
            this.appendValuesAndTypesOfPK(fields, values, types, meta);
            this.setParameterValues((PreparedStatement)pst, values, types);
            pst.execute();
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateByRule(TxcLine line, TxcTableMeta meta, String rule) throws SQLException {
        StringBuilder appender = new StringBuilder();
        appender.append("UPDATE ");
        appender.append(meta.getTableName());
        appender.append(" SET ");
        appender.append(rule);
        appender.append(" WHERE ");
        boolean bStokFlag = true;
        List<TxcField> fields = line.getFieldsList();
        for (TxcField field : fields) {
            String name = field.getName();
            if (name == null) continue;
            if (bStokFlag) {
                bStokFlag = false;
            } else {
                appender.append(" AND ");
            }
            if (name.charAt(0) == '`' || name.charAt(0) == '\"') {
                appender.append(name);
            } else if (this.conn.getDsType() == TxcDbType.POSTGRESQL) {
                appender.append(name.toLowerCase());
            } else {
                this.appendEscape(appender);
                appender.append(name);
                this.appendEscape(appender);
            }
            appender.append(" = ");
            appender.append('?');
        }
        Statement pst = null;
        try {
            pst = this.conn.getTargetConnection().prepareStatement(appender.toString());
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<Integer> types = new ArrayList<Integer>();
            this.appendValuesAndTypes(fields, values, types, meta);
            this.setParameterValues((PreparedStatement)pst, values, types);
            pst.execute();
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertByLine(TxcLine line, TxcTableMeta meta) throws SQLException {
        String name;
        StringBuilder appender = new StringBuilder();
        List<TxcField> fields = line.getFieldsList();
        ArrayList<Object> values = new ArrayList<Object>();
        ArrayList<Integer> types = new ArrayList<Integer>();
        appender.append("INSERT INTO ");
        appender.append(meta.getTableName());
        appender.append("(");
        boolean bAndFlag = true;
        for (TxcField field : fields) {
            name = field.getName();
            if (name == null || null == field.getValue()) continue;
            if (bAndFlag) {
                bAndFlag = false;
            } else {
                appender.append(", ");
            }
            if (name.charAt(0) == '`' || name.charAt(0) == '\"') {
                appender.append(name);
                values.add(field.getValue());
                types.add(field.getType());
                continue;
            }
            if (this.conn.getDsType() == TxcDbType.POSTGRESQL) {
                appender.append(name.toLowerCase());
                values.add(field.getValue());
                types.add(field.getType());
                continue;
            }
            this.appendEscape(appender);
            appender.append(name);
            this.appendEscape(appender);
            values.add(field.getValue());
            types.add(field.getType());
        }
        appender.append(")");
        appender.append(" VALUES ");
        appender.append("(");
        bAndFlag = true;
        for (TxcField field : fields) {
            name = field.getName();
            if (name == null || null == field.getValue()) continue;
            if (bAndFlag) {
                bAndFlag = false;
            } else {
                appender.append(", ");
            }
            appender.append('?');
        }
        appender.append(")");
        logger.info("undo sql:" + appender.toString());
        Statement pst = null;
        try {
            pst = this.conn.getTargetConnection().prepareStatement(appender.toString());
            this.setParameterValues((PreparedStatement)pst, values, types);
            pst.execute();
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteByPK(List<TxcLine> lines, TxcTableMeta meta) throws SQLException {
        StringBuilder appender = new StringBuilder();
        appender.append("DELETE FROM ");
        appender.append(meta.getTableName());
        appender.append(" WHERE ");
        List<String> pks = meta.getPrimaryKeyOnlyName();
        boolean bStokFlag = true;
        for (String pk : pks) {
            if (bStokFlag) {
                bStokFlag = false;
            } else {
                appender.append(" AND ");
            }
            appender.append(pk);
            appender.append(" = ");
            appender.append("?");
        }
        Statement pst = null;
        try {
            pst = this.conn.getTargetConnection().prepareStatement(appender.toString());
            for (TxcLine line : lines) {
                ArrayList<Object> values = new ArrayList<Object>();
                ArrayList<Integer> types = new ArrayList<Integer>();
                for (TxcField field : line.getFieldsList()) {
                    if (!field.isKey(meta.getPkName())) continue;
                    values.add(field.getValue());
                    types.add(field.getType());
                    this.setParameterValues((PreparedStatement)pst, values, types);
                }
                pst.addBatch();
            }
            pst.executeBatch();
        }
        finally {
            if (pst != null) {
                pst.close();
            }
        }
    }

    private void getValuesAndTypesAll(List<TxcField> fields, List<Object> values, List<Integer> types) {
        for (TxcField field : fields) {
            values.add(field.getValue());
            types.add(field.getType());
        }
    }

    private void appendValuesAndTypes(List<TxcField> fields, List<Object> values, List<Integer> types, TxcTableMeta meta) {
        for (TxcField field : fields) {
            values.add(field.getValue());
            types.add(field.getType());
        }
    }

    private void appendValuesAndTypesOfPK(List<TxcField> fields, List<Object> values, List<Integer> types, TxcTableMeta meta) {
        for (TxcField field : fields) {
            if (!field.isKey(meta.getPkName())) continue;
            values.add(field.getValue());
            types.add(field.getType());
        }
    }

    private void appendValuesAndTypesExcludingPK(List<TxcField> fields, List<Object> values, List<Integer> types, TxcTableMeta meta) {
        for (TxcField field : fields) {
            if (field.isKey(meta.getPkName())) continue;
            values.add(field.getValue());
            types.add(field.getType());
        }
    }

    private void setParameterValues(PreparedStatement preparedStatement, List<Object> values, List<Integer> columnTypes) throws SQLException {
        for (int index = 0; index < values.size(); ++index) {
            MySQLExecutorTemplate.setParameterValue(preparedStatement, index + 1, columnTypes.get(index), values.get(index));
        }
    }

    public static void setParameterValue(PreparedStatement preparedStatement, int index, int type, Object value) throws SQLException {
        logger.info("setParameterValue index:" + index + ",type:" + type + ",value:" + value);
        if (value == null) {
            preparedStatement.setNull(index, type);
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            if (type == 91 || type == 92 || type == 93) {
                try {
                    if (type == 93) {
                        preparedStatement.setTimestamp(index, value == null ? null : new Timestamp(Long.parseLong(value.toString())));
                    }
                    if (type == 92) {
                        preparedStatement.setTime(index, value == null ? null : new Time(Long.parseLong(value.toString())));
                    }
                    try {
                        preparedStatement.setDate(index, value == null ? null : new Date(Long.parseLong(value.toString())));
                    }
                    catch (NumberFormatException ex) {
                        try {
                            Date date = (Date)JSON.parseObject((String)value.toString(), Date.class);
                            preparedStatement.setDate(index, date);
                        }
                        catch (Throwable tx) {
                            logger.info("Unknown Date: " + type + " " + value);
                            throw ex;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    try {
                        java.util.Date date = simpleDateFormat.parse(value.toString());
                        preparedStatement.setDate(index, new Date(date.getTime()));
                    }
                    catch (ParseException e1) {
                        throw new RuntimeException(e1);
                    }
                }
            } else if (type != 1111) {
                StatementCreatorUtils.setParameterValue((PreparedStatement)preparedStatement, (int)index, (int)type, (Object)value);
            } else {
                preparedStatement.setObject(index, value);
            }
        }
    }
}

