/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor.unrc;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.util.string.TxcString;
import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.executor.DefaultExecutor;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import java.sql.SQLException;
import java.sql.Statement;

public class AtExecutorUnRC<T>
extends DefaultExecutor<T> {
    private static final LoggerWrap logger = LoggerInit.logger;

    public AtExecutorUnRC(ITxcConnection conn, ITxcStatement st, ISqlExecutor<T> sqlExecutor, ITxcVisitor sqlVisitor) throws SQLException {
        super(conn, st, sqlExecutor, sqlVisitor);
    }

    public T updateAutoCommitTrue(Object ... args) throws SQLException {
        ITxcVisitor sqlVisitor = this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        ISqlExecutor sqlExecutor = this.getSqlExecutor();
        Object bRet = sqlExecutor.mockExecute(0);
        Statement statement = txcSt.getTargetStatement();
        TxcRuntimeContext context = txcConn.registTrxBranch(null);
        if (logger.isAnalyzeEnabled()) {
            AnalyzeLogger.getInstance().getLastCost();
        }
        txcConn.setAutoCommit(false);
        try {
            sqlVisitor.executeAndGetFrontImage(txcSt);
            if (logger.isAnalyzeEnabled()) {
                context.setFrontImageCost(AnalyzeLogger.getInstance().getLastCost());
            }
            bRet = sqlExecutor.execute(statement, args);
            if (logger.isAnalyzeEnabled()) {
                context.setSqlCost(AnalyzeLogger.getInstance().getLastCost());
            }
            sqlVisitor.executeAndGetRearImage(txcSt);
            if (logger.isAnalyzeEnabled()) {
                context.setRearImageCost(AnalyzeLogger.getInstance().getLastCost());
            }
            context.addUndoLog(sqlVisitor);
            txcConn.commit();
        }
        catch (Throwable e) {
            txcConn.rollback();
            throw new SQLException(e);
        }
        finally {
            txcConn.setAutoCommit(true);
        }
        return bRet;
    }

    public T updateAutoCommitFalse(Object ... args) throws SQLException {
        ITxcVisitor sqlVisitor = this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        ISqlExecutor sqlExecutor = this.getSqlExecutor();
        Object bRet = sqlExecutor.mockExecute(0);
        Statement statement = txcSt.getTargetStatement();
        TxcRuntimeContext context = txcConn.getTxcRuntimeContext();
        if (logger.isAnalyzeEnabled()) {
            AnalyzeLogger.getInstance().getLastCost();
        }
        try {
            sqlVisitor.executeAndGetFrontImage(txcSt);
            if (logger.isAnalyzeEnabled()) {
                context.setFrontImageCost(AnalyzeLogger.getInstance().getLastCost());
            }
            bRet = sqlExecutor.execute(statement, args);
            if (logger.isAnalyzeEnabled()) {
                context.setSqlCost(AnalyzeLogger.getInstance().getLastCost());
            }
            sqlVisitor.executeAndGetRearImage(txcSt);
            if (logger.isAnalyzeEnabled()) {
                context.setRearImageCost(AnalyzeLogger.getInstance().getLastCost());
            }
            context.addUndoLog(sqlVisitor);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
        return bRet;
    }

    @Override
    public T execute(Object ... args) throws SQLException {
        String tableName = this.getSqlVisitor().getSQLExplain().getTableName();
        if (skipTablePattern == null ? "sequence".compareToIgnoreCase(tableName) == 0 || "sequence_opt".compareToIgnoreCase(tableName) == 0 || tableName.toLowerCase().startsWith("sequence_opt_mem_") : TxcString.isMatchTable(tableName.toLowerCase(), skipTablePattern.toLowerCase())) {
            return this.getSqlExecutor().execute(this.getTxcSt().getTargetStatement(), args);
        }
        if (this.getTxcConn().getAutoCommit()) {
            return this.updateAutoCommitTrue(args);
        }
        return this.updateAutoCommitFalse(args);
    }
}

