/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.executor.unrc;

import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.executor.unrc.AtExecutorUnRC;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.api.ISqlExecutor;
import java.sql.SQLException;
import java.sql.Statement;

public class InsertDupKeyUnRC<T>
extends AtExecutorUnRC<T> {
    public InsertDupKeyUnRC(ITxcConnection conn, ITxcStatement st, ISqlExecutor<T> sqlExecutor, ITxcVisitor sqlVisitor) throws SQLException {
        super(conn, st, sqlExecutor, sqlVisitor);
    }

    @Override
    public T updateAutoCommitTrue(Object ... args) throws SQLException {
        ITxcVisitor sqlVisitor = this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        ISqlExecutor sqlExecutor = this.getSqlExecutor();
        Object bRet = sqlExecutor.mockExecute(0);
        Statement statement = txcSt.getTargetStatement();
        TxcRuntimeContext context = txcConn.registTrxBranch(null);
        txcConn.setAutoCommit(false);
        try {
            String selectForUpdate = sqlVisitor.getSelectSql() + sqlVisitor.getWhereCondition(txcSt) + " FOR UPDATE";
            sqlVisitor.setFrontImage(sqlVisitor.executeFront(txcSt, selectForUpdate));
            bRet = sqlExecutor.execute(statement, args);
            sqlVisitor.setRearImage(sqlVisitor.executeRear(txcSt, selectForUpdate));
            context.addUndoLog(sqlVisitor);
            txcConn.commit();
        }
        catch (Throwable e) {
            txcConn.rollback();
            throw new SQLException(e);
        }
        finally {
            txcConn.setAutoCommit(true);
        }
        return bRet;
    }

    @Override
    public T updateAutoCommitFalse(Object ... args) throws SQLException {
        ITxcVisitor sqlVisitor = this.getSqlVisitor();
        ITxcConnection txcConn = this.getTxcConn();
        ITxcStatement txcSt = this.getTxcSt();
        ISqlExecutor sqlExecutor = this.getSqlExecutor();
        Object bRet = sqlExecutor.mockExecute(0);
        Statement statement = txcSt.getTargetStatement();
        TxcRuntimeContext context = txcConn.getTxcRuntimeContext();
        try {
            String selectForUpdate = sqlVisitor.getSelectSql() + sqlVisitor.getWhereCondition(txcSt) + " FOR UPDATE";
            sqlVisitor.setFrontImage(sqlVisitor.executeFront(txcSt, selectForUpdate));
            bRet = sqlExecutor.execute(statement, args);
            sqlVisitor.setRearImage(sqlVisitor.executeRear(txcSt, selectForUpdate));
            context.addUndoLog(sqlVisitor);
        }
        catch (Throwable e) {
            throw new SQLException(e);
        }
        return bRet;
    }
}

