/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.jdbc;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcIsolation;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.analyze.AnalyzeLogger;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcUnSupportException;
import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.parser.struct.UndoLogMode;
import com.taobao.txc.resourcemanager.executor.TxcLogManager;
import com.taobao.txc.resourcemanager.jdbc.TxcResourceManagerHandler;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import com.taobao.txc.resourcemanager.jdbc.warpper.TxcCallableStatementWrapper;
import com.taobao.txc.resourcemanager.jdbc.warpper.TxcPreparedStatementWrapper;
import com.taobao.txc.resourcemanager.jdbc.warpper.TxcStatementWrapper;
import com.taobao.txc.rpc.impl.RpcClient;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.lang.StringUtils;

public abstract class DefaultTxcConnection
extends TxcResourceManagerHandler {
    private static final LoggerWrap logger = LoggerInit.logger;

    public DefaultTxcConnection(Connection targetConnection, ITxcDataSource targetDataSource) {
        super(targetConnection, targetDataSource);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (autoCommit == this.getAutoCommit()) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("[%d] [%s] [%s] [set autocommit = %B]", TxcContext.getTransactionId(), TxcLogManager.getConnInfor(this), TxcLogManager.getDbKey(this), autoCommit));
        }
        this.conn.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        block24: {
            if (logger.isAnalyzeEnabled()) {
                AnalyzeLogger.getInstance().getLastCost();
            }
            boolean status = false;
            try {
                TxcRuntimeContext context;
                if (TxcContext.inTxcTransaction()) {
                    context = this.getTxcRuntimeContext();
                    if (!context.isRegistBranch() && (StringUtils.isNotBlank((String)context.getWriteKeys()) || TxcConfigHolder.getInstance().getTxcGolbalLockMode(RpcClient.getVgroup()).equals((Object)TxcIsolation.READ_UNCOMMITED))) {
                        logger.info("register branch in commit, writeKey:" + context.getWriteKeys());
                        this.registTrxBranchWithLocksRetry(context.getWriteKeys());
                    }
                    if (context.isUndoLogFlushed()) {
                        logger.info("undo log already flushed before commit " + context.getBranchId() + "/" + context.getXid());
                    } else {
                        context.setServer(TxcXID.getServerAddress(context.getXid()));
                        context.setStatus(UndoLogMode.COMMON_LOG.getValue());
                        if (context.getInforList().size() > 0) {
                            TxcLogManager.flushUndoLog(this, context);
                        }
                        logger.info(String.format("[%d:%d] branch commit rt cost %d ms", TxcContext.getTransactionId(), context.getBranchId(), context.getRT()));
                        logger.info(String.format("[%d] [%s] [%s] [commit()]", TxcContext.getTransactionId(), TxcLogManager.getConnInfor(this), TxcLogManager.getDbKey(this)));
                    }
                }
                this.conn.commit();
                status = true;
                if (!TxcContext.inTxcTransaction() || !(context = this.getTxcRuntimeContext()).isRegistBranch()) break block24;
                try {
                    this.reportBranchStatus(true);
                    if (logger.isAnalyzeEnabled()) {
                        logger.analyze("tran.branch.end", TxcContext.getCurrentXid(), context.getBranchId(), "commit1", "1", "1", AnalyzeLogger.getInstance().getLastCost(), "", "");
                    }
                }
                catch (Throwable e) {
                    if (logger.isAnalyzeEnabled()) {
                        logger.analyze("tran.branch.end", TxcContext.getCurrentXid(), context.getBranchId(), "commit1", "1", "0", AnalyzeLogger.getInstance().getLastCost(), "", e.getMessage());
                    }
                }
            }
            catch (Throwable e) {
                block25: {
                    TxcRuntimeContext context;
                    if (!status) {
                        this.conn.rollback();
                    }
                    if (TxcContext.inTxcTransaction() && (context = this.getTxcRuntimeContext()).isRegistBranch()) {
                        try {
                            this.reportBranchStatus(status);
                            if (logger.isAnalyzeEnabled()) {
                                if (status) {
                                    logger.analyze("tran.branch.end", TxcContext.getCurrentXid(), context.getBranchId(), "commit1", "1", "1", AnalyzeLogger.getInstance().getLastCost(), "", "");
                                } else {
                                    logger.analyze("tran.branch.end", TxcContext.getCurrentXid(), context.getBranchId(), "rollback", "1", "1", AnalyzeLogger.getInstance().getLastCost(), "", "");
                                }
                            }
                        }
                        catch (Throwable th) {
                            if (status) {
                                logger.analyze("tran.branch.end", TxcContext.getCurrentXid(), context.getBranchId(), "commit1", "1", "0", AnalyzeLogger.getInstance().getLastCost(), "", th.getMessage());
                                break block25;
                            }
                            logger.analyze("tran.branch.end", TxcContext.getCurrentXid(), context.getBranchId(), "rollback", "1", "0", AnalyzeLogger.getInstance().getLastCost(), "", th.getMessage());
                        }
                    }
                }
                if (e instanceof SQLException) {
                    throw (SQLException)e;
                }
                throw new SQLException(e);
            }
            finally {
                this.txcContext = null;
            }
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (logger.isAnalyzeEnabled()) {
            AnalyzeLogger.getInstance().getLastCost();
        }
        try {
            logger.info(String.format("[%d] [%s] [%s] [rollback()]", TxcContext.getTransactionId(), TxcLogManager.getConnInfor(this), TxcLogManager.getDbKey(this)));
            this.conn.rollback();
            if (TxcContext.inTxcTransaction()) {
                TxcRuntimeContext context = this.getTxcRuntimeContext();
                if (context.isRegistBranch()) {
                    this.reportBranchStatus(false);
                    if (logger.isAnalyzeEnabled()) {
                        logger.analyze("tran.branch.end", TxcContext.getCurrentXid(), context.getBranchId(), "rollback", "1", "1", AnalyzeLogger.getInstance().getLastCost(), "", "");
                    }
                }
                logger.info(String.format("[%s:%d] branch rollback rt cost %d ms", TxcContext.getTransactionId(), context.getBranchId(), context.getRT()));
            }
        }
        catch (SQLException e) {
            TxcRuntimeContext context;
            if (logger.isAnalyzeEnabled() && TxcContext.inTxcTransaction() && (context = this.getTxcRuntimeContext()).isRegistBranch()) {
                logger.analyze("tran.branch.end", TxcContext.getCurrentXid(), context.getBranchId(), "rollback", "1", "0", AnalyzeLogger.getInstance().getLastCost(), "", e.getMessage());
            }
            throw e;
        }
        finally {
            this.txcContext = null;
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement st = this.conn.createStatement();
        TxcStatementWrapper stw = new TxcStatementWrapper(st, this);
        return stw;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement st = this.conn.createStatement(resultSetType, resultSetConcurrency);
        TxcStatementWrapper stw = new TxcStatementWrapper(st, this);
        return stw;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement st = this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        TxcStatementWrapper stw = new TxcStatementWrapper(st, this);
        return stw;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement cs = this.conn.prepareCall(sql);
        TxcCallableStatementWrapper csw = new TxcCallableStatementWrapper(cs, this, sql);
        return csw;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement cs = this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
        TxcCallableStatementWrapper csw = new TxcCallableStatementWrapper(cs, this, sql);
        return csw;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement cs = this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        TxcCallableStatementWrapper csw = new TxcCallableStatementWrapper(cs, this, sql);
        return csw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(sql);
        TxcPreparedStatementWrapper psw = new TxcPreparedStatementWrapper(ps, this, sql);
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(sql, autoGeneratedKeys);
        TxcPreparedStatementWrapper psw = new TxcPreparedStatementWrapper(ps, this, sql);
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(sql, columnIndexes);
        TxcPreparedStatementWrapper psw = new TxcPreparedStatementWrapper(ps, this, sql);
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(sql, columnNames);
        TxcPreparedStatementWrapper psw = new TxcPreparedStatementWrapper(ps, this, sql);
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        TxcPreparedStatementWrapper psw = new TxcPreparedStatementWrapper(ps, this, sql);
        return psw;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement ps = this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        TxcPreparedStatementWrapper psw = new TxcPreparedStatementWrapper(ps, this, sql);
        return psw;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.conn.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.conn.unwrap(iface);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        try {
            this.conn.close();
        }
        finally {
            this.txcContext = null;
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.conn.createArrayOf(typeName, elements);
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.conn.createStruct(typeName, attributes);
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.conn.getClientInfo(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.conn.isValid(timeout);
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.conn.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.conn.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        throw new TxcUnSupportException();
    }

    @Override
    public String getSchema() throws SQLException {
        throw new TxcUnSupportException();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new TxcUnSupportException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new TxcUnSupportException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new TxcUnSupportException();
    }

    @Override
    public abstract String getEncoding();

    @Override
    public abstract void setEncoding(String var1);
}

