/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.jdbc;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.NetUtil;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.parser.struct.RollbackInfor;
import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.parser.struct.UndoLogMode;
import com.taobao.txc.resourcemanager.RmRpcClient;
import com.taobao.txc.resourcemanager.executor.TxcLogManager;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;

public class TxcAtomDataSourceHelper {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final ConcurrentHashMap<String, ITxcDataSource> cacheDataSourceMap = new ConcurrentHashMap();
    private static final Set<String> serverAddrSet = Collections.synchronizedSet(new HashSet());
    private static final Map<ITxcDataSource, Map<String, String>> rtServerJournelMap = new ConcurrentHashMap<ITxcDataSource, Map<String, String>>();
    private static ConcurrentHashMap<String, List<ITxcDataSource>> dataSourceGroupMap = new ConcurrentHashMap();

    public static Map<String, ITxcDataSource> getCacheDataSourceMap() {
        return cacheDataSourceMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDataSource(String dbName, String groupKey, ITxcDataSource db) {
        cacheDataSourceMap.remove(dbName);
        if (!StringUtils.isEmpty((String)groupKey)) {
            ConcurrentHashMap<String, List<ITxcDataSource>> concurrentHashMap = dataSourceGroupMap;
            synchronized (concurrentHashMap) {
                List<ITxcDataSource> dbList = dataSourceGroupMap.get(groupKey);
                if (dbList != null && db != null) {
                    dbList.remove(db);
                }
            }
        }
    }

    public static ITxcDataSource getTxcDataSource(String dbName) {
        ITxcDataSource datasource = null;
        datasource = cacheDataSourceMap.get(dbName);
        if (datasource == null) {
            throw new TxcException("can not find datasource by dbName:[" + dbName + "]");
        }
        return datasource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ITxcDataSource ds, String dbName, String groupKey) {
        Object object = TxcAtomDataSourceHelper.class;
        synchronized (TxcAtomDataSourceHelper.class) {
            if (!cacheDataSourceMap.containsKey(dbName)) {
                cacheDataSourceMap.put(dbName, ds);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            object = dataSourceGroupMap;
            synchronized (object) {
                if (!StringUtils.isEmpty((String)groupKey)) {
                    List<ITxcDataSource> txcDataSourceList = dataSourceGroupMap.get(groupKey);
                    if (txcDataSourceList == null) {
                        dataSourceGroupMap.putIfAbsent(groupKey, new LinkedList());
                        txcDataSourceList = dataSourceGroupMap.get(groupKey);
                    }
                    txcDataSourceList.add(ds);
                }
            }
            RmRpcClient rmRpcClient = RmRpcClient.getInstance();
            if (rmRpcClient != null) {
                rmRpcClient.registerNewDbKey(dbName);
            }
            TxcAtomDataSourceHelper.selectServerAddrs(ds);
            return;
        }
    }

    public static void selectServerAddrs(ITxcDataSource db) {
        if (db == null) {
            logger.error(TxcErrCode.DiamondGetDbNull.errCode, "setRmRpcClient:[invalid datasource]");
            return;
        }
        try {
            JdbcTemplate template = new JdbcTemplate(db.getTargetDataSource());
            serverAddrSet.addAll(TxcLogManager.getAtServerList(template));
        }
        catch (Exception e) {
            logger.warn(TxcErrCode.DBUndologNotExist.errCode, "db:" + db.getDbName() + " not exist txc_undo_log." + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> getServerAddrs() {
        Class<TxcAtomDataSourceHelper> clazz = TxcAtomDataSourceHelper.class;
        synchronized (TxcAtomDataSourceHelper.class) {
            for (String key : cacheDataSourceMap.keySet()) {
                TxcAtomDataSourceHelper.selectServerAddrs(cacheDataSourceMap.get(key));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("server address:" + serverAddrSet);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return serverAddrSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDbKeysFromSet() {
        Class<TxcAtomDataSourceHelper> clazz = TxcAtomDataSourceHelper.class;
        synchronized (TxcAtomDataSourceHelper.class) {
            StringBuffer buffer = new StringBuffer();
            Set dbKeySet = cacheDataSourceMap.keySet();
            for (String key : dbKeySet) {
                buffer.append(key).append(',');
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return buffer.substring(0, buffer.length() > 0 ? buffer.length() - 1 : 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void checkRtJournel(ITxcDataSource dataSource, String serverAddress) throws SQLException {
        Map<String, String> serverMap = rtServerJournelMap.get(dataSource);
        if (!serverMap.containsKey(serverAddress)) {
            block9: {
                long address = -NetUtil.toLong(serverAddress);
                TxcRuntimeContext undoLog = new TxcRuntimeContext();
                undoLog.setBranchId(address);
                undoLog.setServer(serverAddress);
                undoLog.setStatus(UndoLogMode.RT_JOURNEL.getValue());
                undoLog.addInfor(new RollbackInfor());
                undoLog.setXid(TxcXID.generateXID(-1L));
                ITxcConnection conn = null;
                try {
                    conn = (ITxcConnection)dataSource.getConnection();
                    TxcLogManager.flushUndoLog(conn, undoLog);
                }
                catch (SQLException e) {
                    if (e.getErrorCode() == 1062) {
                        JdbcTemplate template = new JdbcTemplate(dataSource.getTargetDataSource());
                        List<?> rs = TxcLogManager.getServerList(template, undoLog.getXid(), undoLog.getBranchId());
                        if (rs.size() == 0) {
                            throw e;
                        }
                        break block9;
                    }
                    throw e;
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
            serverMap.put(serverAddress, serverAddress);
        }
    }

    public static final Map<ITxcDataSource, Map<String, String>> getRtServerJournelMap() {
        return rtServerJournelMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Iterator<ITxcDataSource> getOtherDsInSameGroup(ITxcDataSource txcDataSource) {
        LinkedList<ITxcDataSource> txcDataSources = new LinkedList<ITxcDataSource>();
        ConcurrentHashMap<String, List<ITxcDataSource>> concurrentHashMap = dataSourceGroupMap;
        synchronized (concurrentHashMap) {
            List<ITxcDataSource> txcDataSourceList = dataSourceGroupMap.get(txcDataSource.getGroupKey());
            if (txcDataSourceList != null) {
                for (ITxcDataSource txcDataSourceItem : txcDataSourceList) {
                    if (txcDataSourceItem == txcDataSource) continue;
                    txcDataSources.add(txcDataSourceItem);
                }
            }
        }
        return txcDataSources.iterator();
    }
}

