/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.jdbc;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.spring.CommonClient;
import com.taobao.txc.parser.visitor.TxcVisitorFactory;
import com.taobao.txc.parser.visitor.cobar.NullValue;
import com.taobao.txc.resourcemanager.executor.ExecutorFactory;
import com.taobao.txc.resourcemanager.jdbc.TxcStatement;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcPrepareStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.PrepareStatementBatchUpdateExecutor;
import com.taobao.txc.resourcemanager.jdbc.executor.PrepareStatementQueryExecutor;
import com.taobao.txc.resourcemanager.jdbc.executor.PrepareStatementUpdateExecutor;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;

public class TxcPreparedStatement
extends TxcStatement
implements ITxcPrepareStatement {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final ExecutorFactory<Integer> voidUpdate = new ExecutorFactory<Integer>(PrepareStatementUpdateExecutor.getInstance());
    private static final ExecutorFactory<int[]> voidBatch = new ExecutorFactory<int[]>(PrepareStatementBatchUpdateExecutor.getInstance());
    private static final ExecutorFactory<ResultSet> voidQuery = new ExecutorFactory<ResultSet>(PrepareStatementQueryExecutor.getInstance());
    private ArrayList<Object>[] parameters = null;

    @Override
    public int getParaRow() throws SQLException {
        int count = this.getParaCount();
        if (count == 0) {
            return 0;
        }
        ArrayList<Object>[] paras = this.getParameters();
        if (paras.length > 0) {
            return paras[0].size();
        }
        return 0;
    }

    @Override
    public int getParaCount() throws SQLException {
        return this.getParameterMetaData().getParameterCount();
    }

    @Override
    public Object getParameterValue(int paraIndex, int valueIndex) throws SQLException {
        try {
            ArrayList<Object> values = null;
            ArrayList<Object>[] paras = this.getParameters();
            if (paras.length >= paraIndex) {
                values = paras[paraIndex - 1];
            }
            if (values == null || values.size() < valueIndex) {
                return null;
            }
            return values.get(valueIndex - 1);
        }
        catch (Throwable e) {
            logger.error(String.format("paraIndex:%d,valueIndex:%d", paraIndex, valueIndex), TxcErrCode.TxcParaIndexError, e);
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new SQLException(e);
        }
    }

    @Override
    public synchronized ArrayList<Object>[] getParameters() throws SQLException {
        if (this.parameters == null) {
            int count = this.getParaCount();
            this.parameters = new ArrayList[count];
            for (int i = 0; i < count; ++i) {
                this.parameters[i] = new ArrayList();
            }
        }
        return this.parameters;
    }

    @Override
    public String getParametersString() throws SQLException {
        int paras = this.getParaCount();
        int values = this.getParaRow();
        StringBuilder sb = new StringBuilder();
        boolean ff = true;
        for (int i = 1; i <= values; ++i) {
            if (ff) {
                ff = false;
            } else {
                sb.append(",");
            }
            sb.append("[");
            boolean f = true;
            for (int j = 1; j <= paras; ++j) {
                Object val = this.getParameterValue(j, i);
                if (val == null) continue;
                if (f) {
                    f = false;
                } else {
                    sb.append(",");
                }
                sb.append(val);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public TxcPreparedStatement(Statement st, ITxcConnection conn, String sql) {
        super(st, conn);
        this.setTargetSql(sql);
    }

    private void setPlaceHolderMap(int place, Object obj1, Object obj2, Object obj3) throws SQLException {
        if (!TxcContext.inTxcTransaction()) {
            return;
        }
        ArrayList<Object>[] paras = this.getParameters();
        if (paras.length >= place) {
            paras[--place].add(obj1);
        }
    }

    private void setPlaceHolderMap(int place, Object obj1, Object obj2) throws SQLException {
        if (!TxcContext.inTxcTransaction()) {
            return;
        }
        ArrayList<Object>[] paras = this.getParameters();
        if (paras.length >= place) {
            paras[--place].add(obj1);
        }
    }

    private void setPlaceHolderMap(int place, Object obj) throws SQLException {
        if (!TxcContext.inTxcTransaction()) {
            return;
        }
        ArrayList<Object>[] paras = this.getParameters();
        if (paras.length >= place) {
            paras[--place].add(obj);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        ((PreparedStatement)this.targetSt).addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        ((PreparedStatement)this.targetSt).clearParameters();
    }

    @Override
    public boolean execute() throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return ((PreparedStatement)this.targetSt).execute();
        }
        if (TxcVisitorFactory.isQuerySql(this.targetSql)) {
            this.executeQuery();
            return true;
        }
        this.executeUpdate();
        return false;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return ((PreparedStatement)this.targetSt).executeQuery();
        }
        return voidQuery.execute(this.txcConn, this, "executeQuery", new Object[0]);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return ((PreparedStatement)this.targetSt).executeBatch();
        }
        return voidBatch.execute(this.txcConn, this, "executeBatch", new Object[0]);
    }

    @Override
    public int executeUpdate() throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return ((PreparedStatement)this.targetSt).executeUpdate();
        }
        return voidUpdate.execute(this.txcConn, this, "executeUpdate", new Object[0]);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return ((PreparedStatement)this.targetSt).getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return ((PreparedStatement)this.targetSt).getParameterMetaData();
    }

    @Override
    public void setArray(int arg0, Array arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setArray(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setAsciiStream(arg0, arg1);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setAsciiStream(arg0, arg1, arg2);
    }

    @Override
    public void setAsciiStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setAsciiStream(arg0, arg1, arg2);
    }

    @Override
    public void setBigDecimal(int arg0, BigDecimal arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setBigDecimal(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setBinaryStream(arg0, arg1);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setBinaryStream(arg0, arg1, arg2);
    }

    @Override
    public void setBinaryStream(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setBinaryStream(arg0, arg1, arg2);
    }

    @Override
    public void setBlob(int arg0, Blob arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setBlob(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, InputStream arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setBlob(arg0, arg1);
    }

    @Override
    public void setBlob(int arg0, InputStream arg1, long arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setBlob(arg0, arg1, arg2);
    }

    @Override
    public void setBoolean(int arg0, boolean arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setBoolean(arg0, arg1);
    }

    @Override
    public void setByte(int arg0, byte arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setByte(arg0, arg1);
    }

    @Override
    public void setBytes(int arg0, byte[] arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setBytes(arg0, arg1);
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setCharacterStream(arg0, arg1);
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, int arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setCharacterStream(arg0, arg1, arg2);
    }

    @Override
    public void setCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setCharacterStream(arg0, arg1, arg2);
    }

    @Override
    public void setClob(int arg0, Clob arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setClob(arg0, arg1);
    }

    @Override
    public void setClob(int arg0, Reader arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setClob(arg0, arg1);
    }

    @Override
    public void setClob(int arg0, Reader arg1, long arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setClob(arg0, arg1, arg2);
    }

    @Override
    public void setDate(int arg0, Date arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setDate(arg0, arg1);
    }

    @Override
    public void setDate(int arg0, Date arg1, Calendar arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setDate(arg0, arg1, arg2);
    }

    @Override
    public void setDouble(int arg0, double arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setDouble(arg0, arg1);
    }

    @Override
    public void setFloat(int arg0, float arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, Float.valueOf(arg1));
        ((PreparedStatement)this.targetSt).setFloat(arg0, arg1);
    }

    @Override
    public void setInt(int arg0, int arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setInt(arg0, arg1);
    }

    @Override
    public void setLong(int arg0, long arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setLong(arg0, arg1);
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setNCharacterStream(arg0, arg1);
    }

    @Override
    public void setNCharacterStream(int arg0, Reader arg1, long arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setNCharacterStream(arg0, arg1, arg2);
    }

    @Override
    public void setNClob(int arg0, NClob arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setNClob(arg0, arg1);
    }

    @Override
    public void setNClob(int arg0, Reader arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setNClob(arg0, arg1);
    }

    @Override
    public void setNClob(int arg0, Reader arg1, long arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setNClob(arg0, arg1, arg2);
    }

    @Override
    public void setNString(int arg0, String arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setNString(arg0, arg1);
    }

    @Override
    public void setNull(int arg0, int arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, NullValue.getNullValue());
        ((PreparedStatement)this.targetSt).setNull(arg0, arg1);
    }

    @Override
    public void setNull(int arg0, int arg1, String arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, NullValue.getNullValue());
        ((PreparedStatement)this.targetSt).setNull(arg0, arg1, arg2);
    }

    @Override
    public void setObject(int arg0, Object arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setObject(arg0, arg1);
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setObject(arg0, arg1, arg2);
    }

    @Override
    public void setObject(int arg0, Object arg1, int arg2, int arg3) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2, arg3);
        ((PreparedStatement)this.targetSt).setObject(arg0, arg1, arg2, arg3);
    }

    @Override
    public void setRef(int arg0, Ref arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setRef(arg0, arg1);
    }

    @Override
    public void setRowId(int arg0, RowId arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setRowId(arg0, arg1);
    }

    @Override
    public void setSQLXML(int arg0, SQLXML arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setSQLXML(arg0, arg1);
    }

    @Override
    public void setShort(int arg0, short arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setShort(arg0, arg1);
    }

    @Override
    public void setString(int arg0, String arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setString(arg0, arg1);
    }

    @Override
    public void setTime(int arg0, Time arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setTime(arg0, arg1);
    }

    @Override
    public void setTime(int arg0, Time arg1, Calendar arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setTime(arg0, arg1);
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setTimestamp(arg0, arg1);
    }

    @Override
    public void setTimestamp(int arg0, Timestamp arg1, Calendar arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setTimestamp(arg0, arg1, arg2);
    }

    @Override
    public void setURL(int arg0, URL arg1) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1);
        ((PreparedStatement)this.targetSt).setURL(arg0, arg1);
    }

    @Override
    public void setUnicodeStream(int arg0, InputStream arg1, int arg2) throws SQLException {
        this.setPlaceHolderMap(arg0, arg1, arg2);
        ((PreparedStatement)this.targetSt).setUnicodeStream(arg0, arg1, arg2);
    }
}

