/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.jdbc;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.exception.TxcLockConflictException;
import com.taobao.txc.parser.struct.TxcField;
import com.taobao.txc.parser.struct.TxcRuntimeContext;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.parser.visitor.api.ITxcVisitor;
import com.taobao.txc.resourcemanager.ResourceManager;
import com.taobao.txc.resourcemanager.TxcResourceManagerImpl;
import com.taobao.txc.resourcemanager.executor.SpinLockHelper;
import com.taobao.txc.resourcemanager.jdbc.TxcDbType;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

public abstract class TxcResourceManagerHandler
implements ITxcConnection {
    private static final LoggerWrap logger = LoggerInit.logger;
    protected final Connection conn;
    protected final ITxcDataSource txcDs;
    protected TxcRuntimeContext txcContext = null;
    private final ResourceManager rm = TxcResourceManagerImpl.getTxcResourceManager();

    public TxcResourceManagerHandler(Connection targetConnection, ITxcDataSource targetDataSource) {
        this.conn = targetConnection;
        this.txcDs = targetDataSource;
    }

    @Override
    public ITxcDataSource getTxcDataSource() throws SQLException {
        return this.txcDs;
    }

    @Override
    public Connection getTargetConnection() {
        return this.conn;
    }

    @Override
    public TxcRuntimeContext getTxcRuntimeContext() {
        if (this.txcContext == null) {
            this.txcContext = new TxcRuntimeContext();
            this.txcContext.setXid(TxcContext.getCurrentXid());
        }
        return this.txcContext;
    }

    @Override
    public String getWriteKeys(String tableName, List<List<TxcField>> pks) {
        if (pks == null || pks.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(tableName);
        sb.append(":");
        boolean flag = false;
        for (List<TxcField> pk : pks) {
            if (flag) {
                sb.append(",");
            } else {
                flag = true;
            }
            sb.append(this.parseFields(pk));
        }
        return sb.toString();
    }

    @Override
    public String getWriteKeys(TxcTable table) {
        if (table.linesNum() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(table.getTableName());
        sb.append(":");
        boolean flag = false;
        for (TxcField field : table.pkRows()) {
            if (flag) {
                sb.append(",");
            } else {
                flag = true;
            }
            sb.append(field.getValue());
        }
        return sb.toString();
    }

    @Override
    public void queryReadLocks(ITxcStatement st, String writeKeys, ITxcVisitor sqlVisitor) throws SQLException {
        if (writeKeys == null || writeKeys.isEmpty()) {
            return;
        }
        String xid = null;
        try {
            xid = TxcContext.getCurrentXid();
            long tranId = TxcXID.getTransactionId(xid);
            String dbname = this.getTxcDataSource().getDbName();
            this.rm.queryReadLocks(dbname, tranId, writeKeys);
        }
        catch (Throwable e) {
            this.handlLockConfictException(e, writeKeys);
        }
        logger.info(String.format("[%d] queryReadLocks ok [%s] [%s] [%s] [%s]", new Object[]{TxcContext.getTransactionId(), sqlVisitor.getSQLExplain().getSqlType(), writeKeys, xid, st.getRtFromStart()}));
    }

    @Override
    public TxcRuntimeContext registTrxBranch(String businessKey) throws SQLException {
        this.checkTxcContext();
        TxcRuntimeContext context = this.getTxcRuntimeContext();
        try {
            if (!context.isRegistBranch()) {
                String dbname = this.getTxcDataSource().getDbName();
                long branch_id = this.rm.register(dbname, businessKey, CommitMode.COMMIT_IN_PHASE1);
                context.setBranchId(branch_id);
            }
        }
        catch (Throwable e) {
            try {
                String errLog = String.format("registTrxBranch error %s [%s], message:%s", context.getXid(), businessKey, e.getMessage());
                if (businessKey == null) {
                    logger.error("", errLog, e);
                }
                throw new SQLException(errLog, e);
            }
            catch (Throwable throwable) {
                logger.info(String.format("[%d:%d] regist branch [%s], cost %d ms.", TxcContext.getTransactionId(), context.getBranchId(), businessKey, context.getRTFromLastPoint()));
                throw throwable;
            }
        }
        logger.info(String.format("[%d:%d] regist branch [%s], cost %d ms.", TxcContext.getTransactionId(), context.getBranchId(), businessKey, context.getRTFromLastPoint()));
        return context;
    }

    @Override
    public TxcRuntimeContext registTrxBranchWithLocks(String writeKeys) throws SQLException {
        if (writeKeys == null) {
            logger.info("writeKeys is null");
        }
        TxcRuntimeContext context = null;
        try {
            context = this.registTrxBranch(writeKeys);
        }
        catch (Throwable e) {
            this.handlLockConfictException(e, writeKeys);
        }
        return context;
    }

    @Override
    public TxcRuntimeContext registTrxBranchWithLocksRetry(String writeKeys) throws SQLException {
        SpinLockHelper sh = new SpinLockHelper();
        TxcRuntimeContext context = null;
        while (true) {
            try {
                context = this.registTrxBranchWithLocks(writeKeys);
            }
            catch (TxcLockConflictException e) {
                sh.sleep(e);
                continue;
            }
            break;
        }
        return context;
    }

    @Override
    public void reportBranchStatus(boolean status) throws SQLException {
        this.checkTxcContext();
        TxcRuntimeContext context = this.getTxcRuntimeContext();
        try {
            String dbname = this.getTxcDataSource().getDbName();
            this.rm.reportStatus(context.getBranchId(), status, dbname, null);
        }
        catch (Throwable e) {
            try {
                String errLog = String.format("reportBranchStatus error %s:%d", context.getXid(), context.getBranchId());
                logger.error("", errLog, e);
                throw new SQLException(errLog, e);
            }
            catch (Throwable throwable) {
                logger.info(String.format("[%d:%d] report %b, cost %d ms.", TxcContext.getTransactionId(), context.getBranchId(), status, context.getRTFromLastPoint()));
                throw throwable;
            }
        }
        logger.info(String.format("[%d:%d] report %b, cost %d ms.", TxcContext.getTransactionId(), context.getBranchId(), status, context.getRTFromLastPoint()));
    }

    private void checkTxcContext() throws SQLException {
        if (!TxcContext.inTxcTransaction()) {
            throw new SQLException("should 'set txc env' first.");
        }
    }

    private String parseFields(List<TxcField> fields) {
        StringBuilder sb = new StringBuilder();
        boolean flag = false;
        for (TxcField field : fields) {
            if (flag) {
                sb.append("+");
            } else {
                flag = true;
            }
            sb.append(field.getValue());
        }
        return sb.toString();
    }

    private void handlLockConfictException(Throwable e, String writeKeys) throws SQLException {
        String xid = TxcContext.getCurrentXid();
        Throwable ex = e.getCause();
        if (ex == null) {
            ex = e;
        }
        if (ex != null && ex instanceof TxcException) {
            TxcException te = (TxcException)ex;
            String exMessage = te.getMessage();
            if (exMessage == null) {
                Throwable cause = te.getCause();
                logger.info("TxcException without message. Cause: " + cause);
                if (cause == null) {
                    throw new SQLException("Unknown TxcException");
                }
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException(cause);
            }
            if (te.getMessage().contains("query lock")) {
                logger.info(String.format("[%d] Lock confict [%s] [%s]", TxcContext.getTransactionId(), writeKeys, xid));
                throw new TxcLockConflictException(e);
            }
            if (te.getMessage().contains("get local lock")) {
                logger.info(String.format("[%d] Lock confict [%s] [%s]", TxcContext.getTransactionId(), writeKeys, xid));
                throw new TxcLockConflictException(e);
            }
            if (te.getMessage().contains("cluster operation fail")) {
                logger.info(String.format("[%d] Lock confict cluster [%s] [%s]", TxcContext.getTransactionId(), writeKeys, xid));
                throw new TxcLockConflictException(e);
            }
        }
        logger.info("error message:", ex.getMessage());
        if (e instanceof SQLException) {
            throw (SQLException)e;
        }
        throw new SQLException(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TxcDbType getDsType() throws SQLException {
        String dbType = this.txcDs.getDBType();
        if (null == dbType) {
            Connection conn = null;
            try {
                conn = this.txcDs.getTargetDataSource().getConnection();
                dbType = conn.getMetaData().getDatabaseProductName();
            }
            catch (SQLException exx) {
                logger.error("getConnError", exx.getMessage());
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException exx) {
                        logger.error("closeConnError", exx.getMessage());
                    }
                }
            }
            if (dbType != null) {
                this.txcDs.setDBType(dbType);
            }
        }
        return this.getDbTypeByName(dbType);
    }

    private TxcDbType getDbTypeByName(String dbName) {
        for (TxcDbType txcDbType : TxcDbType.values()) {
            if (!txcDbType.name().equalsIgnoreCase(dbName)) continue;
            return txcDbType;
        }
        return TxcDbType.MYSQL;
    }
}

