/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.JdbcUtils;

public class TxcRowMapper
implements RowMapper {
    public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        LinkedHashMap<String, Object> mapOfColValues = new LinkedHashMap<String, Object>();
        for (int i = 1; i <= columnCount; ++i) {
            String key = JdbcUtils.lookupColumnName((ResultSetMetaData)rsmd, (int)i).toUpperCase();
            Object obj = JdbcUtils.getResultSetValue((ResultSet)rs, (int)i);
            mapOfColValues.put(key, obj);
        }
        return mapOfColValues;
    }

    public static List<Map<String, Object>> resultSet2List(ResultSet rs) throws SQLException {
        LinkedList<Map<String, Object>> list = new LinkedList<Map<String, Object>>();
        TxcRowMapper mapper = new TxcRowMapper();
        int index = 0;
        while (rs.next()) {
            Map map = (Map)mapper.mapRow(rs, index);
            list.add(map);
        }
        return list;
    }
}

