/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.jdbc;

import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.exception.TxcUnSupportException;
import com.taobao.txc.common.spring.CommonClient;
import com.taobao.txc.parser.visitor.TxcVisitorFactory;
import com.taobao.txc.resourcemanager.executor.ExecutorFactory;
import com.taobao.txc.resourcemanager.jdbc.TxcSqlMonitor;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcStatement;
import com.taobao.txc.resourcemanager.jdbc.executor.StatementQueryExecutor;
import com.taobao.txc.resourcemanager.jdbc.executor.StatementStringIntArrayUpdateExecutor;
import com.taobao.txc.resourcemanager.jdbc.executor.StatementStringIntUpdateExecutor;
import com.taobao.txc.resourcemanager.jdbc.executor.StatementStringStringArrayUpdateExecutor;
import com.taobao.txc.resourcemanager.jdbc.executor.StatementStringUpdateExecutor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;

public class TxcStatement
implements ITxcStatement {
    private static final ExecutorFactory<Integer> stringUpdate = new ExecutorFactory<Integer>(StatementStringUpdateExecutor.getInstance());
    private static final ExecutorFactory<Integer> stringIntUpdate = new ExecutorFactory<Integer>(StatementStringIntUpdateExecutor.getInstance());
    private static final ExecutorFactory<Integer> stringIntArrayUpdate = new ExecutorFactory<Integer>(StatementStringIntArrayUpdateExecutor.getInstance());
    private static final ExecutorFactory<Integer> stringStringArrayUpdate = new ExecutorFactory<Integer>(StatementStringStringArrayUpdateExecutor.getInstance());
    private static final ExecutorFactory<ResultSet> stringQuery = new ExecutorFactory<ResultSet>(StatementQueryExecutor.getInstance());
    protected String targetSql;
    protected final Statement targetSt;
    protected final ITxcConnection txcConn;
    private final TxcSqlMonitor sqlMonitor = new TxcSqlMonitor();

    public TxcStatement(Statement targetStatement, ITxcConnection connectionWrapper) {
        this.targetSt = targetStatement;
        this.txcConn = connectionWrapper;
    }

    @Override
    public void cancel() throws SQLException {
        this.targetSt.cancel();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.targetSt.clearWarnings();
    }

    @Override
    public void close() throws SQLException {
        this.targetSt.close();
    }

    @Override
    public boolean execute(String arg0) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.execute(arg0);
        }
        if (TxcVisitorFactory.isQuerySql(arg0)) {
            this.executeQuery(arg0);
            return true;
        }
        this.executeUpdate(arg0);
        return false;
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.execute(arg0, arg1);
        }
        if (TxcVisitorFactory.isQuerySql(arg0)) {
            this.executeQuery(arg0);
            return true;
        }
        this.executeUpdate(arg0, arg1);
        return false;
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.execute(arg0, arg1);
        }
        if (TxcVisitorFactory.isQuerySql(arg0)) {
            this.executeQuery(arg0);
            return true;
        }
        this.executeUpdate(arg0, arg1);
        return false;
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.execute(arg0, arg1);
        }
        if (TxcVisitorFactory.isQuerySql(arg0)) {
            this.executeQuery(arg0);
            return true;
        }
        this.executeUpdate(arg0, arg1);
        return false;
    }

    @Override
    public void addBatch(String arg0) throws SQLException {
        this.targetSt.addBatch(arg0);
    }

    @Override
    public void clearBatch() throws SQLException {
        this.targetSt.clearBatch();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.executeBatch();
        }
        throw new TxcUnSupportException();
    }

    @Override
    public ResultSet executeQuery(String arg0) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.executeQuery(arg0);
        }
        this.setTargetSql(arg0);
        return stringQuery.execute(this.txcConn, this, "executeQuery", arg0);
    }

    @Override
    public int executeUpdate(String arg0) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.executeUpdate(arg0);
        }
        this.setTargetSql(arg0);
        return stringUpdate.execute(this.txcConn, this, "executeUpdate", arg0);
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.executeUpdate(arg0, arg1);
        }
        this.setTargetSql(arg0);
        return stringIntUpdate.execute(this.txcConn, this, "executeUpdate", arg0, arg1);
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.executeUpdate(arg0, arg1);
        }
        this.setTargetSql(arg0);
        return stringIntArrayUpdate.execute(this.txcConn, this, "executeUpdate", arg0, arg1);
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        if (!TxcContext.inTxcEnv() || !CommonClient.isInited()) {
            return this.targetSt.executeUpdate(arg0, arg1);
        }
        this.setTargetSql(arg0);
        return stringStringArrayUpdate.execute(this.txcConn, this, "executeUpdate", arg0, arg1);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.targetSt.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.targetSt.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.targetSt.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.targetSt.getGeneratedKeys();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.targetSt.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.targetSt.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.targetSt.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        return this.targetSt.getMoreResults(arg0);
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.targetSt.getQueryTimeout();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.targetSt.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.targetSt.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.targetSt.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.targetSt.getResultSetType();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.targetSt.getUpdateCount();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.targetSt.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.targetSt.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.targetSt.isPoolable();
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        this.targetSt.setCursorName(arg0);
    }

    @Override
    public void setEscapeProcessing(boolean arg0) throws SQLException {
        this.targetSt.setEscapeProcessing(arg0);
    }

    @Override
    public void setFetchDirection(int arg0) throws SQLException {
        this.targetSt.setFetchDirection(arg0);
    }

    @Override
    public void setFetchSize(int arg0) throws SQLException {
        this.targetSt.setFetchSize(arg0);
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        this.targetSt.setMaxFieldSize(arg0);
    }

    @Override
    public void setMaxRows(int arg0) throws SQLException {
        this.targetSt.setMaxRows(arg0);
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        this.targetSt.setPoolable(arg0);
    }

    @Override
    public void setQueryTimeout(int arg0) throws SQLException {
        this.targetSt.setQueryTimeout(arg0);
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.targetSt.isWrapperFor(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this.targetSt.unwrap(arg0);
    }

    @Override
    public ITxcConnection getTxcConnection() throws SQLException {
        return this.txcConn;
    }

    @Override
    public Statement getTargetStatement() throws SQLException {
        return this.targetSt;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new TxcUnSupportException();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        throw new TxcUnSupportException();
    }

    @Override
    public String getTargetSql() {
        return this.targetSql;
    }

    public void setTargetSql(String sql) {
        this.targetSql = sql;
    }

    @Override
    public String getRtFromStart() {
        return this.sqlMonitor.getRtFromStart();
    }
}

