/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.jdbc.warpper;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.sorter.ITxcExceptionSorter;
import com.taobao.txc.common.exception.sorter.MySqlTxcExceptionSorter;
import java.sql.Connection;
import java.sql.SQLException;

public class ExceptionHandler {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static final ITxcExceptionSorter exSorter = new MySqlTxcExceptionSorter();

    public static void handleConnectionException(Connection conn, Throwable t) {
        if (!(t instanceof SQLException) || exSorter.isExceptionFatal((SQLException)t)) {
            // empty if block
        }
    }

    public static SQLException handleException(Connection conn, Throwable t) throws SQLException {
        try {
            logger.error(TxcErrCode.TxcExecuteError, t);
            ExceptionHandler.handleConnectionException(conn, t);
        }
        finally {
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new SQLException(t);
        }
    }
}

