/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.limit;

import com.taobao.middleware.logger.Logger;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.BeginMessage;
import com.taobao.txc.common.message.RegisterMessage;
import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.rpc.impl.RpcClient;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;

public class ClientLimitationHelper {
    private static final Logger logger = LoggerInit.loggerLimitation;
    private static ConcurrentHashMap<String, Boolean> clientLimitedMap = new ConcurrentHashMap();
    private static ClientLimitationHelper instance = null;

    private ClientLimitationHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientLimitationHelper getInstance() {
        if (instance != null) return instance;
        Class<ClientLimitationHelper> clazz = ClientLimitationHelper.class;
        synchronized (ClientLimitationHelper.class) {
            if (instance != null) return instance;
            ClientLimitationHelper i = new ClientLimitationHelper();
            i.init();
            instance = i;
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void init() {
        Executors.newScheduledThreadPool(1).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    Iterator it = clientLimitedMap.entrySet().iterator();
                    while (it.hasNext()) {
                        it.next();
                        it.remove();
                    }
                }
                catch (Throwable ingore) {
                    logger.error("cached error", "ingore", ingore);
                }
            }
        }, 0L, 100L, TimeUnit.MILLISECONDS);
    }

    private String getGroupName(TxcMessage message) {
        String group = null;
        if (message instanceof BeginMessage) {
            group = RpcClient.getInstance().getGroup();
        } else if (message instanceof RegisterMessage) {
            try {
                if (RpcClient.getInstance() != null) {
                    group = RpcClient.getInstance().getGroup();
                }
            }
            catch (TxcException txcException) {}
        } else {
            logger.warn(message.toString(), "unknown message error");
        }
        return StringUtils.isEmpty((String)group) ? "NULL" : group;
    }

    public void handleMessage(RegisterMessage message) throws TxcException {
        String key = this.getGroupName(message);
        if (clientLimitedMap.get(key) != null) {
            logger.info(message.toString(), String.format("%s fast failed", key));
            throw new TxcException("begin txc too frequently");
        }
    }

    public void handleException(RegisterMessage message, Throwable th) throws TxcException {
        if (th instanceof TxcException) {
            TxcException ex = (TxcException)th;
            if (ex.getMessage() != null && StringUtils.indexOf((String)ex.getMessage(), (String)"begin txc too frequently") != -1) {
                String key = this.getGroupName(message);
                clientLimitedMap.put(key, true);
            }
            throw ex;
        }
        throw new TxcException(th);
    }

    public void handleMessage(BeginMessage beginMessage) {
        String key = this.getGroupName(beginMessage);
        if (clientLimitedMap.get(key) != null) {
            logger.info(beginMessage.toString(), String.format("%s fast failed", key));
            throw new TxcException("begin txc too frequently");
        }
    }

    public void handleException(BeginMessage beginMessage, Throwable th) {
        if (th instanceof TxcException) {
            TxcException ex = (TxcException)th;
            if (ex.getMessage() != null && StringUtils.indexOf((String)ex.getMessage(), (String)"begin txc too frequently") != -1) {
                String key = this.getGroupName(beginMessage);
                clientLimitedMap.put(key, true);
                TxcConfigHolder.getInstance().sendAlertWithDelay(RpcClient.getVgroup(), ex.getMessage(), 1, RpcClient.getHttpSecurity());
            } else if (ex.getMessage() != null) {
                TxcConfigHolder.getInstance().sendAlertWithDelay(RpcClient.getVgroup(), ex.getMessage(), 10, RpcClient.getHttpSecurity());
            }
            throw ex;
        }
        if (th.getMessage() != null) {
            TxcConfigHolder.getInstance().sendAlertWithDelay(RpcClient.getVgroup(), th.getMessage(), 10, RpcClient.getHttpSecurity());
        }
        throw new TxcException(th);
    }
}

