/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.mt;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.resourcemanager.mt.MtBranch;
import com.taobao.txc.resourcemanager.mt.MtResourceManager;
import com.taobao.txc.resourcemanager.mt.service.MtServiceTaskImpl;
import com.taobao.txc.rpc.impl.RpcClient;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class MtBranchInterceptor
implements MethodInterceptor {
    private MtResourceManager resourceManager = MtResourceManager.getTxcResourceManager();
    private static final LoggerWrap logger = LoggerInit.logger;
    private Boolean defaultMtStatus = null;

    public MtBranchInterceptor() {
    }

    public MtBranchInterceptor(String env) {
        this.resourceManager.setEnv(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (!invocation.getMethod().isAnnotationPresent(MtBranch.class)) {
            String key = TxcContext.suspendTxcTransaction();
            Object object = null;
            try {
                object = invocation.proceed();
            }
            finally {
                TxcContext.resumeTxcTransaction(key);
            }
            return object;
        }
        MtBranch mtBranch = invocation.getMethod().getAnnotation(MtBranch.class);
        String resourceKey = this.resourceManager.getResourceKey(mtBranch.name());
        String xid = TxcContext.getCurrentXid();
        long branchId = 0L;
        long start = System.currentTimeMillis();
        try {
            branchId = this.resourceManager.register(resourceKey, null, CommitMode.COMMIT_IN_PHASE2);
            invocation.getArguments()[0] = xid;
            invocation.getArguments()[1] = new Long(branchId);
            MtServiceTaskImpl.getThreadlocalfullxid().set(xid + ":" + branchId);
        }
        catch (Throwable throwable) {
            logger.info(String.format("[%s] [%d:%d] regist mt branch, cost %d ms.", resourceKey, TxcContext.getTransactionId(), branchId, System.currentTimeMillis() - start));
            throw throwable;
        }
        logger.info(String.format("[%s] [%d:%d] regist mt branch, cost %d ms.", resourceKey, TxcContext.getTransactionId(), branchId, System.currentTimeMillis() - start));
        String key = TxcContext.suspendTxcTransaction();
        Object res = null;
        try {
            res = invocation.proceed();
        }
        catch (Exception e) {
            block15: {
                String udata = TxcContext.removeMtUdata();
                TxcContext.resumeTxcTransaction(key);
                try {
                    if (this.defaultMtStatus == null) {
                        this.defaultMtStatus = new Boolean(TxcConfigHolder.getInstance().getDefaultMtStatus(RpcClient.getVgroup()));
                    }
                    this.resourceManager.reportStatus(branchId, this.defaultMtStatus, resourceKey, udata);
                    logger.info(String.format("[%s] [%d:%d] reportStatus %b, cost %d ms.", resourceKey, TxcContext.getTransactionId(), branchId, (boolean)this.defaultMtStatus, System.currentTimeMillis() - start));
                }
                catch (Exception ee) {
                    if (udata == null) break block15;
                    logger.info(String.format("[%s] [%d:%d] try failed, and report status failed, cost %d ms.", resourceKey, TxcContext.getTransactionId(), branchId, System.currentTimeMillis() - start));
                    key = TxcContext.suspendTxcTransaction();
                    this.resourceManager.branchRollback(xid, branchId, resourceKey, udata, (byte)CommitMode.COMMIT_IN_PHASE2.getValue());
                    TxcContext.resumeTxcTransaction(key);
                }
            }
            throw e;
        }
        String udata = TxcContext.removeMtUdata();
        TxcContext.resumeTxcTransaction(key);
        try {
            this.resourceManager.reportStatus(branchId, true, resourceKey, udata);
            logger.info(String.format("[%s] [%d:%d] reportStatus true, cost %d ms.", resourceKey, TxcContext.getTransactionId(), branchId, System.currentTimeMillis() - start));
        }
        catch (Exception ee) {
            if (udata != null) {
                logger.info(String.format("[%s] [%d:%d] try success, but report status failed, cost %d ms.", resourceKey, TxcContext.getTransactionId(), branchId, System.currentTimeMillis() - start));
                key = TxcContext.suspendTxcTransaction();
                this.resourceManager.branchRollback(xid, branchId, resourceKey, udata, (byte)CommitMode.COMMIT_IN_PHASE2.getValue());
                TxcContext.resumeTxcTransaction(key);
            }
            throw ee;
        }
        return res;
    }
}

