/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.mt;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TrxLockMode;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.ReportUdataMessage;
import com.taobao.txc.common.message.ReportUdataResultMessage;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.resourcemanager.RmRpcClient;
import com.taobao.txc.resourcemanager.TxcBaseResourceManagerImpl;
import com.taobao.txc.resourcemanager.mt.MtBranch;
import com.taobao.txc.resourcemanager.mt.MtRmRpcClient;
import com.taobao.txc.rpc.impl.RpcClient;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.ClassUtils;

public class MtResourceManager
extends TxcBaseResourceManagerImpl {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static AtomicInteger instanceCounter = new AtomicInteger(0);
    private final Map<String, MtBranchMethodHolder> branches = new HashMap<String, MtBranchMethodHolder>();
    private Map<String, Object> mtServices = new HashMap<String, Object>();
    boolean isInitialed = false;
    private String env;
    private static ScheduledExecutorService cleanOldLogExecutor = Executors.newSingleThreadScheduledExecutor();
    private static int cleanOldLogEventTriggerSeconds = 3600;

    public void setEnv(String env) {
        this.env = env;
    }

    String getResourceKey(String branchName) {
        if (this.env == null) {
            return branchName;
        }
        return this.env + "." + branchName;
    }

    public MtResourceManager() {
        int old = instanceCounter.getAndAdd(1);
        if (old != 0) {
            throw new RuntimeException("Define MtResourceManager repeatedlly!");
        }
    }

    public static MtResourceManager getTxcResourceManager() {
        return (MtResourceManager)TxcBaseResourceManagerImpl.getInstance("mt");
    }

    private Integer getCleanOldTxcDays() {
        String vgroup = RpcClient.getVgroup();
        return TxcConfigHolder.getInstance().getCleanOldUndoLogDays(vgroup);
    }

    public void init() {
        if (this.isInitialed) {
            return;
        }
        try {
            StringBuilder customKeys = new StringBuilder();
            for (String interfaceName : this.mtServices.keySet()) {
                Object service = this.mtServices.get(interfaceName);
                Class interfaceClass = ClassUtils.getClass((String)interfaceName);
                for (Method method : interfaceClass.getMethods()) {
                    if (!method.isAnnotationPresent(MtBranch.class)) continue;
                    MtBranch branch = method.getAnnotation(MtBranch.class);
                    if (customKeys.length() != 0) {
                        customKeys.append(",");
                    }
                    String resourceKey = this.getResourceKey(branch.name());
                    customKeys.append(resourceKey);
                    if (this.branches.containsKey(resourceKey)) {
                        throw new TxcException("mt branch name " + resourceKey + " conflicts.");
                    }
                    Method commitMethod = service.getClass().getMethod(branch.commitMethod(), String.class, Long.TYPE, String.class);
                    Method cancelMethod = service.getClass().getMethod(branch.rollbackMethod(), String.class, Long.TYPE, String.class);
                    MtBranchMethodHolder holder = new MtBranchMethodHolder();
                    holder.cancelMethod = cancelMethod;
                    holder.commitMethod = commitMethod;
                    holder.targetService = service;
                    this.branches.put(resourceKey, holder);
                }
            }
            RmRpcClient client = (RmRpcClient)this.getClientMessageSender();
            if (client == null) {
                client = MtRmRpcClient.getInstance(new ThreadPoolExecutor(32, 200, 500L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20000), new ThreadPoolExecutor.CallerRunsPolicy()));
            }
            client.setCustomerKeys(customKeys.toString());
            logger.info("register servicekey[" + customKeys.toString() + "] of mt to MtRmRpcClient");
            this.isInitialed = true;
            cleanOldLogExecutor.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Calendar calendar = Calendar.getInstance();
                    int nowHour = calendar.get(11);
                    if (nowHour >= 4 && nowHour <= 5) {
                        Integer cleanOldTxcDays = MtResourceManager.this.getCleanOldTxcDays();
                        MtResourceManager.this.cleanOldTxcLog(cleanOldTxcDays);
                    }
                }
            }, 60L, cleanOldLogEventTriggerSeconds, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new TxcException(e);
        }
    }

    public boolean isMtBranch(String branchName) {
        return this.branches.containsKey(branchName);
    }

    @Override
    public void branchCommit(String xid, long branchId, String key, String udata, byte commitMode, String retrySql) {
        this.branches.get(key).commitBranch(xid, branchId, udata);
    }

    @Override
    public void branchRollback(String xid, long branchId, String key, String udata, byte commitMode) {
        this.branchRollback(xid, branchId, key, udata, commitMode, TrxLockMode.NOT_DELETE_TRX_LOCK.getValue());
    }

    @Override
    public void branchRollback(String xid, long branchId, String key, String udata, byte commitMode, int isDelKey) {
        this.branches.get(key).cancelBranch(xid, branchId, udata);
    }

    public void setMtServices(Map<String, Object> mtServices) {
        this.mtServices = mtServices;
    }

    @Override
    public void reportUdata(String xid, long branchId, String key, String udata, boolean delay) throws TxcException {
        if (delay) {
            TxcContext.putMtUdata(udata);
            return;
        }
        ReportUdataMessage reportUdataMessage = new ReportUdataMessage();
        reportUdataMessage.setBranchId(branchId);
        reportUdataMessage.setKey(key);
        reportUdataMessage.setTranId(TxcXID.getTransactionId(xid));
        reportUdataMessage.setUdata(udata);
        try {
            logger.info("send report udata message:" + reportUdataMessage);
            ReportUdataResultMessage resultMessage = (ReportUdataResultMessage)this.getClientMessageSender().invoke(TxcXID.getServerAddress(xid), reportUdataMessage, 30000L);
            if (resultMessage.getResult() != ResultCode.OK.getValue()) {
                throw new TxcException(resultMessage.getResult(), resultMessage.getMsg());
            }
        }
        catch (Throwable th) {
            throw new TxcException(th);
        }
    }

    @Override
    public void queryReadLocks(String key, long tranId, String writeKeys) throws TxcException {
        throw new TxcException("MtResourceManager unsupport queryReadLocks");
    }

    private static class MtBranchMethodHolder {
        public Object targetService;
        public Method commitMethod;
        public Method cancelMethod;

        private MtBranchMethodHolder() {
        }

        public void commitBranch(String xid, long branchId, String udata) {
            try {
                Object o = this.commitMethod.invoke(this.targetService, xid, branchId, udata);
                Type returnType = this.commitMethod.getGenericReturnType();
                if (returnType.toString().compareTo("boolean") == 0 && !((Boolean)o).booleanValue()) {
                    throw new TxcException("commit mq false");
                }
            }
            catch (Throwable e) {
                if (e instanceof TxcException) {
                    throw (TxcException)e;
                }
                throw new TxcException(e);
            }
        }

        public void cancelBranch(String xid, long branchId, String udata) {
            try {
                this.cancelMethod.invoke(this.targetService, xid, branchId, udata);
            }
            catch (Throwable e) {
                if (e instanceof TxcException) {
                    throw (TxcException)e;
                }
                throw new TxcException(e);
            }
        }
    }
}

