/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.mt;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.resourcemanager.RmRpcClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashSet;
import java.util.concurrent.ThreadPoolExecutor;

public class MtRmRpcClient
extends RmRpcClient {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static MtRmRpcClient instance;

    public MtRmRpcClient(ThreadPoolExecutor txcCommonThreadPoolExecutor) {
        super(txcCommonThreadPoolExecutor);
    }

    public static MtRmRpcClient getInstance(ThreadPoolExecutor txcCommonThreadPoolExecutor) {
        if (instance == null) {
            instance = new MtRmRpcClient(txcCommonThreadPoolExecutor);
        }
        return instance;
    }

    @Override
    public void init() {
        logger.info("MtRmRpcClient init");
        super.init();
    }

    @Override
    public short getRmType() {
        return (short)CommitMode.COMMIT_IN_PHASE2.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fetchServerAddressList() {
        if (this.serverAddressList == null) {
            MtRmRpcClient mtRmRpcClient = this;
            synchronized (mtRmRpcClient) {
                if (this.serverAddressList == null) {
                    try {
                        String content = TxcConfigHolder.getInstance().getConfig("com.taobao.txc.mtjournel." + this.getGroup(), "TXC_MT_JOURNEL", 5000L);
                        this.serverAddressList = new HashSet();
                        if (content != null) {
                            String line;
                            BufferedReader br = new BufferedReader(new StringReader(content));
                            while ((line = br.readLine()) != null) {
                                logger.info(String.format("add a server of mt [%s]", line));
                                this.serverAddressList.add(line);
                            }
                            for (String serverAddress : this.serverAddressList) {
                                this.fetchVipServerAddressIfAbsentOnce(serverAddress);
                            }
                        }
                    }
                    catch (IOException e) {
                        TxcErrCode code = TxcErrCode.DiamondGetConfig;
                        logger.error(code.errCode, code.errMessage, (Throwable)e);
                    }
                }
            }
        }
    }
}

