/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.mt.service;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.task.TaskParameter;
import com.taobao.txc.resourcemanager.ResourceManager;
import com.taobao.txc.resourcemanager.mt.service.MtServiceTask;
import com.taobao.txc.resourcemanager.mt.service.TaskRelationManager;
import java.util.Calendar;
import java.util.Map;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class MtServiceTaskImpl
implements MtServiceTask {
    private JdbcTemplate jdbcTemplate;
    private ResourceManager resourceManager;
    private TaskRelationManager taskRelationManager;
    private static final LoggerWrap logger = LoggerInit.logger;
    private MtServiceTask mtServiceTask = null;
    private static MtServiceTask instance = null;
    private static final transient ThreadLocal<String> threadLocalFullXid = new ThreadLocal();
    private static final transient ThreadLocal<TaskParameter> threadLocalTaskPara = new ThreadLocal();

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setMtServiceTask(MtServiceTask mtServiceTask) {
        this.mtServiceTask = mtServiceTask;
        if (instance == null) {
            instance = mtServiceTask;
        }
    }

    public MtServiceTask getMtServiceTask() {
        return this.mtServiceTask;
    }

    public static MtServiceTask getInstance() {
        return instance;
    }

    @Override
    public TaskRelationManager getTaskRelationManager() {
        return this.taskRelationManager;
    }

    public void setTaskRelationManager(TaskRelationManager taskRelationManager) {
        this.taskRelationManager = taskRelationManager;
    }

    public static ThreadLocal<String> getThreadlocalfullxid() {
        return threadLocalFullXid;
    }

    public static ThreadLocal<TaskParameter> getThreadlocaltaskpara() {
        return threadLocalTaskPara;
    }

    @Override
    public void task(String txId, long branchId, String udata, String taskName) {
        this.jdbcTemplate.update("insert into txc_task (xid,branchid,udata,taskname) values (?,?,?,?)", new Object[]{txId, branchId, udata, taskName});
    }

    @Override
    public boolean commitTask(String txId, long branchId, String data) {
        String taskName;
        String udata;
        logger.info(txId + ":" + branchId + ":" + data);
        try {
            Map map = this.jdbcTemplate.queryForMap("select udata, taskname from txc_task where branchid=" + branchId + " and xid='" + txId + "'");
            udata = (String)map.get("udata");
            taskName = (String)map.get("taskname");
            logger.info("xid:" + txId + ",branchId:" + branchId + ",data:" + data + ",udata:" + udata + ",taskName:" + taskName);
        }
        catch (EmptyResultDataAccessException e) {
            return true;
        }
        return this.runTask(taskName, udata, txId, branchId);
    }

    @Override
    public boolean rollbackTask(String txId, long branchId, String data) {
        String taskName;
        String udata;
        logger.info(txId + ":" + branchId + ":" + data);
        try {
            Map map = this.jdbcTemplate.queryForMap("select udata, taskname from txc_task where branchid=" + branchId + " and xid='" + txId + "'");
            udata = (String)map.get("udata");
            taskName = (String)map.get("taskname");
            logger.info("xid:" + txId + ",branchId:" + branchId + ",data:" + data + ",udata:" + udata + ",taskName:" + taskName);
        }
        catch (EmptyResultDataAccessException e) {
            return true;
        }
        if (data != null && data.length() > 0) {
            logger.info("data:" + data + ", now:" + Calendar.getInstance().getTimeInMillis());
            if (Long.parseLong(data) > Calendar.getInstance().getTimeInMillis()) {
                return false;
            }
        }
        if (this.taskRelationManager.getTask(taskName).check(udata)) {
            return this.runTask(taskName, udata, txId, branchId);
        }
        try {
            this.jdbcTemplate.update("delete from txc_task where branchid=" + branchId + " and xid='" + txId + "'");
        }
        catch (Exception e) {
            logger.error("", "mt fail", (Throwable)e);
            throw new TxcException(e);
        }
        return true;
    }

    @Override
    public boolean runTask(String taskName, String udata, String txId, long branchId) {
        try {
            if (!this.taskRelationManager.getTask(taskName).process(udata)) {
                return false;
            }
            String sql = "delete from txc_task where branchid=" + branchId + " and xid='" + txId + "'";
            logger.info(sql);
            this.jdbcTemplate.update(sql);
        }
        catch (Exception e) {
            logger.error("", "mt fail", (Throwable)e);
            if (e instanceof TxcException) {
                throw (TxcException)e;
            }
            throw new TxcException(e);
        }
        return true;
    }
}

