/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.rt;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.BeginRetryBranchMessage;
import com.taobao.txc.common.message.BeginRetryBranchResultMessage;
import com.taobao.txc.resourcemanager.TxcBaseResourceManagerImpl;
import com.taobao.txc.resourcemanager.TxcResourceManagerImpl;
import com.taobao.txc.resourcemanager.jdbc.TxcAtomDataSourceHelper;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import com.taobao.txc.resourcemanager.rt.RtRpcClient;
import com.taobao.txc.rpc.api.TxcClientMessageSender;
import com.taobao.txc.rpc.impl.RpcClient;

public class RtResourceManager
extends TxcResourceManagerImpl {
    private static final LoggerWrap logger = LoggerInit.logger;
    private RtRpcClient rpcClient;

    public static RtResourceManager getRtResourceManager() {
        return (RtResourceManager)TxcBaseResourceManagerImpl.getInstance("rt");
    }

    @Override
    public void setClientMessageSender(TxcClientMessageSender clientMessageSender) {
        this.rpcClient = (RtRpcClient)clientMessageSender;
        super.setClientMessageSender(clientMessageSender);
    }

    public BeginRetryBranchResultMessage beginRtBranch(ITxcDataSource dataSource, String sql) {
        return this.beginRtBranch(dataSource, sql, 10);
    }

    public BeginRetryBranchResultMessage beginRtBranch(ITxcDataSource dataSource, String sql, int retryTimes) {
        BeginRetryBranchMessage message = new BeginRetryBranchMessage();
        BeginRetryBranchResultMessage resultMessage = null;
        message.setDbName(dataSource.getDbName());
        message.setSql(sql);
        long l = TxcContext.getEffectiveTime();
        if (l < 0L) {
            return null;
        }
        message.setEffectiveTime(l);
        message.setCommitMode((byte)CommitMode.COMMIT_RETRY_MODE.getValue());
        int i = 0;
        while (i < retryTimes) {
            try {
                RpcClient.ChannelPackage cp = this.rpcClient.roundRobinBalanceNextChannel();
                TxcAtomDataSourceHelper.checkRtJournel(dataSource, cp.address);
                resultMessage = (BeginRetryBranchResultMessage)this.rpcClient.invoke(cp.address, cp.channel, message, 30000L);
                return resultMessage;
            }
            catch (Exception e) {
                logger.error(TxcErrCode.BeginRtBranch.errCode, e.getMessage(), (Throwable)e);
            }
        }
        return resultMessage;
    }

    @Override
    public void queryReadLocks(String key, long tranId, String writeKeys) throws TxcException {
        throw new TxcException("RtResourceManager unsupport queryReadLocks");
    }
}

