/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.rt;

import com.taobao.txc.common.CommitMode;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.resourcemanager.IRmRpcClient;
import com.taobao.txc.resourcemanager.jdbc.TxcAtomDataSourceHelper;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcDataSource;
import com.taobao.txc.rpc.impl.RegisterRmMessage;
import com.taobao.txc.rpc.impl.RegisterRmResultMessage;
import com.taobao.txc.rpc.impl.RpcClient;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@ChannelHandler.Sharable
public class RtRpcClient
extends RpcClient
implements IRmRpcClient {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static RtRpcClient instance;

    private RtRpcClient(ThreadPoolExecutor txcCommonThreadPoolExecutor) {
        super(txcCommonThreadPoolExecutor);
    }

    public static RtRpcClient getInstance(ThreadPoolExecutor txcCommonThreadPoolExecutor) {
        if (instance == null) {
            instance = new RtRpcClient(txcCommonThreadPoolExecutor);
        }
        return instance;
    }

    @Override
    public void init() {
        this.timerExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Map<ITxcDataSource, Map<String, String>> map = TxcAtomDataSourceHelper.getRtServerJournelMap();
                for (Map.Entry<ITxcDataSource, Map<String, String>> e : map.entrySet()) {
                    for (Map.Entry<String, String> innerE : e.getValue().entrySet()) {
                        RtRpcClient.this.connect(innerE.getKey());
                    }
                }
            }
        }, 30L, 60L, TimeUnit.SECONDS);
        super.init(30L, 60L);
    }

    @Override
    public void setClientAppName(String clientAppName) {
        super.setClientAppName(clientAppName + "_rt");
    }

    @Override
    protected String getTargetServerAddress(String serverAddress) {
        throw new RuntimeException("unsupprted method!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Channel connect(String serverAddress) {
        String dbKey;
        Channel channelToServer = (Channel)this.channels.get(serverAddress);
        if (channelToServer != null) {
            if (channelToServer.isActive()) {
                return channelToServer;
            }
            for (int i = 0; i < 1000; ++i) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!channelToServer.isActive()) continue;
                return channelToServer;
            }
            try {
                logger.warn("channel " + channelToServer + " is not active after long wait, close it.");
                Object connectLock = this.channelLocks.get(serverAddress);
                if (connectLock == null) {
                    this.channelLocks.putIfAbsent(serverAddress, new Object());
                    connectLock = this.channelLocks.get(serverAddress);
                }
                Object v = connectLock;
                synchronized (v) {
                    Channel ch = (Channel)this.channels.get(serverAddress);
                    if (ch != null && ch.compareTo((Object)channelToServer) == 0) {
                        this.channels.remove(serverAddress);
                        channelToServer.disconnect();
                        channelToServer.close();
                    }
                }
            }
            catch (Exception connectLock) {
            }
            catch (Throwable throwable) {
                throw throwable;
            }
        }
        if ((dbKey = TxcAtomDataSourceHelper.getDbKeysFromSet()) == null || dbKey.length() == 0) {
            throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not register RM because no dbkey found.");
        }
        logger.info("connect to " + serverAddress);
        Object connectLock = this.channelLocks.get(serverAddress);
        if (connectLock == null) {
            this.channelLocks.putIfAbsent(serverAddress, new Object());
            connectLock = this.channelLocks.get(serverAddress);
        }
        Object v = connectLock;
        synchronized (v) {
            Channel tmpChannel = super._connect(serverAddress);
            try {
                logger.info("RM will register dbkey:" + dbKey);
                RegisterRmMessage message = new RegisterRmMessage(dbKey);
                message.setType((short)CommitMode.COMMIT_RETRY_MODE.getValue());
                Object response = super.invoke(null, tmpChannel, message, 30000L);
                if (response instanceof RegisterRmResultMessage) {
                    channelToServer = tmpChannel;
                    this.channels.put(serverAddress, channelToServer);
                    if (((RegisterRmResultMessage)response).isResult()) {
                        logger.info("register RM sucesss. server version:" + ((RegisterRmResultMessage)response).getVersion());
                    } else {
                        logger.info("register RM failed. server version:" + ((RegisterRmResultMessage)response).getVersion());
                    }
                    return channelToServer;
                }
                throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not register RM.");
            }
            catch (Exception e) {
                logger.error(TxcErrCode.RegistRM.errCode, "register RM failed.", (Throwable)e);
                throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not register RM.");
            }
        }
    }

    @Override
    public void sendResponse(long msgId, String serverAddress, Object msg) {
        logger.info("RmRpcClient sendResponse" + msg);
        super.sendResponse(msgId, this.connect(serverAddress), msg);
    }
}

