/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.undo;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.parser.struct.RollbackInfor;
import com.taobao.txc.parser.struct.TxcTable;
import com.taobao.txc.resourcemanager.undo.TxcDeleteUndo;
import com.taobao.txc.resourcemanager.undo.TxcInsertOnDuplicateKeyUndo;
import com.taobao.txc.resourcemanager.undo.TxcInsertUndo;
import com.taobao.txc.resourcemanager.undo.TxcUpdateUndo;
import com.taobao.txc.resourcemanager.undo.api.ITxcUndoExcutor;
import java.sql.SQLException;

public abstract class AbstractUndoExcutor
implements ITxcUndoExcutor {
    private static final LoggerWrap logger = LoggerInit.logger;
    private final RollbackInfor txcUndoLogRollbackInfor;

    public AbstractUndoExcutor(RollbackInfor txcUndoLogRollbackInfor) {
        this.txcUndoLogRollbackInfor = txcUndoLogRollbackInfor;
    }

    public static ITxcUndoExcutor createTxcUndoExcutor(RollbackInfor txcUndoLogRollbackInfor) throws SQLException {
        AbstractUndoExcutor undo = null;
        switch (txcUndoLogRollbackInfor.getSqlType()) {
            case DELETE: {
                undo = new TxcDeleteUndo(txcUndoLogRollbackInfor);
                break;
            }
            case INSERT: {
                undo = new TxcInsertUndo(txcUndoLogRollbackInfor);
                break;
            }
            case UPDATE: {
                undo = new TxcUpdateUndo(txcUndoLogRollbackInfor);
                break;
            }
            case INSERT_ON_DUPLICATE_UPDATE: {
                undo = new TxcInsertOnDuplicateKeyUndo(txcUndoLogRollbackInfor);
                break;
            }
            default: {
                String errorLog = "sqltype error:" + (Object)((Object)txcUndoLogRollbackInfor.getSqlType());
                logger.error(TxcErrCode.DBSQlType.errCode, errorLog);
                throw new SQLException(errorLog);
            }
        }
        return undo;
    }

    public RollbackInfor getTxcUndoLogRollbackInfor() {
        return this.txcUndoLogRollbackInfor;
    }

    public TxcTable getOriginalValue() {
        return this.txcUndoLogRollbackInfor.getFrontImage();
    }

    public TxcTable getPresentValue() {
        return this.txcUndoLogRollbackInfor.getRearImage();
    }
}

