/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.resourcemanager.undo;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.parser.struct.RollbackInfor;
import com.taobao.txc.resourcemanager.executor.template.MySQLExecutorTemplate;
import com.taobao.txc.resourcemanager.jdbc.api.ITxcConnection;
import com.taobao.txc.resourcemanager.undo.AbstractUndoExcutor;
import java.sql.SQLException;

public class TxcUpdateUndo
extends AbstractUndoExcutor {
    private static final LoggerWrap logger = LoggerInit.logger;

    public TxcUpdateUndo(RollbackInfor txcUndoLogRollbackInfor) {
        super(txcUndoLogRollbackInfor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(ITxcConnection conn) throws SQLException {
        String rule = this.getTxcUndoLogRollbackInfor().getRollbackRule();
        if (rule == null && this.getOriginalValue().linesNum() != this.getPresentValue().linesNum()) {
            throw new TxcException(ResultCode.LOGICERROR.getValue(), "line num changed.");
        }
        MySQLExecutorTemplate template = new MySQLExecutorTemplate(conn);
        for (int index = 0; index < this.getOriginalValue().linesNum(); ++index) {
            long bid;
            String xid;
            long start = System.currentTimeMillis();
            try {
                if (rule == null) {
                    template.updateByPks(this.getOriginalValue().getLinesList().get(index), this.getOriginalValue().getTableMeta());
                } else {
                    template.updateByRule(this.getOriginalValue().getLinesList().get(index), this.getOriginalValue().getTableMeta(), rule);
                }
                xid = this.getTxcUndoLogRollbackInfor().getXid();
                bid = this.getTxcUndoLogRollbackInfor().getBid();
            }
            catch (Throwable throwable) {
                String xid2 = this.getTxcUndoLogRollbackInfor().getXid();
                long bid2 = this.getTxcUndoLogRollbackInfor().getBid();
                logger.info(String.format("[%d:%d] [rule:%s] [%s] cost %d ms", TxcXID.getTransactionId(xid2), bid2, rule, this.getOriginalValue().getLinesList().get(index), System.currentTimeMillis() - start));
                throw throwable;
            }
            logger.info(String.format("[%d:%d] [rule:%s] [%s] cost %d ms", TxcXID.getTransactionId(xid), bid, rule, this.getOriginalValue().getLinesList().get(index), System.currentTimeMillis() - start));
        }
    }
}

