/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rm.mq;

import com.aliyun.openservices.ons.api.ONSFactory;
import com.aliyun.openservices.ons.api.Producer;
import com.aliyun.openservices.ons.api.impl.rocketmq.ProducerImpl;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.Validators;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.exception.MQClientException;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.DefaultMQProducer;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.LocalTransactionState;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendResult;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.client.producer.SendStatus;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.Message;
import com.aliyun.openservices.shade.com.alibaba.rocketmq.common.message.MessageAccessor;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.resourcemanager.mt.MtResourceManager;
import com.taobao.txc.rm.mq.TxcMQProducer;
import java.util.Properties;

public class TxcMQProducerImpl
implements TxcMQProducer {
    private static final LoggerWrap logger = LoggerInit.logger;
    private MtResourceManager resourceManager;
    private DefaultMQProducer defaultMQProducer;

    public TxcMQProducerImpl(Producer producer) {
        DefaultMQProducer defaultMQProducer;
        if (producer == null || !(producer instanceof ProducerImpl)) {
            throw new RuntimeException("Illegal MQ Producer " + producer + ". Should be instance of " + ProducerImpl.class);
        }
        this.defaultMQProducer = defaultMQProducer = ((ProducerImpl)producer).getDefaultMQProducer();
        this.resourceManager = MtResourceManager.getTxcResourceManager();
    }

    public TxcMQProducerImpl(DefaultMQProducer defaultMQProducer) {
        this.defaultMQProducer = defaultMQProducer;
        this.resourceManager = MtResourceManager.getTxcResourceManager();
    }

    @Deprecated
    public TxcMQProducerImpl(String producerId, String accessKey, String secretKey) {
        this(producerId, accessKey, secretKey, null);
    }

    @Deprecated
    public TxcMQProducerImpl(String producerId, String accessKey, String secretKey, String onsAddr) {
        Properties properties = new Properties();
        properties.put("ProducerId", producerId);
        properties.put("AccessKey", accessKey);
        properties.put("SecretKey", secretKey);
        if (null != onsAddr) {
            properties.put("ONSAddr", onsAddr);
        }
        Producer producer = ONSFactory.createProducer((Properties)properties);
        this.defaultMQProducer = ((ProducerImpl)producer).getDefaultMQProducer();
        this.resourceManager = MtResourceManager.getTxcResourceManager();
    }

    @Override
    public SendResult send(String xid, long branchId, Message msg) {
        try {
            Validators.checkMessage((Message)msg, (DefaultMQProducer)this.defaultMQProducer);
        }
        catch (Exception e) {
            throw new RuntimeException("message validate error", e);
        }
        SendResult sendResult = null;
        try {
            MessageAccessor.putProperty((Message)msg, (String)"TRAN_MSG", (String)"true");
            MessageAccessor.putProperty((Message)msg, (String)"PGROUP", (String)this.defaultMQProducer.getProducerGroup());
            sendResult = this.defaultMQProducer.send(msg);
        }
        catch (Exception e) {
            throw new RuntimeException("send message Exception", e);
        }
        SendStatus ss = sendResult.getSendStatus();
        if (ss == SendStatus.SEND_OK && sendResult.getTransactionId() != null) {
            MessageAccessor.putProperty((Message)msg, (String)"__transactionId__", (String)sendResult.getTransactionId());
        }
        String udataOfSendResult = SendResult.encoderSendResultToJson((Object)sendResult);
        this.resourceManager.reportUdata(xid, branchId, "TxcMetaQProducer.send", udataOfSendResult, true);
        return sendResult;
    }

    @Override
    public boolean rollback(String txId, long branchId, String udataOfSendResult) {
        SendResult sendResult = SendResult.decoderSendResultFromJson((String)udataOfSendResult);
        LocalTransactionState localTransactionState = LocalTransactionState.ROLLBACK_MESSAGE;
        try {
            this.defaultMQProducer.getDefaultMQProducerImpl().endTransaction(sendResult, localTransactionState, null);
        }
        catch (Exception e) {
            logger.warn("local transaction execute " + localTransactionState + ",but end broker transaction failed,e:" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean commit(String txId, long branchId, String udataOfSendResult) {
        SendResult sendResult = SendResult.decoderSendResultFromJson((String)udataOfSendResult);
        LocalTransactionState localTransactionState = LocalTransactionState.COMMIT_MESSAGE;
        try {
            this.defaultMQProducer.getDefaultMQProducerImpl().endTransaction(sendResult, localTransactionState, null);
        }
        catch (Exception e) {
            logger.warn("local transaction execute " + localTransactionState + ", but end broker transaction failed,e:" + e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public void start() throws MQClientException {
        this.defaultMQProducer.start();
    }

    @Override
    public void shutdown() {
        this.defaultMQProducer.shutdown();
    }

    public MtResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public void setResourceManager(MtResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }
}

