/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rpc.impl;

import com.taobao.txc.common.NetUtil;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.common.util.version.VerNum;
import com.taobao.txc.common.util.version.Version;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang.StringUtils;

public class RegisterClientAppNameMessage
extends TxcMessage
implements Serializable {
    private static final long serialVersionUID = -5929081344190543690L;
    private String clientAppName;
    private String version = Version.getVersion();
    private String txcInsts;
    private String udata = "";
    private String vgroupName;
    private int clientType;
    private String udataIp;
    public static final String UDATA_VGROUP = "vgroup";
    public static final String UDATA_AK = "ak";
    public static final String UDATA_DIGEST = "digest";
    public static final String UDATA_TYPE = "type";
    public static final String UDATA_IP = "ip";
    public static final String UDATA_TIMESTAMP = "timestamp";
    public ByteBuffer byteBuffer = ByteBuffer.allocate(0x200000);

    public RegisterClientAppNameMessage() {
    }

    public RegisterClientAppNameMessage(String appName) {
        this(appName, null, appName, 0);
    }

    public RegisterClientAppNameMessage(String appName, String txcInsts, String vgroupName, int clientType) {
        this.clientAppName = appName;
        this.txcInsts = txcInsts;
        this.vgroupName = vgroupName;
        this.clientType = clientType;
        if (vgroupName != null && !vgroupName.isEmpty()) {
            this.udata = String.format("%s=%s\n", UDATA_VGROUP, vgroupName);
            this.udataIp = NetUtil.getLocalIp();
            if (!StringUtils.isEmpty((String)this.udataIp)) {
                this.udata = String.format("%s\n%s=%s\n", this.udata, UDATA_IP, this.udataIp);
            }
        }
    }

    public String getClientAppName() {
        return this.clientAppName;
    }

    public void setClientAppName(String clientAppName) {
        this.clientAppName = clientAppName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setTxcInsts(String txcInsts) {
        this.txcInsts = txcInsts;
    }

    public String getTxcInsts() {
        return this.txcInsts;
    }

    @Override
    public short getTypeCode() {
        return 101;
    }

    @Override
    public byte[] encode() {
        byte[] bs;
        if (this.clientAppName != null) {
            bs = this.clientAppName.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.version != null) {
            bs = this.version.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.txcInsts != null) {
            bs = this.txcInsts.getBytes(UTF8);
            this.byteBuffer.putInt(bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        if (this.udata != null && !this.udata.isEmpty()) {
            bs = this.udata.getBytes(UTF8);
            this.byteBuffer.putInt(bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        byte[] bs;
        int ilen;
        byte[] bs2;
        int i = in.readableBytes();
        if (i < 8) {
            return false;
        }
        i -= 8;
        short len = in.readShort();
        if (len > 0) {
            if (i < len) {
                return false;
            }
            i -= len;
            bs2 = new byte[len];
            in.readBytes(bs2);
            this.setClientAppName(new String(bs2, UTF8));
        }
        if ((len = in.readShort()) > 0) {
            if (i < len) {
                return false;
            }
            i -= len;
            bs2 = new byte[len];
            in.readBytes(bs2);
            this.setVersion(new String(bs2, UTF8));
        }
        if ((ilen = in.readInt()) > 0) {
            if (i < ilen) {
                return false;
            }
            i -= ilen;
            bs = new byte[ilen];
            in.readBytes(bs);
            this.setTxcInsts(new String(bs, UTF8));
        }
        if (i < 4) {
            return false;
        }
        ilen = in.readInt();
        i -= 4;
        if (ilen > 0) {
            if (i < ilen) {
                return false;
            }
            bs = new byte[ilen];
            in.readBytes(bs);
            this.setUdata(new String(bs, UTF8));
        }
        return true;
    }

    public String getUdata() {
        return this.udata;
    }

    public void setUdata(String udata) {
        this.udata = udata;
    }

    public String digest(String ak, String sk) {
        if (this.vgroupName == null || this.vgroupName.isEmpty()) {
            throw new RuntimeException("register client failed, vgroup is empty!");
        }
        StringBuilder sb = new StringBuilder(this.udata);
        String digest = null;
        if (this.clientType == 1) {
            sb.append(UDATA_TYPE).append('=').append("drds").append('\n');
        } else {
            if (ak == null || ak.isEmpty() || sk == null || sk.isEmpty()) {
                return null;
            }
            String timestamp = String.valueOf(System.currentTimeMillis());
            long authLevel = TxcConfigHolder.getInstance().getCheckAuthLevel();
            try {
                Class<?> cls = Class.forName("com.taobao.spas.sdk.common.sign.SpasSigner");
                Method m = cls.getDeclaredMethod("sign", String.class, String.class);
                String digestSource = authLevel == 2L ? (StringUtils.isEmpty((String)this.udataIp) ? this.vgroupName + ",127.0.0.1," + timestamp : this.vgroupName + "," + this.udataIp + "," + timestamp) : this.vgroupName;
                digest = (String)m.invoke(cls, digestSource, sk);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("digest failed, no dauth!");
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("digest failed, no dauth method!");
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("digest failed, invoke dauth method!");
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("digest failed, invoke dauth method!");
            }
            if (digest == null || digest.isEmpty()) {
                throw new RuntimeException("digest empty!");
            }
            sb.append(UDATA_AK).append('=').append(ak).append('\n');
            sb.append(UDATA_DIGEST).append('=').append(digest).append('\n');
            if (authLevel == 2L) {
                sb.append(UDATA_TIMESTAMP).append('=').append(timestamp).append('\n');
            }
        }
        this.udata = sb.toString();
        return digest;
    }

    public Map<String, String> parseUdata() {
        if (this.udata == null || this.udata.isEmpty()) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer stringTokenizer = new StringTokenizer(this.udata, "\n");
        while (stringTokenizer.hasMoreElements()) {
            String line = stringTokenizer.nextToken();
            int pos = line.indexOf(61);
            if (pos == -1) continue;
            map.put(line.substring(0, pos), line.substring(pos + 1));
        }
        if (new VerNum(this.version).smallerThan("2.0.21")) {
            map.put(UDATA_VGROUP, this.clientAppName);
        }
        return map;
    }
}

