/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rpc.impl;

import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.common.util.version.Version;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class RegisterRmMessage
extends TxcMessage
implements Serializable {
    private static final long serialVersionUID = 7539732523682335742L;
    private String dbKeys;
    private String version = Version.getVersion();
    private short type = 0;
    private String appName;
    public ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);

    public RegisterRmMessage() {
    }

    public RegisterRmMessage(String dbKeys) {
        this.dbKeys = dbKeys;
        this.type = 0;
        this.appName = null;
    }

    public String getDbKeys() {
        return this.dbKeys;
    }

    public void setDbKeys(String dbKeys) {
        this.dbKeys = dbKeys;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public short getType() {
        return this.type;
    }

    public void setType(short type) {
        this.type = type;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    @Override
    public short getTypeCode() {
        return 103;
    }

    @Override
    public byte[] encode() {
        byte[] bs;
        if (this.dbKeys != null) {
            bs = this.dbKeys.getBytes(UTF8);
            this.byteBuffer.putInt(bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putInt(0);
        }
        if (this.version != null) {
            bs = this.version.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        if (this.version != null) {
            this.byteBuffer.putShort(this.type);
            if (this.appName != null) {
                bs = this.appName.getBytes(UTF8);
                this.byteBuffer.putShort((short)bs.length);
                if (bs.length > 0) {
                    this.byteBuffer.put(bs);
                }
            } else {
                this.byteBuffer.putShort((short)0);
            }
        }
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        short len;
        byte[] bs;
        int i = in.readableBytes();
        if (i < 6) {
            return false;
        }
        i -= 6;
        int iLen = in.readInt();
        if (iLen > 0) {
            if (i < iLen) {
                return false;
            }
            i -= iLen;
            bs = new byte[iLen];
            in.readBytes(bs);
            this.setDbKeys(new String(bs, UTF8));
        }
        if ((len = in.readShort()) > 0) {
            if (i < len) {
                return false;
            }
            i -= len;
            bs = new byte[len];
            in.readBytes(bs);
            this.setVersion(new String(bs, UTF8));
        }
        if (this.version != null) {
            if (i < 4) {
                return false;
            }
            i -= 4;
            this.type = in.readShort();
            len = in.readShort();
            if (len > 0) {
                if (i < len) {
                    return false;
                }
                i -= len;
                bs = new byte[len];
                in.readBytes(bs);
                this.setAppName(new String(bs, UTF8));
            }
        }
        return true;
    }

    public String toString() {
        return "RegisterRmMessage dbkey:" + this.dbKeys + ",appname:" + this.appName;
    }
}

