/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rpc.impl;

import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.common.util.version.Version;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.nio.ByteBuffer;

public class RegisterRmResultMessage
extends TxcMessage
implements Serializable {
    private static final long serialVersionUID = 6391375605848221420L;
    private String version = Version.getVersion();
    private boolean result;
    public ByteBuffer byteBuffer = ByteBuffer.allocate(256);

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean isResult() {
        return this.result;
    }

    public void setResult(boolean result) {
        this.result = result;
    }

    public RegisterRmResultMessage() {
        this.result = true;
    }

    public RegisterRmResultMessage(boolean result) {
        this.result = result;
    }

    @Override
    public short getTypeCode() {
        return 104;
    }

    @Override
    public byte[] encode() {
        this.byteBuffer.put(this.result ? (byte)1 : 0);
        if (this.version != null) {
            byte[] bs = this.version.getBytes(UTF8);
            this.byteBuffer.putShort((short)bs.length);
            if (bs.length > 0) {
                this.byteBuffer.put(bs);
            }
        } else {
            this.byteBuffer.putShort((short)0);
        }
        this.byteBuffer.flip();
        byte[] content = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(content);
        return content;
    }

    @Override
    public boolean decode(ByteBuf in) {
        int i = in.readableBytes();
        if (i < 3) {
            return false;
        }
        i -= 3;
        this.result = in.readBoolean();
        short len = in.readShort();
        if (len > 0) {
            if (i < len) {
                return false;
            }
            byte[] bs = new byte[len];
            in.readBytes(bs);
            this.setVersion(new String(bs, UTF8));
        }
        return true;
    }
}

