/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rpc.impl;

import com.alibaba.fastjson.JSON;
import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.NetUtil;
import com.taobao.txc.common.TxcConstants;
import com.taobao.txc.common.TxcContext;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.config.IConfigCallback;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.BeginResultMessage;
import com.taobao.txc.common.message.GlobalRollbackMessage;
import com.taobao.txc.common.message.ResultCode;
import com.taobao.txc.common.message.TxcMergeMessage;
import com.taobao.txc.common.message.TxcMergeResultMessage;
import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.common.util.CommandStreamReader;
import com.taobao.txc.common.util.http.HttpSecurity;
import com.taobao.txc.common.util.string.TStringUtil;
import com.taobao.txc.common.util.string.TxcString;
import com.taobao.txc.rpc.api.ClientMessageListener;
import com.taobao.txc.rpc.api.TxcClientMessageSender;
import com.taobao.txc.rpc.impl.HeartbeatMessage;
import com.taobao.txc.rpc.impl.MessageFuture;
import com.taobao.txc.rpc.impl.RegisterClientAppNameMessage;
import com.taobao.txc.rpc.impl.RegisterClientAppNameResultMessage;
import com.taobao.txc.rpc.impl.RpcEndpoint;
import com.taobao.txc.rpc.impl.RpcMessage;
import com.taobao.txc.rpc.impl.TxcMessageCodec;
import com.taobao.txc.rpc.util.AddressWatcher;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;

@ChannelHandler.Sharable
public class RpcClient
extends RpcEndpoint
implements TxcClientMessageSender {
    private static final LoggerWrap logger = LoggerInit.logger;
    private static RpcClient instance;
    private AtomicLong requestSeq = new AtomicLong(0L);
    private NioEventLoopGroup eventloopGroup = new NioEventLoopGroup(1);
    private ClientMessageListener clientMessageListener;
    protected ConcurrentHashMap<String, Object> channelLocks = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Channel> channels = new ConcurrentHashMap();
    private String dockerId;
    private String clientAppName;
    private Set<String> txcInsts = null;
    private int clientType = 0;
    private static Random rand;
    private String accessKey;
    private String secretKey;
    private static int switchGroupTimes;
    private static boolean isChannelOk;
    public static String weightRule;
    private static List<TxcWeight> weightList;
    public static Map<Integer, Integer> randomVauleToIndexMap;
    public LinkedList<String> rGroupList = new LinkedList();
    public Map<String, String> serverAddressToRGroupMap = new ConcurrentHashMap<String, String>();
    private long lastServerListChange = System.currentTimeMillis();
    private static HttpSecurity httpSecurity;

    protected RpcClient(ThreadPoolExecutor txcCommonThreadPoolExecutor) {
        super(txcCommonThreadPoolExecutor);
    }

    public static RpcClient getInstance() {
        if (instance == null) {
            throw new TxcException("RpcClient not inited.");
        }
        return instance;
    }

    public static RpcClient getNullableInstance() {
        return instance;
    }

    public static HttpSecurity getHttpSecurity() {
        return httpSecurity;
    }

    public static List<TxcWeight> getWeightList() {
        return weightList;
    }

    public static void setWeightList(List<TxcWeight> weightList) {
        RpcClient.weightList = weightList;
    }

    public static RpcClient getInstance(ThreadPoolExecutor txcCommonThreadPoolExecutor) {
        if (instance == null) {
            instance = new RpcClient(txcCommonThreadPoolExecutor);
            TxcConfigHolder.getInstance().getWeightDynamic(new IConfigCallback(){

                @Override
                public void callback(String content) {
                    logger.info(String.format("weight set to: %s", content));
                    weightRule = content;
                    weightList.clear();
                    if (weightRule != null) {
                        String[] rules = weightRule.split(";");
                        if (rules == null || rules.length == 0) {
                            return;
                        }
                        for (String rule : rules) {
                            int idx = rule.indexOf(",");
                            if (idx <= 0) continue;
                            try {
                                String addr = rule.substring(0, idx);
                                int value = Integer.parseInt(rule.substring(idx + 1));
                                weightList.add(new TxcWeight(value, value, addr));
                            }
                            catch (Exception e) {
                                logger.error("", "weight rule parse error. rule:" + rule);
                            }
                        }
                    }
                    RpcClient.resetRandomVauleToAddrMap();
                }
            });
        }
        return instance;
    }

    public static void resetRandomVauleToAddrMap() {
        Collections.sort(weightList);
        int totalValue = 0;
        for (TxcWeight txcWeight : weightList) {
            totalValue += txcWeight.logicValue;
        }
        if (totalValue <= 0) {
            return;
        }
        int start = 0;
        int idx = 0;
        randomVauleToIndexMap.clear();
        for (TxcWeight txcWeight : weightList) {
            int ratio = txcWeight.logicValue * 100 / totalValue;
            for (int i = 0; i < ratio; ++i) {
                randomVauleToIndexMap.put(start++, idx);
            }
            ++idx;
        }
        if (start < 100) {
            while (start < 100) {
                randomVauleToIndexMap.put(start++, idx - 1);
            }
        }
    }

    public static String getAppName() {
        if (instance != null) {
            return instance.getClientAppName();
        }
        return null;
    }

    public static String getVgroup() {
        if (instance != null) {
            return instance.getGroup();
        }
        return null;
    }

    @Override
    public void init() {
        this.init(5L, 5L);
    }

    private void getAddressList() throws InterruptedException {
        this.addressManager.getAddressList(this.getGroup(), new AddressWatcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAddressListChanged(List<String> newAddressList) {
                logger.info("received new server list:" + JSON.toJSONString(newAddressList));
                if (weightRule != null && RpcClient.this.addressManager.getServerAddressList().size() == newAddressList.size() && RpcClient.this.addressManager.getServerAddressList().containsAll(newAddressList)) {
                    return;
                }
                RpcClient.this.lastServerListChange = System.currentTimeMillis();
                RpcClient.this.addressManager.setServerAddressList(newAddressList);
                if (newAddressList.size() < 3) {
                    RpcClient.this.addressManager.fetchAndReverseRGroupByVGroup(RpcClient.this.getGroup(), newAddressList.size() == 0 ? null : RpcClient.this.serverAddressToRGroupMap.get(newAddressList.get(0)), httpSecurity);
                }
                if (weightRule != null) {
                    for (String serverAddress : newAddressList) {
                        List<TxcWeight> list = RpcClient.getWeightList();
                        synchronized (list) {
                            for (TxcWeight weight : RpcClient.getWeightList()) {
                                if (!serverAddress.equals(weight.getAddr())) continue;
                                if (weight.getLogicValue() >= weight.getValue()) break;
                                weight.setLogicValue(weight.getValue());
                                RpcClient.resetRandomVauleToAddrMap();
                                break;
                            }
                        }
                    }
                }
                RpcClient.this.reconnect();
            }

            @Override
            public void onVipAddressBind(String serverAddress, String vipAddress) {
                TxcConfigHolder.getInstance().updateVIPMapping(serverAddress, vipAddress);
            }
        });
    }

    private void initVars() throws InterruptedException {
        this.dockerId = RpcClient.getDockerId();
        this.skipVip = TxcConfigHolder.getSkipVip(false);
        logger.info("RpcClient skip vip " + this.skipVip);
        this.getAddressList();
    }

    public void init(long healthCheckDelay, long healthCheckPeriod) {
        try {
            this.initVars();
        }
        catch (Exception e) {
            try {
                logger.warn("server list get failed on current env");
                throw TxcException.nestedException(e);
            }
            catch (Exception e1) {
                throw TxcException.nestedException(e1);
            }
        }
        this.timerExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    RpcClient.this.reconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, healthCheckDelay, healthCheckPeriod, TimeUnit.SECONDS);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Iterator iterator = RpcClient.this.mergeLock;
                    synchronized (iterator) {
                        try {
                            RpcClient.this.mergeLock.wait(1L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    RpcClient.this.isSending = true;
                    for (String address : RpcClient.this.basketMap.keySet()) {
                        BlockingQueue basket = (BlockingQueue)RpcClient.this.basketMap.get(address);
                        if (basket.isEmpty()) continue;
                        TxcMergeMessage mergeMessage = new TxcMergeMessage();
                        int idx = 0;
                        while (!basket.isEmpty()) {
                            RpcMessage msg = (RpcMessage)basket.poll();
                            mergeMessage.msgs.add((TxcMessage)msg.getBody());
                            mergeMessage.msgIds.add(msg.getId());
                            ++idx;
                        }
                        if (idx > 1 && logger.isDebugEnabled()) {
                            logger.debug("msgs:" + idx);
                            for (TxcMessage cm : mergeMessage.msgs) {
                                logger.debug(cm.toString());
                            }
                            StringBuffer sb = new StringBuffer();
                            for (long l : mergeMessage.msgIds) {
                                sb.append("msgid:").append(l).append(";");
                            }
                            sb.append("\n");
                            for (long l : RpcClient.this.futures.keySet()) {
                                sb.append("futures:").append(l).append(";");
                            }
                            logger.debug(sb.toString());
                        }
                        try {
                            RpcClient.this.sendRequest(RpcClient.this.connect(address), mergeMessage);
                        }
                        catch (Exception e) {
                            if (e.getMessage() != null && e.getMessage().contains("channel is not writable") && address != null) {
                                RpcClient.this.channels.remove(address);
                            }
                            logger.error("", "client merge call failed", (Throwable)e);
                        }
                    }
                    RpcClient.this.isSending = false;
                }
            }
        }).start();
        super.init();
    }

    private void reconnect() {
        for (String serverAddress : this.addressManager.getServerAddressList()) {
            try {
                this.connect(serverAddress);
            }
            catch (Exception e) {
                logger.error(TxcErrCode.NetConnect.errCode, "schedule reconnect,can not connect to " + serverAddress + " cause:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.messageExecutor.isShutdown()) {
            return;
        }
        logger.info("channel inactive:" + ctx.channel());
        this.releaseChannel(ctx.channel(), NetUtil.toStringAddress(ctx.channel().remoteAddress()));
        super.channelInactive(ctx);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.eventloopGroup.shutdownGracefully();
    }

    @Override
    public void dispatch(long msgId, ChannelHandlerContext ctx, Object msg) {
        if (this.clientMessageListener != null) {
            String remoteAddress = NetUtil.toStringAddress(ctx.channel().remoteAddress());
            String address = TxcConfigHolder.getInstance().lookupRIP(remoteAddress);
            if (address != null) {
                remoteAddress = address;
            }
            this.clientMessageListener.onMessage(msgId, remoteAddress, msg);
        }
    }

    @Override
    public Object invoke(Object msg, long timeout) throws IOException, TimeoutException {
        Channel c;
        String validAddress = null;
        String svrAddr = TxcXID.getServerAddress(TxcContext.getCurrentXid());
        try {
            validAddress = this.getTargetServerAddress(svrAddr);
        }
        catch (Exception e) {
            logger.info("channel is not ok. msg:" + msg + ",exception:" + e);
            if (msg instanceof GlobalRollbackMessage && TxcContext.getTxcNextSvrAddr() != null) {
                logger.info("I will ask next node (" + TxcContext.getTxcNextSvrAddr() + ") to finish the rollback " + msg + ". real node is " + svrAddr);
                validAddress = this.getTargetServerAddress(TxcContext.getTxcNextSvrAddr());
                ((GlobalRollbackMessage)msg).setRealSvrAddr(svrAddr);
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof TimeoutException) {
                throw (TimeoutException)e;
            }
            throw new TxcException(e);
        }
        Object o = super.invoke(validAddress, this.connect(validAddress), msg, timeout);
        if (o instanceof BeginResultMessage && ((BeginResultMessage)o).getResult() != ResultCode.OK.getValue() && (c = this.channels.remove(validAddress)) != null) {
            try {
                c.disconnect();
                c.close();
                TxcConstants.removeChannelVersion(c);
            }
            catch (Exception e) {
                logger.error("", "close channel " + c + " fail.", (Throwable)e);
            }
        }
        return o;
    }

    protected String getTargetServerAddress(String serverAddress) {
        String addr;
        if (serverAddress != null) {
            return this.connect(serverAddress) == null ? null : serverAddress;
        }
        if (weightRule == null) {
            addr = this.roundRobinBalanceNextChannel().address;
            if (logger.isDebugEnabled()) {
                logger.debug("round robin load balance:" + addr);
            }
        } else {
            addr = this.balanceNextChannel().address;
            if (logger.isDebugEnabled()) {
                logger.debug("weight load balance:" + addr);
            }
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPackage balanceNextChannel() {
        if (logger.isDebugEnabled()) {
            logger.debug("weight load banlance");
        }
        int index = 0;
        Integer value = randomVauleToIndexMap.get(rand.nextInt(100));
        if (value == null) {
            return this.roundRobinBalanceNextChannel();
        }
        index = value;
        block3: for (int times = 0; times < 2; ++times) {
            List<String> tmpServerAddressList = this.addressManager.getServerAddressList();
            if (tmpServerAddressList.size() == 0) {
                throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not find txc server.");
            }
            if (tmpServerAddressList.size() < 3) {
                return this.roundRobinBalanceNextChannel();
            }
            String address = RpcClient.weightList.get((int)index).addr;
            if (tmpServerAddressList.contains(address)) {
                return new ChannelPackage(this.connect(address), address);
            }
            List<TxcWeight> list = weightList;
            synchronized (list) {
                weightList.get(index).setLogicValue(3);
                RpcClient.resetRandomVauleToAddrMap();
            }
            int tmp = 0;
            for (int i = 0; i < 100; ++i) {
                value = randomVauleToIndexMap.get(rand.nextInt(100));
                if (value == null) {
                    return this.roundRobinBalanceNextChannel();
                }
                if (value == index) continue;
                index = tmp;
                continue block3;
            }
        }
        return this.roundRobinBalanceNextChannel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelPackage roundRobinBalanceNextChannel() {
        List<String> tmpServerAddressList;
        Object channel;
        block12: {
            String address;
            if (logger.isDebugEnabled()) {
                logger.debug("round robin load banlance");
            }
            int fetchCount = 0;
            do {
                if ((tmpServerAddressList = this.addressManager.getServerAddressList()).size() == 0) {
                    throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not find txc server.");
                }
                int index = (int)(this.requestSeq.getAndIncrement() % (long)tmpServerAddressList.size());
                address = tmpServerAddressList.get(index);
                if (++fetchCount > tmpServerAddressList.size()) break block12;
            } while ((channel = this.channels.get(address)) == null || !channel.isActive());
            switchGroupTimes = 0;
            isChannelOk = true;
            return new ChannelPackage((Channel)channel, address);
        }
        try {
            logger.warn("all channels are not ok.");
            isChannelOk = false;
            channel = this;
            synchronized (channel) {
                if (switchGroupTimes < 1 && !isChannelOk && System.currentTimeMillis() - this.lastServerListChange > 180000L) {
                    if (this.addressManager.fetchAndReverseRGroupByVGroup(this.getGroup(), this.serverAddressToRGroupMap.get(tmpServerAddressList.get(0)), httpSecurity)) {
                        ++switchGroupTimes;
                        Thread.sleep(30000L);
                        this.lastServerListChange = System.currentTimeMillis();
                        return this.roundRobinBalanceNextChannel();
                    }
                } else if (isChannelOk) {
                    return this.roundRobinBalanceNextChannel();
                }
            }
        }
        catch (Exception e) {
            logger.error(TxcErrCode.TxcVGroupChangedError, e);
        }
        return new ChannelPackage(this.connect(this.addressManager.getServerAddressList().get(0)), this.addressManager.getServerAddressList().get(0));
    }

    @Override
    public Object invoke(Object msg) throws IOException, TimeoutException {
        return this.invoke(msg, 30000L);
    }

    @Override
    public Object invoke(String serverAddress, Object msg, long timeout) throws IOException, TimeoutException {
        return this.invoke(serverAddress, this.connect(serverAddress), msg, timeout);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)msg;
            if (rpcMessage.getBody() == HeartbeatMessage.PONG) {
                if (logger.isDebugEnabled()) {
                    logger.debug("received PONG from " + ctx.channel().remoteAddress());
                }
                return;
            }
            if (((RpcMessage)msg).getBody() instanceof TxcMergeResultMessage) {
                TxcMergeResultMessage results = (TxcMergeResultMessage)((RpcMessage)msg).getBody();
                TxcMergeMessage mergeMessage = (TxcMergeMessage)this.mergeMsgMap.remove(((RpcMessage)msg).getId());
                int num = mergeMessage.msgs.size();
                for (int i = 0; i < num; ++i) {
                    long msgId = mergeMessage.msgIds.get(i);
                    MessageFuture future = (MessageFuture)this.futures.remove(msgId);
                    if (future == null) {
                        logger.info("msg:" + msgId + " is not found in futures.");
                        continue;
                    }
                    future.setResultMessage(results.getMsgs()[i]);
                }
                return;
            }
        }
        super.channelRead(ctx, msg);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent idleStateEvent = (IdleStateEvent)evt;
            if (idleStateEvent.state() == IdleState.READER_IDLE) {
                logger.info("channel" + ctx.channel() + " read idle.");
                try {
                    ctx.disconnect();
                    ctx.close();
                    TxcConstants.removeChannelVersion(ctx.channel());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (idleStateEvent == IdleStateEvent.WRITER_IDLE_STATE_EVENT) {
                try {
                    this.sendRequest(ctx.channel(), HeartbeatMessage.PING);
                }
                catch (Throwable throwable) {
                    logger.error("", "send request error", throwable);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseChannel(Channel channel, String serverAddress) {
        try {
            Object connectLock = this.channelLocks.get(serverAddress);
            if (connectLock == null) {
                this.channelLocks.putIfAbsent(serverAddress, new Object());
                connectLock = this.channelLocks.get(serverAddress);
            }
            Object object = connectLock;
            synchronized (object) {
                Channel ch = this.channels.get(serverAddress);
                if (channel == null || ch != null && ch.compareTo((Object)channel) == 0) {
                    if (channel == null && (channel = ch) == null) {
                        return;
                    }
                    this.channels.remove(serverAddress);
                    try {
                        logger.info("release channel:" + channel);
                        channel.disconnect();
                        channel.close();
                        TxcConstants.removeChannelVersion(channel);
                    }
                    catch (Exception e) {
                        logger.error("", "close channel" + channel + " fail.", (Throwable)e);
                    }
                }
            }
        }
        catch (Exception exception) {
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Channel connect(String serverAddress) {
        Object connectLock;
        Channel channelToServer = this.channels.get(serverAddress);
        if (channelToServer != null) {
            if (channelToServer.isActive()) {
                return channelToServer;
            }
            int i = 0;
            for (i = 0; i < TxcConfigHolder.getInstance().getMaxConnectRetryTime(); ++i) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                channelToServer = this.channels.get(serverAddress);
                if (channelToServer == null) break;
                if (!channelToServer.isActive()) continue;
                return channelToServer;
            }
            if (i == TxcConfigHolder.getInstance().getMaxConnectRetryTime()) {
                logger.warn("channel " + channelToServer + " is not active after long wait, close it.");
                this.releaseChannel(channelToServer, serverAddress);
            }
        }
        if ((connectLock = this.channelLocks.get(serverAddress)) == null) {
            this.channelLocks.putIfAbsent(serverAddress, new Object());
            connectLock = this.channelLocks.get(serverAddress);
        }
        Object object = connectLock;
        synchronized (object) {
            channelToServer = this._connect(serverAddress);
            this.channels.put(serverAddress, channelToServer);
            return channelToServer;
        }
    }

    protected Channel _connect(String serverAddress) {
        InetSocketAddress address;
        Channel channelToServer = this.channels.get(serverAddress);
        if (channelToServer != null && channelToServer.isActive()) {
            return channelToServer;
        }
        String vipAddress = this.findVip(serverAddress);
        if (vipAddress != null) {
            address = NetUtil.toInetSocketAddress(vipAddress);
            logger.info(String.format("vip: %s ==> %s", serverAddress, vipAddress));
        } else {
            address = NetUtil.toInetSocketAddress(serverAddress);
        }
        logger.info("connect to " + serverAddress + " via VIP " + vipAddress);
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)this.eventloopGroup)).channel(NioSocketChannel.class)).remoteAddress((SocketAddress)address).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)10000)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.SO_REUSEADDR, (Object)false)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(15, 3, 0), new TxcMessageCodec(), RpcClient.this});
            }
        });
        long start = System.currentTimeMillis();
        Object response = null;
        Channel tmpChannel = null;
        ChannelFuture f = b.connect();
        try {
            f.await(10L, TimeUnit.SECONDS);
            if (f.isCancelled()) {
                throw new TxcException("connect cancelled, can not connect to txc server.");
            }
            if (!f.isSuccess()) {
                throw new TxcException(f.cause(), "connect failed, can not connect to txc server. " + address);
            }
            tmpChannel = f.channel();
        }
        catch (Exception e) {
            throw new TxcException(e, "can not connect to txc server. " + address);
        }
        try {
            String fullClientAppName = this.clientAppName;
            fullClientAppName = String.format("%s@%s", fullClientAppName, NetUtil.getLocalIp());
            RegisterClientAppNameMessage registerClientAppNameMessage = new RegisterClientAppNameMessage(this.clientAppName, TxcString.txcInstsToStr(this.txcInsts), this.getGroup(), this.clientType);
            String digest = registerClientAppNameMessage.digest(this.accessKey, this.secretKey);
            logger.info(String.format("client calc digest with accessKey %s", this.accessKey));
            response = super.invoke(null, tmpChannel, registerClientAppNameMessage, 3000L);
            if (response != null && response instanceof RegisterClientAppNameResultMessage) {
                if (!((RegisterClientAppNameResultMessage)response).isResult()) {
                    logger.info("register client app failed. server version:" + ((RegisterClientAppNameResultMessage)response).getVersion());
                    throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "register client app failed.");
                }
            } else {
                if (tmpChannel != null) {
                    tmpChannel.close();
                }
                throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not register app name.");
            }
            channelToServer = tmpChannel;
            httpSecurity = new HttpSecurity(this.accessKey, fullClientAppName, digest, this.getGroup());
        }
        catch (Exception e) {
            logger.error(TxcErrCode.NetRegAppname.errCode, "register client app failed.", (Throwable)e);
            if (tmpChannel != null) {
                tmpChannel.close();
            }
            throw new TxcException(ResultCode.SYSTEMERROR.getValue(), "can not register app.");
        }
        logger.info("register client app sucesss. server cost " + (System.currentTimeMillis() - start) + " ms, version:" + ((RegisterClientAppNameResultMessage)response).getVersion() + ",channel:" + channelToServer);
        return channelToServer;
    }

    public ClientMessageListener getClientMessageListener() {
        return this.clientMessageListener;
    }

    public void setClientMessageListener(ClientMessageListener clientMessageListener) {
        this.clientMessageListener = clientMessageListener;
    }

    public String getClientAppName() {
        return this.clientAppName;
    }

    public void setClientAppName(String clientAppName) {
        this.clientAppName = clientAppName;
    }

    @Override
    public void sendResponse(long msgId, String serverAddress, Object msg) {
        super.sendResponse(msgId, this.connect(serverAddress), msg);
    }

    public void setTxcInsts(Set<String> txcInsts) {
        this.txcInsts = txcInsts;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public int getClientType() {
        return this.clientType;
    }

    public void setClientType(int clientType) {
        this.clientType = clientType;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error(TxcErrCode.ExceptionCaught.errCode, NetUtil.toStringAddress(ctx.channel().remoteAddress()) + "connect exception. " + cause.getMessage(), cause);
        Iterator<Map.Entry<String, Channel>> it = this.channels.entrySet().iterator();
        while (it.hasNext()) {
            if (it.next().getValue().compareTo((Object)ctx.channel()) != 0) continue;
            it.remove();
            logger.info("remove channel:" + ctx.channel());
        }
        super.exceptionCaught(ctx, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDockerId() {
        String result = null;
        String command = "cat /proc/self/cgroup | grep \"cpu:/\" | awk   -F ':' '{print $3}' | sed -e 's#/##g'";
        CommandStreamReader commandStreamReader = new CommandStreamReader();
        try {
            commandStreamReader.execute(command, CommandStreamReader.StreamType.ERROR_STREAM);
            String s = commandStreamReader.readContent(CommandStreamReader.StreamType.INPUT_STREAM, 2000L);
            if (TStringUtil.isHexString(s) || s.charAt(0) == '/' && TStringUtil.isHexString(s.substring(1))) {
                result = s;
            }
        }
        catch (Throwable e) {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("getDockerId execute failed:%s", e));
            }
        }
        finally {
            commandStreamReader.destroy();
        }
        return result;
    }

    static {
        rand = new Random(System.currentTimeMillis());
        switchGroupTimes = 0;
        isChannelOk = false;
        weightRule = null;
        weightList = Collections.synchronizedList(new ArrayList());
        randomVauleToIndexMap = new HashMap<Integer, Integer>();
        httpSecurity = null;
    }

    public static class TxcWeight
    implements Comparable<TxcWeight> {
        int value;
        int logicValue;
        String addr;

        public TxcWeight(int value, int logicValue, String addr) {
            this.value = value;
            this.logicValue = logicValue;
            this.addr = addr;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }

        public int getLogicValue() {
            return this.logicValue;
        }

        public void setLogicValue(int logicValue) {
            this.logicValue = logicValue;
        }

        public String getAddr() {
            return this.addr;
        }

        public void setAddr(String addr) {
            this.addr = addr;
        }

        @Override
        public int compareTo(TxcWeight o) {
            return this.logicValue - o.logicValue;
        }
    }

    public static final class ChannelPackage {
        public final Channel channel;
        public final String address;

        public ChannelPackage(Channel channel, String address) {
            this.channel = channel;
            this.address = address;
        }
    }
}

