/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rpc.impl;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.TxcConstants;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.ClusterDumpMessage;
import com.taobao.txc.common.message.MergeMessage;
import com.taobao.txc.common.message.RedressMessage;
import com.taobao.txc.rpc.impl.HeartbeatMessage;
import com.taobao.txc.rpc.impl.MessageFuture;
import com.taobao.txc.rpc.impl.RpcClient;
import com.taobao.txc.rpc.impl.RpcMessage;
import com.taobao.txc.rpc.util.AddressManager;
import com.taobao.txc.rpc.util.AddressManagerDiamondImpl;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class RpcEndpoint
extends ChannelDuplexHandler {
    private static final LoggerWrap logger = LoggerInit.logger;
    private String group = "DEFAULT";
    private final Object lock = new Object();
    private final int timeoutCheckInternal = 5000;
    protected volatile long nowMills = 0L;
    protected final ThreadPoolExecutor messageExecutor;
    protected AddressManagerDiamondImpl addressManager = new AddressManagerDiamondImpl();
    protected boolean isSending = false;
    protected final ScheduledExecutorService timerExecutor = Executors.newScheduledThreadPool(1);
    protected final ConcurrentHashMap<Long, MessageFuture> futures = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, BlockingQueue<RpcMessage>> basketMap = new ConcurrentHashMap();
    protected final ConcurrentHashMap<String, BlockingQueue<RpcMessage>> rmBasketMap = new ConcurrentHashMap();
    protected final Object mergeLock = new Object();
    protected final Map<Long, MergeMessage> mergeMsgMap = new ConcurrentHashMap<Long, MergeMessage>();
    private static final int CHANNEL_NOT_WRITE_RETRY = 1000;
    boolean allow_dump_stack = false;
    protected boolean skipVip = false;
    protected AtomicBoolean tryDirectConnect = new AtomicBoolean(false);
    protected static final int TRY_DIRECT_CONNECT_SWITCH_COUNT = 2;
    protected int tryDirectConnectSwitchCount = 2;

    public RpcEndpoint(ThreadPoolExecutor messageExecutor) {
        this.messageExecutor = messageExecutor;
    }

    public void init() {
        this.timerExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ArrayList<MessageFuture> timeoutMessageFutures = new ArrayList<MessageFuture>(RpcEndpoint.this.futures.size());
                for (MessageFuture future : RpcEndpoint.this.futures.values()) {
                    if (!future.isTimeout()) continue;
                    timeoutMessageFutures.add(future);
                }
                for (MessageFuture messageFuture : timeoutMessageFutures) {
                    RpcEndpoint.this.futures.remove(messageFuture.getRequestMessage().getId());
                    messageFuture.setResultMessage(null);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("timeout clear future : " + messageFuture);
                }
                RpcEndpoint.this.nowMills = System.currentTimeMillis();
            }
        }, 5000L, 5000L, TimeUnit.MILLISECONDS);
    }

    public void destroy() {
        this.timerExecutor.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (ctx.channel().isWritable()) {
                logger.info("channel change to writable:" + ctx.channel().toString());
                this.lock.notify();
            }
        }
        ctx.fireChannelWritabilityChanged();
    }

    public Object invoke(String address, Channel channel, Object msg, long timeout) throws IOException, TimeoutException {
        return this.invoke(address, channel, msg, timeout, timeout >= 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(String address, Channel channel, Object msg, long timeout, boolean waitResponse) throws IOException, TimeoutException {
        if (channel == null) {
            logger.warn("invoke nothing, caused by null channel.");
            return null;
        }
        final RpcMessage rpcMessage = new RpcMessage();
        rpcMessage.setId(RpcMessage.getNextMessageId());
        rpcMessage.setAsync(false);
        rpcMessage.setHeartbeat(false);
        rpcMessage.setRequest(true);
        rpcMessage.setBody(msg);
        MessageFuture messageFuture = new MessageFuture();
        messageFuture.setRequestMessage(rpcMessage);
        messageFuture.setTimeout(waitResponse ? timeout : 30000L);
        this.futures.put(rpcMessage.getId(), messageFuture);
        if (address != null && !(msg instanceof ClusterDumpMessage) && !(msg instanceof RedressMessage)) {
            ConcurrentHashMap<String, BlockingQueue<RpcMessage>> map = null;
            map = this instanceof RpcClient ? this.basketMap : this.rmBasketMap;
            BlockingQueue<RpcMessage> basket = map.get(address);
            if (basket == null) {
                map.putIfAbsent(address, new LinkedBlockingQueue());
                basket = map.get(address);
            }
            basket.offer(rpcMessage);
            if (logger.isDebugEnabled()) {
                logger.debug("offer message: " + rpcMessage.getBody());
            }
            if (!this.isSending) {
                Object object = this.mergeLock;
                synchronized (object) {
                    this.mergeLock.notify();
                }
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("%s wanted to send msgid:%s body:%s future:%s", new Object[]{this, rpcMessage.getId(), rpcMessage.getBody(), messageFuture}));
            }
            this.channelNotWritableRetry(channel, msg);
            ChannelFuture future = channel.writeAndFlush((Object)rpcMessage);
            future.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        MessageFuture messageFuture = RpcEndpoint.this.futures.remove(rpcMessage.getId());
                        if (messageFuture != null) {
                            messageFuture.setResultMessage(future.cause());
                        }
                        future.channel().close();
                    }
                }
            });
        }
        if (waitResponse) {
            try {
                return messageFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("messageFuture : " + messageFuture);
                }
                throw new RuntimeException(e + ",ip:" + address);
            }
        }
        return null;
    }

    protected void sendRequest(Channel channel, Object msg) {
        RpcMessage rpcMessage = new RpcMessage();
        rpcMessage.setAsync(true);
        rpcMessage.setHeartbeat(msg instanceof HeartbeatMessage);
        rpcMessage.setRequest(true);
        rpcMessage.setBody(msg);
        rpcMessage.setId(RpcMessage.getNextMessageId());
        if (msg instanceof MergeMessage) {
            this.mergeMsgMap.put(rpcMessage.getId(), (MergeMessage)msg);
        }
        this.channelNotWritableRetry(channel, msg);
        if (logger.isDebugEnabled()) {
            logger.debug("write message:" + rpcMessage.getBody() + ", channel:" + channel + ",active?" + channel.isActive() + ",writable?" + channel.isWritable() + ",isopen?" + channel.isOpen());
        }
        channel.writeAndFlush((Object)rpcMessage);
    }

    protected void sendResponse(long msgId, Channel channel, Object msg) {
        RpcMessage rpcMessage = new RpcMessage();
        rpcMessage.setAsync(true);
        rpcMessage.setHeartbeat(msg instanceof HeartbeatMessage);
        rpcMessage.setRequest(false);
        rpcMessage.setBody(msg);
        rpcMessage.setId(msgId);
        this.channelNotWritableRetry(channel, msg);
        if (logger.isDebugEnabled()) {
            logger.debug("send response:" + rpcMessage.getBody() + ",channel:" + channel);
        }
        channel.writeAndFlush((Object)rpcMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void channelNotWritableRetry(Channel channel, Object msg) {
        Object object = this.lock;
        synchronized (object) {
            int tryTimes = 0;
            while (!channel.isWritable()) {
                try {
                    if (tryTimes == 0) {
                        logger.info("channel is not writable,channel:" + channel.toString());
                    }
                    if (++tryTimes > 1000) {
                        try {
                            logger.info("channel will be close, cause: channel retry not writable,channel:" + channel.toString());
                            channel.disconnect();
                            channel.close();
                            TxcConstants.removeChannelVersion(channel);
                        }
                        catch (Throwable throwable) {
                            logger.error("", "channel close error", throwable);
                        }
                        throw new TxcException(channel.toString() + " " + "channel is not writable" + ", msg:" + (msg == null ? "null" : msg.toString()));
                    }
                    this.lock.wait(10L);
                }
                catch (InterruptedException e) {
                    logger.error(TxcErrCode.ChannelNotWritable, e);
                }
            }
        }
    }

    public void channelRead(final ChannelHandlerContext ctx, Object msg) throws Exception {
        block13: {
            if (msg instanceof RpcMessage) {
                final RpcMessage rpcMessage = (RpcMessage)msg;
                if (rpcMessage.isRequest()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("%s msgId:%s, body:%s", new Object[]{this, rpcMessage.getId(), rpcMessage.getBody()}));
                    }
                    try {
                        this.messageExecutor.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RpcEndpoint.this.dispatch(rpcMessage.getId(), ctx, rpcMessage.getBody());
                                }
                                catch (Throwable th) {
                                    logger.error(TxcErrCode.NetDispatch.errCode, th.getMessage(), th);
                                }
                            }
                        });
                    }
                    catch (RejectedExecutionException e) {
                        logger.error(TxcErrCode.ThreadPoolFull.errCode, "thread pool is full, current max pool size is " + this.messageExecutor.getActiveCount());
                        if (!this.allow_dump_stack) break block13;
                        String name = ManagementFactory.getRuntimeMXBean().getName();
                        String pid = name.split("@")[0];
                        int idx = new Random().nextInt(100);
                        try {
                            Runtime.getRuntime().exec("jstack " + pid + " >d:/" + idx + ".log");
                        }
                        catch (IOException ee) {
                            ee.printStackTrace();
                        }
                        this.allow_dump_stack = false;
                    }
                } else {
                    MessageFuture messageFuture = this.futures.remove(rpcMessage.getId());
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("%s msgId:%s, future :%s, body:%s", new Object[]{this, rpcMessage.getId(), messageFuture, rpcMessage.getBody()}));
                    }
                    if (messageFuture != null) {
                        messageFuture.setResultMessage(rpcMessage.getBody());
                    } else {
                        try {
                            this.messageExecutor.execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        RpcEndpoint.this.dispatch(rpcMessage.getId(), ctx, rpcMessage.getBody());
                                    }
                                    catch (Throwable th) {
                                        logger.error(TxcErrCode.NetDispatch.errCode, th.getMessage(), th);
                                    }
                                }
                            });
                        }
                        catch (RejectedExecutionException e) {
                            logger.error(TxcErrCode.ThreadPoolFull.errCode, "thread pool is full, current max pool size is " + this.messageExecutor.getActiveCount());
                        }
                    }
                }
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        logger.error(TxcErrCode.ExceptionCaught.errCode, ctx.channel() + " connect exception. " + cause.getMessage(), cause);
        try {
            ctx.disconnect();
            ctx.close();
            TxcConstants.removeChannelVersion(ctx.channel());
        }
        catch (Exception e) {
            logger.error("", "close channel" + ctx.channel() + " fail.", (Throwable)e);
        }
    }

    public abstract void dispatch(long var1, ChannelHandlerContext var3, Object var4);

    public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
        logger.info(ctx + " close");
        super.close(ctx, future);
    }

    public AddressManager getAddressManager() {
        return this.addressManager;
    }

    public void setAddressManager(AddressManagerDiamondImpl addressManager) {
        this.addressManager = addressManager;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    protected void howAboutTryingDirectConnect(String vip) {
        if (vip == null) {
            if (this.tryDirectConnect.compareAndSet(true, false)) {
                logger.info("try-direct-connect-switch is turned off");
            }
        } else {
            --this.tryDirectConnectSwitchCount;
            if (this.tryDirectConnectSwitchCount > 0 && this.tryDirectConnect.compareAndSet(false, true)) {
                logger.info("try-direct-connect-switch is turned on [" + (2 - this.tryDirectConnectSwitchCount) + "/" + 2 + "]");
            }
        }
    }

    protected String findVip(String serverAddress) {
        if (this.tryDirectConnect.get()) {
            return null;
        }
        String vipAddress = null;
        if (!this.skipVip || !TxcConfigHolder.getInstance().isVipCanBeSkipped()) {
            vipAddress = TxcConfigHolder.getInstance().lookupVIP(serverAddress);
        }
        return vipAddress;
    }
}

