/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rpc.impl;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.NetUtil;
import com.taobao.txc.common.TxcConstants;
import com.taobao.txc.common.TxcXID;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.rpc.api.ConnectionEvent;
import com.taobao.txc.rpc.api.ConnectionEventListener;
import com.taobao.txc.rpc.api.ServerMessageListener;
import com.taobao.txc.rpc.api.TxcServerMessageSender;
import com.taobao.txc.rpc.impl.HeartbeatMessage;
import com.taobao.txc.rpc.impl.RegisterClientAppNameMessage;
import com.taobao.txc.rpc.impl.RegisterClientAppNameResultMessage;
import com.taobao.txc.rpc.impl.RpcEndpoint;
import com.taobao.txc.rpc.impl.RpcMessage;
import com.taobao.txc.rpc.impl.TxcMessageCodec;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.IOException;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang.StringUtils;

@ChannelHandler.Sharable
public abstract class RpcServer
extends RpcEndpoint
implements TxcServerMessageSender {
    private static final LoggerWrap logger = LoggerInit.logger;
    protected int port;
    protected ServerMessageListener serverMessageListener;
    protected ConnectionEventListener connectionEventListener;
    protected ConcurrentHashMap<String, String> rmIpAndPortToClientAppName = new ConcurrentHashMap();
    public static int mid;
    private NioEventLoopGroup bossGroup = new NioEventLoopGroup();
    private NioEventLoopGroup workerGroup = new NioEventLoopGroup();
    protected ConcurrentHashMap<String, String> ipAndPortToClientAppName = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Channel> ipAndClientAppNameToChannelMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> ipAndPortToDbKey = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Map<String, Map<Integer, Channel>>> dbKeyToChannelMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Map<String, Map<Integer, Channel>>> dbKeyToRtChannelMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> ipAndPortToVgroupName = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Long> ipInactiveRecords = new ConcurrentHashMap();
    protected volatile long lastInactiveMills = 0L;
    private int backlog = 0;
    public static final int LOOP_CAPACITY = 3;
    public static final int BKUP_MID_DIFF = 100;
    private Object channelLock1 = new Object();
    private Object channelLock2 = new Object();

    public RpcServer(ThreadPoolExecutor messageExecutor) {
        super(messageExecutor);
    }

    public ServerMessageListener getServerMessageListener() {
        return this.serverMessageListener;
    }

    public void setServerMessageListener(ServerMessageListener serverMessageListener) {
        this.serverMessageListener = serverMessageListener;
    }

    public ConnectionEventListener getConnectionEventListener() {
        return this.connectionEventListener;
    }

    public void setConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionEventListener = connectionEventListener;
    }

    public void setBacklog(int backlog) {
        if (backlog > 0) {
            this.backlog = backlog;
        }
    }

    public static int getPeerBkupMid() {
        int i = mid - 1;
        if (i == 0) {
            i = 3;
        }
        return i + 100;
    }

    public static int getPeerMid() {
        int i = mid - 1;
        if (i == 0) {
            i = 3;
        }
        return i;
    }

    public static int getBkupMid() {
        return mid + 100;
    }

    @Override
    public void init() {
        super.init();
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new IdleStateHandler(15, 0, 0)}).addLast(new ChannelHandler[]{new TxcMessageCodec(), RpcServer.this});
            }
        });
        if (this.backlog > 0) {
            logger.info("set server backlog: {}", this.backlog);
            bootstrap.option(ChannelOption.SO_BACKLOG, (Object)this.backlog);
        }
        TxcXID.setIpAddress(NetUtil.getLocalIp());
        TxcXID.setPort(this.port);
        String serverAddress = NetUtil.getLocalIp() + ":" + this.port;
        try {
            String dataId = String.format("com.taobao.txc.server.group.%s.listenall", this.getGroup());
            String listenAll = TxcConfigHolder.getInstance().getConfig(dataId, "TXC_GROUP");
            if (!StringUtils.isEmpty((String)listenAll) && (listenAll.equals("1") || listenAll.equalsIgnoreCase("true"))) {
                serverAddress = "0.0.0.0:" + this.port;
            }
        }
        catch (Exception e) {
            logger.warn(String.format("listen on internal network only!", new Object[0]));
        }
        try {
            bootstrap.bind((SocketAddress)NetUtil.toInetSocketAddress(serverAddress)).sync();
            logger.info("txc server begin to listen address:" + serverAddress);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("txc server can not bind to local address:" + serverAddress);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent idleStateEvent;
        if (evt instanceof IdleStateEvent && (idleStateEvent = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            logger.info("channel" + ctx.channel() + " read idle.");
            this.handleDisconnect(ctx, false);
            try {
                ctx.disconnect();
                ctx.close();
                TxcConstants.removeChannelVersion(ctx.channel());
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
    }

    @Override
    public void destroy() {
        this.addressManager.unpublish(this.getGroup(), NetUtil.getLocalIp() + ":" + this.port);
        super.destroy();
        logger.info("destoy rpcserver");
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public Channel getChannel(Map<String, Map<Integer, Channel>> chMap, String clientIp, String clientAppName) {
        return this.getChannel(chMap, clientIp, clientAppName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel(Map<String, Map<Integer, Channel>> chMap, String clientIp, String clientAppName, TargetHolder holder) {
        Channel channel = null;
        Integer key = 0;
        String targetIp = "";
        if (chMap != null) {
            if (chMap.get(clientIp) != null && chMap.get(clientIp).size() > 0) {
                if (chMap.get(clientIp).size() > 1 && clientAppName != null) {
                    for (Integer port : chMap.get(clientIp).keySet()) {
                        if (this.rmIpAndPortToClientAppName.get(clientIp + ":" + port).compareTo(clientAppName) != 0) continue;
                        channel = chMap.get(clientIp).get(port);
                        key = port;
                        targetIp = clientIp;
                        if (holder != null) {
                            holder.targetIp = targetIp;
                            holder.targetKey = key;
                        }
                        break;
                    }
                } else {
                    key = chMap.get(clientIp).keySet().iterator().next();
                    channel = chMap.get(clientIp).get(key);
                    targetIp = clientIp;
                    if (holder != null) {
                        holder.targetIp = targetIp;
                        holder.targetKey = key;
                    }
                }
            }
            if (channel == null && chMap.size() > 0) {
                for (String ip : chMap.keySet()) {
                    Map<Integer, Channel> m = chMap.get(ip);
                    if (m.size() > 1 && clientAppName != null) {
                        for (Integer port : m.keySet()) {
                            if (this.rmIpAndPortToClientAppName.get(ip + ":" + port).compareTo(clientAppName) != 0 && channel != null) continue;
                            channel = m.get(port);
                            targetIp = ip;
                            key = port;
                            if (holder != null) {
                                holder.targetIp = targetIp;
                                holder.targetKey = key;
                            }
                            break;
                        }
                    } else if (m.size() == 1) {
                        key = m.keySet().iterator().next();
                        channel = m.get(key);
                        targetIp = ip;
                        if (holder != null) {
                            holder.targetIp = targetIp;
                            holder.targetKey = key;
                        }
                    }
                    if (channel == null) continue;
                    break;
                }
            }
            if (channel != null) {
                Map<Integer, Channel> map1;
                if (channel.isActive()) {
                    if (clientIp != null && !clientIp.equals(targetIp)) {
                        logger.info("target ip is:" + targetIp);
                    }
                    return channel;
                }
                for (int i = 0; i < 1000; ++i) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ip) {
                        // empty catch block
                    }
                    if (!channel.isActive()) continue;
                    return channel;
                }
                Object i = this.channelLock1;
                synchronized (i) {
                    Map<Integer, Channel> tmpMap = null;
                    if (targetIp != null && key != null && (tmpMap = chMap.get(targetIp)) != null && tmpMap.get(key) == null) {
                        return null;
                    }
                    try {
                        logger.warn("channel " + channel + " is not active after long wait, close it.");
                        channel.disconnect();
                        channel.close();
                        TxcConstants.removeChannelVersion(channel);
                    }
                    catch (Exception e) {
                        logger.error("", "failed to close channle", (Throwable)e);
                    }
                    finally {
                        channel = null;
                    }
                }
                if (targetIp != null && key != null && (map1 = chMap.get(targetIp)) != null) {
                    map1.remove(key);
                    if (map1.size() == 0) {
                        Map<String, Map<Integer, Channel>> map = chMap;
                        synchronized (map) {
                            map1 = chMap.get(targetIp);
                            if (map1 != null && map1.size() == 0) {
                                chMap.remove(targetIp);
                            }
                        }
                    }
                }
            }
        }
        return channel;
    }

    private Channel getRMResponseChannel(String dbKey, String clientIp, String clientAppName, TargetHolder holder) {
        Map<String, Map<Integer, Channel>> chMap = this.dbKeyToChannelMap.get(dbKey);
        if (chMap == null || chMap.isEmpty()) {
            logger.info("No channel for RM dbKey: " + dbKey);
            return null;
        }
        Map<Integer, Channel> channelMapOfClient = chMap.get(clientIp);
        if (channelMapOfClient == null || channelMapOfClient.isEmpty()) {
            logger.info("No channel for RM client: " + clientIp + ", dbKey: " + dbKey);
            return null;
        }
        Channel channel = null;
        for (Map.Entry<Integer, Channel> channelEntry : channelMapOfClient.entrySet()) {
            Integer tmpPort = channelEntry.getKey();
            Channel tmpChannel = channelEntry.getValue();
            if (clientAppName == null) {
                channel = tmpChannel;
            } else {
                String channelAppName = this.rmIpAndPortToClientAppName.get(clientIp + ":" + tmpPort);
                if (clientAppName.equals(channelAppName)) {
                    channel = tmpChannel;
                }
            }
            if (channel == null) continue;
            if (channel.isActive()) break;
            logger.info("skip inactive RM channel " + channel);
            channel = null;
        }
        return channel;
    }

    @Override
    public void sendRtRequest(String dbKey, String clientIp, String clientAppName, Object msg) {
        Channel clientChannel = null;
        if (dbKey != null) {
            Map<String, Map<Integer, Channel>> chMap = this.dbKeyToRtChannelMap.get(dbKey);
            clientChannel = this.getChannel(chMap, clientIp, clientAppName);
        }
        if (clientChannel == null) {
            throw new RuntimeException("client is not connected, client ip:" + clientIp + ",client app name:" + clientAppName);
        }
        super.sendRequest(clientChannel, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Channel getChannel(String clientIp, String clientAppName) {
        Channel clientChannel = this.ipAndClientAppNameToChannelMap.get(clientIp + clientAppName);
        if (clientChannel == null) {
            return null;
        }
        if (clientChannel.isActive()) {
            return clientChannel;
        }
        for (int i = 0; i < 100; ++i) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!clientChannel.isActive()) continue;
            return clientChannel;
        }
        Object object = this.channelLock2;
        synchronized (object) {
            clientChannel = this.ipAndClientAppNameToChannelMap.remove(clientIp + clientAppName);
            if (clientChannel == null) {
                return null;
            }
            if (clientChannel.isActive()) {
                this.ipAndClientAppNameToChannelMap.putIfAbsent(clientIp + clientAppName, clientChannel);
                return clientChannel;
            }
            try {
                logger.warn("channel " + clientChannel + " is not active after long wait, close it.");
                clientChannel.disconnect();
                clientChannel.close();
                TxcConstants.removeChannelVersion(clientChannel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendRequest(String dbKey, String clientIp, String clientAppName, Object msg) {
        Channel clientChannel = null;
        Map<String, Map<Integer, Channel>> chMap = null;
        TargetHolder holder = new TargetHolder();
        if (dbKey != null) {
            chMap = this.dbKeyToChannelMap.get(dbKey);
            clientChannel = this.getChannel(chMap, clientIp, clientAppName, holder);
        } else if (clientIp != null) {
            clientChannel = this.getChannel(clientIp, clientAppName);
        } else {
            throw new RuntimeException("client is not connected, client ip:" + clientIp + ",client app name:" + clientAppName);
        }
        if (clientChannel == null) {
            throw new TxcException("rm client is not connected. dbkey:" + dbKey + ",clientIp:" + clientIp + ",chMap:" + chMap);
        }
        try {
            super.sendRequest(clientChannel, msg);
        }
        catch (TxcException e) {
            Map<Integer, Channel> map1;
            if (e.getMessage() != null && e.getMessage().contains("channel is not writable") && dbKey != null && holder.targetIp != null && holder.targetKey != null && (map1 = chMap.get(holder.targetIp)) != null) {
                map1.remove(holder.targetKey);
                if (map1.size() == 0) {
                    Map<String, Map<Integer, Channel>> map = chMap;
                    synchronized (map) {
                        map1 = chMap.get(holder.targetIp);
                        if (map1 != null && map1.size() == 0) {
                            chMap.remove(holder.targetIp);
                        }
                    }
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendResponse(long msgId, String dbKey, String clientIp, String clientAppName, Object msg) {
        Channel clientChannel = null;
        if (dbKey != null) {
            TargetHolder holder = new TargetHolder();
            clientChannel = this.getRMResponseChannel(dbKey, clientIp, clientAppName, holder);
            if (clientChannel == null) {
                logger.info("Failed to send response through " + clientChannel);
                logger.info("SNAPSHOT - msgId:" + msgId + ", dbKey:" + dbKey + ", clientIp:" + clientIp + ", clientAppName:" + clientAppName + ", msg:" + msg + ", rpcserver:" + this + ", dbKeyToChannelMap:" + this.dbKeyToChannelMap + ", rmIpAndPortToClientAppName:" + this.rmIpAndPortToClientAppName);
                throw new RuntimeException("RM is not connected.");
            }
            try {
                super.sendResponse(msgId, clientChannel, msg);
            }
            catch (TxcException e) {
                Map<Integer, Channel> map1;
                Map<String, Map<Integer, Channel>> chMap;
                logger.info("Failed to send response through " + clientChannel);
                logger.info("SNAPSHOT - msgId:" + msgId + ", dbKey:" + dbKey + ", clientIp:" + clientIp + ", clientAppName:" + clientAppName + ", msg:" + msg + ", rpcserver:" + this + ", dbKeyToChannelMap:" + this.dbKeyToChannelMap + ", rmIpAndPortToClientAppName:" + this.rmIpAndPortToClientAppName);
                if (e.getMessage() != null && e.getMessage().contains("channel is not writable") && (chMap = this.dbKeyToChannelMap.get(dbKey)) != null && holder.targetIp != null && holder.targetKey != null && (map1 = chMap.get(holder.targetIp)) != null) {
                    map1.remove(holder.targetKey);
                    if (map1.size() == 0) {
                        Map<String, Map<Integer, Channel>> map = chMap;
                        synchronized (map) {
                            map1 = chMap.get(holder.targetIp);
                            if (map1 != null && map1.size() == 0) {
                                chMap.remove(holder.targetIp);
                            }
                        }
                    }
                }
                throw new RuntimeException("RM is not connected.", e);
            }
        }
        if (clientAppName != null && clientIp != null) {
            clientChannel = this.getChannel(clientIp, clientAppName);
            if (clientChannel != null) {
                try {
                    super.sendResponse(msgId, clientChannel, msg);
                }
                catch (TxcException e) {
                    Channel ch;
                    if (e.getMessage() != null && e.getMessage().contains("channel is not writable") && (ch = this.ipAndClientAppNameToChannelMap.remove(clientIp + clientAppName)) != null && clientChannel.compareTo((Object)ch) != 0) {
                        this.ipAndClientAppNameToChannelMap.putIfAbsent(clientIp + clientAppName, ch);
                    }
                    throw e;
                }
            } else {
                logger.info("Unable to send response back to TM since already disconnected [" + clientAppName + "] [" + clientIp + "]");
            }
        } else {
            throw new RuntimeException("dbKey is null, clientAppName is" + clientAppName + ",clientIp is" + clientIp);
        }
    }

    @Override
    public void sendResponse(long msgId, Channel channel, Object msg) {
        if (channel == null || !channel.isActive()) {
            throw new RuntimeException("channel is not active. channel:" + channel);
        }
        super.sendResponse(msgId, channel, msg);
    }

    @Override
    public Object invoke(String dbKey, String clientIp, String clientAppName, Object msg, long timeout) throws IOException, TimeoutException {
        Channel clientChannel = null;
        Map<String, Map<Integer, Channel>> chMap = null;
        if (dbKey != null) {
            chMap = this.dbKeyToChannelMap.get(dbKey);
            clientChannel = this.getChannel(chMap, clientIp, clientAppName);
        } else if (clientAppName != null) {
            clientChannel = this.getChannel(clientIp, clientAppName);
        }
        if (clientChannel != null) {
            return super.invoke(null, clientChannel, msg, timeout);
        }
        throw new RuntimeException("client is not connected. dbkey:" + dbKey + ",clientIp:" + clientIp + ",chMap:" + chMap);
    }

    @Override
    public Object invoke(String dbKey, String clientIp, String clientAppName, Object msg) throws IOException, TimeoutException {
        return this.invoke(dbKey, clientIp, clientAppName, msg, 30000L);
    }

    @Override
    public void dispatch(long msgId, ChannelHandlerContext ctx, Object msg) {
        if (TxcConstants.isHandledChannel(ctx.channel())) {
            String ipAndPort = NetUtil.toStringAddress(ctx.channel().remoteAddress());
            String clientAppName = this.ipAndPortToClientAppName.get(ipAndPort);
            String vgroupName = this.ipAndPortToVgroupName.get(ipAndPort);
            String dbKeys = this.ipAndPortToDbKey.get(ipAndPort);
            if (clientAppName != null || dbKeys != null) {
                this.serverMessageListener.onMessage(msgId, dbKeys, ipAndPort.substring(0, ipAndPort.indexOf(58)), clientAppName, vgroupName, msg);
            } else {
                this.serverMessageListener.onMessage(msgId, ctx.channel(), msg);
            }
        } else {
            try {
                logger.warn("unknown connection. " + ctx.channel());
                ctx.disconnect();
                ctx.close();
                TxcConstants.removeChannelVersion(ctx.channel());
            }
            catch (Exception exception) {
                // empty catch block
            }
            logger.warn(String.format("close a unhandled connection! [%s]", ctx.channel().toString()));
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.messageExecutor.isShutdown()) {
            return;
        }
        String version = TxcConstants.removeChannelVersion(ctx.channel());
        if (version != null) {
            logger.info("channel" + ctx.channel() + " inactive.");
        }
        this.handleDisconnect(ctx, version == null);
        super.channelInactive(ctx);
    }

    private void handleDisconnect(ChannelHandlerContext ctx, boolean detectFlag) {
        String ip;
        final String ipAndPort = NetUtil.toStringAddress(ctx.channel().remoteAddress());
        final String clientAppName = this.ipAndPortToClientAppName.remove(ipAndPort);
        final String dbKeys = this.ipAndPortToDbKey.remove(ipAndPort);
        this.ipAndPortToVgroupName.remove(ipAndPort);
        if ((clientAppName == null || clientAppName.isEmpty()) && (dbKeys == null || dbKeys.isEmpty())) {
            ip = NetUtil.toIpAddress(ctx.channel().remoteAddress());
            Long lastTime = this.ipInactiveRecords.get(ip);
            if (lastTime == null || this.nowMills - lastTime > 60000L) {
                this.ipInactiveRecords.put(ip, this.nowMills);
                if (this.nowMills > this.lastInactiveMills) {
                    this.lastInactiveMills = this.nowMills;
                }
                if (!detectFlag) {
                    logger.info(ipAndPort + " to server channel inactive.");
                }
            }
        } else {
            if (this.nowMills - this.lastInactiveMills > 120000L && !this.ipInactiveRecords.isEmpty()) {
                this.ipInactiveRecords.clear();
            }
            if (!detectFlag) {
                logger.info(ipAndPort + " to server channel inactive.");
            }
        }
        if (clientAppName != null) {
            ip = ipAndPort.substring(0, ipAndPort.indexOf(58));
            try {
                Channel c = this.ipAndClientAppNameToChannelMap.get(ip + clientAppName);
                if (c != null && c.remoteAddress().equals(ctx.channel().remoteAddress())) {
                    c = this.ipAndClientAppNameToChannelMap.remove(ip + clientAppName);
                    if (c != null && !c.remoteAddress().equals(ctx.channel().remoteAddress())) {
                        this.ipAndClientAppNameToChannelMap.putIfAbsent(ip + clientAppName, c);
                    } else {
                        logger.info("remove cient channel:" + c);
                    }
                }
            }
            catch (Exception e) {
                logger.error("", "", (Throwable)e);
            }
            this.messageExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectionEvent event = new ConnectionEvent();
                        event.setClientAppName(clientAppName);
                        event.setClientIp(ip);
                        event.setClientIpAndPort(ipAndPort);
                        event.setConnected(false);
                        RpcServer.this.connectionEventListener.onEvent(event);
                    }
                    catch (Throwable th) {
                        logger.error(TxcErrCode.NetOnMessage.errCode, th.getMessage(), th);
                    }
                }
            });
        } else if (dbKeys != null) {
            String[] dbKeyArray;
            ip = ipAndPort.substring(0, ipAndPort.indexOf(58));
            int port = Integer.parseInt(ipAndPort.substring(ipAndPort.indexOf(58) + 1));
            for (String dbKey : dbKeyArray = dbKeys.split(",")) {
                Map<String, Map<Integer, Channel>> channelMap = this.dbKeyToChannelMap.get(dbKey);
                if (channelMap != null && channelMap.get(ip) != null) {
                    Channel ch = channelMap.get(ip).remove(port);
                    logger.info("remove rm channel:" + ch + " for dbkey:" + dbKey);
                }
                if ((channelMap = this.dbKeyToRtChannelMap.get(dbKey)) == null || channelMap.get(ip) == null) continue;
                channelMap.get(ip).remove(port);
            }
            this.messageExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        ConnectionEvent event = new ConnectionEvent();
                        event.setDbKeys(dbKeys);
                        event.setClientIp(ip);
                        event.setClientIpAndPort(ipAndPort);
                        event.setConnected(false);
                        RpcServer.this.connectionEventListener.onEvent(event);
                    }
                    catch (Throwable th) {
                        logger.error("0105", th.getMessage(), th);
                    }
                }
            });
        } else if (logger.isDebugEnabled()) {
            logger.debug("Unknown connection is disconnected [" + ipAndPort + "]" + ctx.channel());
        }
    }

    protected abstract String checkAuth(Map<String, String> var1, String var2);

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof RpcMessage) {
            RpcMessage rpcMessage = (RpcMessage)msg;
            if (rpcMessage.getBody() instanceof RegisterClientAppNameMessage) {
                String ipAndPort = NetUtil.toStringAddress(ctx.channel().remoteAddress());
                RegisterClientAppNameMessage registerClientAppNameMessage = (RegisterClientAppNameMessage)rpcMessage.getBody();
                TxcConstants.addChannelVersion(ctx.channel(), registerClientAppNameMessage.getVersion());
                this.ipAndPortToClientAppName.put(ipAndPort, registerClientAppNameMessage.getClientAppName());
                String ipAndClientAppName = ipAndPort.substring(0, ipAndPort.indexOf(58)) + registerClientAppNameMessage.getClientAppName();
                this.ipAndClientAppNameToChannelMap.put(ipAndClientAppName, ctx.channel());
                Map<String, String> udata = registerClientAppNameMessage.parseUdata();
                String vgroup = this.checkAuth(udata, ipAndPort);
                if (vgroup != null && !vgroup.isEmpty()) {
                    this.ipAndPortToVgroupName.put(ipAndPort, vgroup);
                    logger.info(String.format("checkAuth for client:%s vgroup:%s ok", ipAndPort, vgroup));
                }
                this.sendResponse(rpcMessage.getId(), ctx.channel(), new RegisterClientAppNameResultMessage(true));
                StringBuilder loginfo = new StringBuilder();
                loginfo.append("app ").append(registerClientAppNameMessage.getClientAppName()).append(" is connected from ").append(ipAndPort).append(", version:").append(registerClientAppNameMessage.getVersion()).append(", vgroup:").append(udata == null ? "null" : udata.get("vgroup")).append(", ak:").append(udata == null ? "null" : udata.get("ak")).append(", digest:").append(udata == null ? "null" : udata.get("digest")).append(", type:").append(udata == null ? "null" : udata.get("type")).append(", ip:").append(udata == null ? "null" : udata.get("ip")).append(", insts:[").append(registerClientAppNameMessage.getTxcInsts()).append(']').append(", timestamp:").append(udata == null ? "null" : udata.get("timestamp"));
                logger.warn(loginfo.toString());
                return;
            }
            if (rpcMessage.getBody() == HeartbeatMessage.PING) {
                try {
                    this.sendResponse(rpcMessage.getId(), ctx.channel(), HeartbeatMessage.PONG);
                }
                catch (Throwable throwable) {
                    logger.error("", "send response error", throwable);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("received PING from " + ctx.channel().remoteAddress());
                }
                return;
            }
        }
        super.channelRead(ctx, msg);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        String ipAndPort = NetUtil.toStringAddress(ctx.channel().remoteAddress());
        if (this.ipAndPortToClientAppName.get(ipAndPort) != null) {
            this.ipAndPortToClientAppName.remove(ipAndPort);
        } else if (this.ipAndPortToDbKey.get(ipAndPort) != null) {
            this.ipAndPortToDbKey.remove(ipAndPort);
        } else if (this.ipAndPortToVgroupName.get(ipAndPort) != null) {
            this.ipAndPortToVgroupName.remove(ipAndPort);
        } else {
            return;
        }
        super.exceptionCaught(ctx, cause);
    }

    private static class TargetHolder {
        String targetIp = null;
        Integer targetKey = null;

        private TargetHolder() {
        }
    }
}

