/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rpc.impl;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.message.BeginMessage;
import com.taobao.txc.common.message.BeginResultMessage;
import com.taobao.txc.common.message.BeginRetryBranchMessage;
import com.taobao.txc.common.message.BeginRetryBranchResultMessage;
import com.taobao.txc.common.message.BranchCommitMessage;
import com.taobao.txc.common.message.BranchCommitResultMessage;
import com.taobao.txc.common.message.BranchRollbackMessage;
import com.taobao.txc.common.message.BranchRollbackResultMessage;
import com.taobao.txc.common.message.ClusterDumpMessage;
import com.taobao.txc.common.message.ClusterDumpResultMessage;
import com.taobao.txc.common.message.GlobalCommitMessage;
import com.taobao.txc.common.message.GlobalCommitResultMessage;
import com.taobao.txc.common.message.GlobalRollbackMessage;
import com.taobao.txc.common.message.GlobalRollbackResultMessage;
import com.taobao.txc.common.message.QueryLockMessage;
import com.taobao.txc.common.message.QueryLockResultMessage;
import com.taobao.txc.common.message.RedressMessage;
import com.taobao.txc.common.message.RedressResultMessage;
import com.taobao.txc.common.message.RegisterMessage;
import com.taobao.txc.common.message.RegisterResultMessage;
import com.taobao.txc.common.message.ReportStatusMessage;
import com.taobao.txc.common.message.ReportStatusResultMessage;
import com.taobao.txc.common.message.ReportUdataMessage;
import com.taobao.txc.common.message.ReportUdataResultMessage;
import com.taobao.txc.common.message.TxcCodec;
import com.taobao.txc.common.message.TxcMergeMessage;
import com.taobao.txc.common.message.TxcMergeResultMessage;
import com.taobao.txc.common.message.TxcMessage;
import com.taobao.txc.rpc.impl.HeartbeatMessage;
import com.taobao.txc.rpc.impl.RegisterClientAppNameMessage;
import com.taobao.txc.rpc.impl.RegisterClientAppNameResultMessage;
import com.taobao.txc.rpc.impl.RegisterRmMessage;
import com.taobao.txc.rpc.impl.RegisterRmResultMessage;
import com.taobao.txc.rpc.impl.RpcMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.nio.ByteBuffer;
import java.util.List;

public class TxcMessageCodec
extends ByteToMessageCodec<RpcMessage> {
    private static short MAGIC = (short)-9510;
    private static int HEAD_LENGHT = 14;
    private static final int FLAG_REQUEST = 128;
    private static final int FLAG_ASYNC = 64;
    private static final int FLAG_HEARTBEAT = 32;
    private static final int FLAG_TXCCODEC = 16;
    private static final LoggerWrap logger = LoggerInit.logger;

    protected void encode(ChannelHandlerContext ctx, RpcMessage msg, ByteBuf out) throws Exception {
        TxcCodec txcCodec = null;
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        if (msg.getBody() instanceof TxcCodec) {
            txcCodec = (TxcCodec)msg.getBody();
        }
        byteBuffer.putShort(MAGIC);
        int flag = (msg.isAsync() ? 64 : 0) | (msg.isHeartbeat() ? 32 : 0) | (msg.isRequest() ? 128 : 0) | (txcCodec != null ? 16 : 0);
        byteBuffer.putShort((short)flag);
        if (msg.getBody() instanceof HeartbeatMessage) {
            byteBuffer.putShort((short)0);
            byteBuffer.putLong(msg.getId());
            byteBuffer.flip();
            byte[] content = new byte[byteBuffer.limit()];
            byteBuffer.get(content);
            out.writeBytes(content);
            return;
        }
        try {
            if (txcCodec != null) {
                txcCodec = (TxcCodec)msg.getBody();
                txcCodec.setChannelHandlerContext(ctx);
                byteBuffer.putShort(txcCodec.getTypeCode());
                byteBuffer.putLong(msg.getId());
                byteBuffer.flip();
                byte[] content = new byte[byteBuffer.limit()];
                byteBuffer.get(content);
                out.writeBytes(content);
                out.writeBytes(txcCodec.encode());
            } else {
                logger.info("msg:" + msg.getBody().toString());
                byte[] body = TxcMessageCodec.hessianSerialize(msg.getBody());
                byteBuffer.putShort((short)body.length);
                byteBuffer.putLong(msg.getId());
                byteBuffer.put(body);
                byteBuffer.flip();
                byte[] content = new byte[byteBuffer.limit()];
                byteBuffer.get(content);
                out.writeBytes(content);
            }
        }
        catch (Exception e) {
            logger.error("encode error", "", (Throwable)e);
            throw e;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Send:" + msg.getBody());
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        int readableBytes;
        if (logger.isDebugEnabled()) {
            logger.debug("channeL:" + ctx.channel());
        }
        if ((readableBytes = in.readableBytes()) < HEAD_LENGHT) {
            return;
        }
        int begin = in.readerIndex();
        byte[] buffer = new byte[HEAD_LENGHT];
        in.readBytes(buffer);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        short magic = byteBuffer.getShort();
        if (magic != MAGIC) {
            ctx.channel().close();
            return;
        }
        short flag = byteBuffer.getShort();
        boolean isHeartbeat = (0x20 & flag) > 0;
        boolean isRequest = (0x80 & flag) > 0;
        boolean isTxcCodec = (0x10 & flag) > 0;
        short bodyLength = 0;
        short typeCode = 0;
        if (!isTxcCodec) {
            bodyLength = byteBuffer.getShort();
        } else {
            typeCode = byteBuffer.getShort();
        }
        long msgId = byteBuffer.getLong();
        if (isHeartbeat) {
            RpcMessage rpcMessage = new RpcMessage();
            rpcMessage.setId(msgId);
            rpcMessage.setAsync(true);
            rpcMessage.setHeartbeat(isHeartbeat);
            rpcMessage.setRequest(isRequest);
            if (isRequest) {
                rpcMessage.setBody(HeartbeatMessage.PING);
            } else {
                rpcMessage.setBody(HeartbeatMessage.PONG);
            }
            out.add(rpcMessage);
            return;
        }
        if (bodyLength > 0 && in.readableBytes() < bodyLength) {
            in.readerIndex(begin);
            return;
        }
        RpcMessage rpcMessage = new RpcMessage();
        rpcMessage.setId(msgId);
        rpcMessage.setAsync((0x40 & flag) > 0);
        rpcMessage.setHeartbeat(false);
        rpcMessage.setRequest(isRequest);
        try {
            if (isTxcCodec) {
                TxcCodec codec = this.getTxcCodecInstance(typeCode);
                codec.setChannelHandlerContext(ctx);
                if (!codec.decode(in)) {
                    in.readerIndex(begin);
                    return;
                }
                rpcMessage.setBody(codec);
            } else {
                byte[] body = new byte[bodyLength];
                in.readBytes(body);
                Object bodyObject = TxcMessageCodec.hessianDeserialize(body);
                rpcMessage.setBody(bodyObject);
            }
        }
        catch (Exception e) {
            logger.error("decode error", "", (Throwable)e);
            throw e;
        }
        out.add(rpcMessage);
        if (logger.isDebugEnabled()) {
            logger.debug("Receive:" + rpcMessage.getBody() + ",messageId:" + msgId);
        }
    }

    public TxcCodec getTxcCodecInstance(short typeCode) {
        TxcMessage codec;
        switch (typeCode) {
            case 1: {
                codec = new BeginMessage();
                break;
            }
            case 2: {
                codec = new BeginResultMessage();
                break;
            }
            case 3: {
                codec = new BranchCommitMessage();
                break;
            }
            case 4: {
                codec = new BranchCommitResultMessage();
                break;
            }
            case 5: {
                codec = new BranchRollbackMessage();
                break;
            }
            case 6: {
                codec = new BranchRollbackResultMessage();
                break;
            }
            case 7: {
                codec = new GlobalCommitMessage();
                break;
            }
            case 8: {
                codec = new GlobalCommitResultMessage();
                break;
            }
            case 9: {
                codec = new GlobalRollbackMessage();
                break;
            }
            case 10: {
                codec = new GlobalRollbackResultMessage();
                break;
            }
            case 11: {
                codec = new RegisterMessage();
                break;
            }
            case 12: {
                codec = new RegisterResultMessage();
                break;
            }
            case 13: {
                codec = new ReportStatusMessage();
                break;
            }
            case 14: {
                codec = new ReportStatusResultMessage();
                break;
            }
            case 15: {
                codec = new BeginRetryBranchMessage();
                break;
            }
            case 16: {
                codec = new BeginRetryBranchResultMessage();
                break;
            }
            case 17: {
                codec = new ReportUdataMessage();
                break;
            }
            case 18: {
                codec = new ReportUdataResultMessage();
                break;
            }
            case 19: {
                codec = new TxcMergeMessage();
                break;
            }
            case 20: {
                codec = new TxcMergeResultMessage();
                break;
            }
            case 21: {
                codec = new QueryLockMessage();
                break;
            }
            case 22: {
                codec = new QueryLockResultMessage();
                break;
            }
            case 101: {
                codec = new RegisterClientAppNameMessage();
                break;
            }
            case 102: {
                codec = new RegisterClientAppNameResultMessage();
                break;
            }
            case 103: {
                codec = new RegisterRmMessage();
                break;
            }
            case 104: {
                codec = new RegisterRmResultMessage();
                break;
            }
            case 113: {
                codec = new ClusterDumpMessage();
                break;
            }
            case 114: {
                codec = new ClusterDumpResultMessage();
                break;
            }
            case 121: {
                codec = new RedressMessage();
                break;
            }
            case 122: {
                codec = new RedressResultMessage();
                break;
            }
            default: {
                String className = TxcMessage.typeMap.get(typeCode);
                throw new TxcException("unknown class:" + className + " in txc message codec.");
            }
        }
        return codec;
    }

    public static byte[] hessianSerialize(Object object) throws Exception {
        if (object == null) {
            throw new NullPointerException();
        }
        throw new TxcException("hessianSerialize error");
    }

    public static Object hessianDeserialize(byte[] bytes) throws Exception {
        if (bytes == null) {
            throw new NullPointerException();
        }
        throw new TxcException("hessianDeserialize error");
    }
}

