/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.rpc.util;

import com.taobao.txc.common.LoggerInit;
import com.taobao.txc.common.LoggerWrap;
import com.taobao.txc.common.config.ITxcManagerListener;
import com.taobao.txc.common.config.TxcConfigHolder;
import com.taobao.txc.common.exception.TxcErrCode;
import com.taobao.txc.common.exception.TxcException;
import com.taobao.txc.common.util.http.HttpSecurity;
import com.taobao.txc.common.util.string.TxcString;
import com.taobao.txc.rpc.impl.RpcClient;
import com.taobao.txc.rpc.util.AddressManager;
import com.taobao.txc.rpc.util.AddressWatcher;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import org.apache.commons.lang.StringUtils;

public class AddressManagerDiamondImpl
implements AddressManager {
    private static final LoggerWrap logger = LoggerInit.logger;
    private final String VGROUP_MAPPING_DATAID = "vgroup_mapping_";
    private final String GROUPLIST_DATAID = "com.taobao.txc.grouplist.";
    private static final String GLOBAL_FORCE_VIP_CHECK_DATAID = "com.taobao.txc.global.vipcheck";
    private boolean globalForceVipCheck = false;
    private static final int TIMEOUT = 5000;
    private static final int LONGTIMEOUT = 60000;
    private ConcurrentHashMap<String, String> groupList = new ConcurrentHashMap();
    private volatile List<String> serverAddressList = new ArrayList<String>();
    private MyConfigServerObserver curObserver;

    public AddressManagerDiamondImpl() {
        String str;
        boolean skipVip = TxcConfigHolder.getSkipVip(false);
        if (!skipVip && !StringUtils.isEmpty((String)(str = TxcConfigHolder.getInstance().getConfig(GLOBAL_FORCE_VIP_CHECK_DATAID, "TXC_GROUP")))) {
            try {
                if (str.equals(Character.valueOf('1')) || Boolean.parseBoolean(str)) {
                    this.globalForceVipCheck = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getAddressList(String vgroup, AddressWatcher watcher) throws InterruptedException {
        AddressManagerDiamondImpl addressManagerDiamondImpl = this;
        synchronized (addressManagerDiamondImpl) {
            try {
                String rGroup = this.getRGroupByVGroup(vgroup);
                if (rGroup == null || rGroup.length() == 0) {
                    throw new TxcException("can't fetch real group name from diamond!vgroup_mapping_" + vgroup);
                }
                this.getAddressListFromStorage(rGroup, watcher);
            }
            catch (Exception e) {
                throw TxcException.nestedException(e);
            }
        }
        TxcConfigHolder.getInstance().addListener("vgroup_mapping_" + vgroup, "TXC_GROUP", new ITxcManagerListener(){

            @Override
            public Executor getExecutor() {
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void receiveConfigInfo(String rGroup) {
                AddressManagerDiamondImpl addressManagerDiamondImpl = AddressManagerDiamondImpl.this;
                synchronized (addressManagerDiamondImpl) {
                    try {
                        logger.info("vgroup mapping changed to:" + rGroup);
                        AddressManagerDiamondImpl.this.getAddressListFromStorage(rGroup, null);
                    }
                    catch (InterruptedException e) {
                        logger.error(TxcErrCode.DiamondAddVgroupListenerError, e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String group, String address) {
        if (!this.groupList.contains(address)) {
            String string = address.intern();
            synchronized (string) {
                if (!this.groupList.containsKey(address)) {
                    String content;
                    String dataId = "com.taobao.txc.grouplist." + group;
                    while (true) {
                        try {
                            content = TxcConfigHolder.getInstance().getConfig(dataId, "TXC_GROUP", 5000L);
                            logger.info("content:" + content);
                        }
                        catch (IOException e2) {
                            TxcErrCode code = TxcErrCode.DiamondGetConfig;
                            logger.error(code.errCode, code.errMessage, (Throwable)e2);
                            try {
                                Thread.sleep(5000L);
                            }
                            catch (InterruptedException e2) {}
                            continue;
                        }
                        break;
                    }
                    logger.info("dataid:" + dataId + ",address:" + address);
                    TxcConfigHolder.getInstance().putAggr(dataId, "TXC_GROUP", address, address);
                    logger.info("write group server to diamond");
                    this.groupList.put(address, address);
                    int tryTimes = 0;
                    while (tryTimes < 10) {
                        try {
                            content = TxcConfigHolder.getInstance().getConfig(dataId, "TXC_GROUP", 5000L);
                            logger.info("new groupList:" + content);
                            if (content != null && content.indexOf(address) >= 0) break;
                            logger.info("publish again.");
                            TxcConfigHolder.getInstance().putAggr(dataId, "TXC_GROUP", address, address);
                            Thread.sleep(1000L);
                            ++tryTimes;
                        }
                        catch (Exception e) {
                            TxcErrCode code = TxcErrCode.DiamondGetConfig;
                            logger.error(code.errCode, code.errMessage, (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    public List<String> getServerAddressList() {
        return this.serverAddressList;
    }

    public void setServerAddressList(List<String> serverAddressList) {
        this.serverAddressList = serverAddressList;
    }

    public String getRGroupByVGroup(String vgroupname) throws IOException {
        return TxcConfigHolder.getInstance().getConfig("vgroup_mapping_" + vgroupname, "TXC_GROUP", 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean fetchAndReverseRGroupByVGroup(String vgroupname, String changedRGroup, HttpSecurity httpSecurity) {
        LinkedList<String> linkedList = RpcClient.getInstance().rGroupList;
        synchronized (linkedList) {
            if (RpcClient.getInstance().rGroupList.size() < 2) {
                return false;
            }
            if (changedRGroup != null && !changedRGroup.equals(RpcClient.getInstance().rGroupList.get(0))) {
                return false;
            }
            Collections.reverse(RpcClient.getInstance().rGroupList);
            boolean flag = false;
            StringBuilder sb = new StringBuilder();
            for (String s : RpcClient.getInstance().rGroupList) {
                if (flag) {
                    sb.append('\n');
                } else {
                    flag = true;
                }
                sb.append(s);
            }
            try {
                TxcConfigHolder.getInstance().putSingle("vgroup_mapping_" + vgroupname, "TXC_GROUP", sb.toString(), httpSecurity);
            }
            catch (Exception e) {
                logger.warn("publish vgroup_mapping_" + vgroupname + " to " + sb + " fail.");
                Collections.reverse(RpcClient.getInstance().rGroupList);
                return false;
            }
            logger.alarm("vgroup_mapping_" + vgroupname + " changed to " + sb);
            return true;
        }
    }

    @Override
    public void unpublish(String group, String address) {
        logger.info("unpublish address:" + address);
        this.groupList.remove(address);
        String dataId = "com.taobao.txc.grouplist." + group;
        TxcConfigHolder.getInstance().removeAggr(dataId, "TXC_GROUP", address);
        try {
            logger.info("new groupList:" + TxcConfigHolder.getInstance().getConfig(dataId, "TXC_GROUP", 5000L));
        }
        catch (IOException e) {
            TxcErrCode code = TxcErrCode.DiamondGetConfig;
            logger.error(code.errCode, code.errMessage, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void getAddressListFromStorage(String rGroup, AddressWatcher watcher) throws InterruptedException {
        CountDownLatch countDownLatch;
        block13: {
            if (StringUtils.isEmpty((String)rGroup)) {
                return;
            }
            List<String> rGroupList = TxcString.readLineToList(rGroup);
            if (rGroupList == null || rGroupList.size() == 0) {
                return;
            }
            LinkedList<String> linkedList = RpcClient.getInstance().rGroupList;
            synchronized (linkedList) {
                RpcClient.getInstance().rGroupList.clear();
                for (int i = 0; i < rGroupList.size(); ++i) {
                    RpcClient.getInstance().rGroupList.add(rGroupList.get(i));
                }
            }
            String dataId = "com.taobao.txc.grouplist." + rGroupList.get(0);
            countDownLatch = new CountDownLatch(1);
            if (this.curObserver != null) {
                watcher = this.curObserver.watcher;
                this.curObserver.disable();
                TxcConfigHolder.getInstance().removeListener(dataId, "TXC_GROUP", this.curObserver);
            }
            if (watcher == null) {
                throw new RuntimeException("watcher is null");
            }
            this.curObserver = new MyConfigServerObserver(countDownLatch, watcher);
            TxcConfigHolder.getInstance().addListener(dataId, "TXC_GROUP", this.curObserver);
            try {
                String content = TxcConfigHolder.getInstance().getConfig(dataId, "TXC_GROUP", 60000L);
                if (content != null) {
                    List serverAddressList = this.curObserver.dataChange(content);
                    if (serverAddressList != null) {
                        for (String serverAddress : serverAddressList) {
                            RpcClient.getInstance().serverAddressToRGroupMap.put(serverAddress, rGroupList.get(0));
                        }
                    }
                    break block13;
                }
                throw new TxcException("grouplist is null, dataId:" + dataId);
            }
            catch (IOException e) {
                logger.error(TxcErrCode.DiamondGetConfig, e);
            }
        }
        countDownLatch.await();
    }

    private class MyConfigServerObserver
    implements ITxcManagerListener {
        private CountDownLatch countDownLatch;
        private AddressWatcher watcher;
        private boolean disable = false;

        private MyConfigServerObserver(CountDownLatch countDownLatch, AddressWatcher watcher) {
            this.countDownLatch = countDownLatch;
            this.watcher = watcher;
        }

        private synchronized List<String> dataChange(String data) {
            if (this.disable) {
                return null;
            }
            List<String> serverAddressList = TxcString.readLineToList(data);
            if (serverAddressList != null) {
                String vipAddress = null;
                for (String serverAddress : serverAddressList) {
                    String vipAddressDataId = null;
                    int retry = -1;
                    do {
                        try {
                            vipAddressDataId = TxcString.toServerAddressVipDataId(serverAddress);
                            vipAddress = TxcConfigHolder.getInstance().getConfig(vipAddressDataId, "TXC_GROUP", 5000L);
                            logger.info(vipAddressDataId + "=" + vipAddress);
                            if (vipAddress != null) {
                                TxcConfigHolder.getInstance().setVipCanBeSkipped(true);
                            }
                            vipAddressDataId = TxcString.toServerAddressVipVPCDataId(serverAddress);
                            String vipVPCAddress = TxcConfigHolder.getInstance().getConfig(vipAddressDataId, "TXC_GROUP", 5000L);
                            logger.info(vipAddressDataId + "=" + vipVPCAddress);
                            if (vipVPCAddress != null) {
                                TxcConfigHolder.getInstance().setVipCanBeSkipped(false);
                                vipAddress = vipVPCAddress;
                            }
                            if (vipAddress != null) break;
                            if (!AddressManagerDiamondImpl.this.globalForceVipCheck) continue;
                            if (retry == -1) {
                                retry = 50;
                            }
                            --retry;
                            logger.info(String.format("get vip retry:%s", serverAddress));
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        catch (IOException e) {
                            logger.error(TxcErrCode.DiamondGetConfig.errCode, String.format("get vip failed:%s", serverAddress));
                            if (!AddressManagerDiamondImpl.this.globalForceVipCheck) continue;
                            if (retry == -1) {
                                retry = 50;
                            }
                            --retry;
                            logger.info(String.format("get vip retry:%s", serverAddress));
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    } while (retry > 0);
                    if (AddressManagerDiamondImpl.this.globalForceVipCheck && vipAddress == null) {
                        String errorMsg = String.format("vip address not available [%s]", serverAddress);
                        TxcConfigHolder.getInstance().sendAlertWithDelay(RpcClient.getVgroup(), errorMsg, 10, RpcClient.getHttpSecurity());
                        logger.error(TxcErrCode.VipConfigIncompleteFailed.errCode, errorMsg);
                        throw new TxcException(errorMsg);
                    }
                    this.watcher.onVipAddressBind(serverAddress, vipAddress);
                }
                this.watcher.onAddressListChanged(serverAddressList);
            }
            if (this.countDownLatch.getCount() > 0L) {
                this.countDownLatch.countDown();
            }
            return serverAddressList;
        }

        private synchronized void disable() {
            this.disable = true;
        }

        @Override
        public Executor getExecutor() {
            return null;
        }

        @Override
        public void receiveConfigInfo(String content) {
            this.dataChange(content);
        }
    }
}

