/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.txc.sample;

import com.taobao.txc.client.aop.annotation.TxcTransaction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;

public class StandardModeClient2 {
    private static final boolean test_disable_txc = false;

    @TxcTransaction(timeout=180000)
    public void insert(AtomicLong id, JdbcTemplate jdbcTemplate1, JdbcTemplate jdbcTemplate2) {
        long nextId = id.getAndIncrement();
        jdbcTemplate1.update("insert into students (id,name,value) values (?,'abc', 100)", new Object[]{nextId});
        jdbcTemplate2.update("insert into `order` (id,name,value) values (?,'abc', 100)", new Object[]{nextId});
        if (id.longValue() % 99L == 0L) {
            throw new RuntimeException("ccccccccc");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TxcTransaction(timeout=180000)
    public void update(AtomicLong id, JdbcTemplate jdbcTemplate1, JdbcTemplate jdbcTemplate2) throws SQLException {
        long nextId = id.getAndIncrement();
        Connection con1 = null;
        Connection con2 = null;
        Statement st1 = null;
        Statement st2 = null;
        try {
            con1 = jdbcTemplate1.getDataSource().getConnection();
            con1.setAutoCommit(false);
            st1 = con1.createStatement();
            st1.execute("update students set value=200 where id=" + nextId);
            st1.execute("update persons set score=score+1 where id=" + nextId % 1000L + " or id=" + (nextId + 1L) % 1000L);
            con1.commit();
            con1.setAutoCommit(true);
            if (id.longValue() % 246L == 0L) {
                throw new RuntimeException("aaaaaaaaaaaaa");
            }
            con2 = jdbcTemplate2.getDataSource().getConnection();
            con2.setAutoCommit(false);
            st2 = con2.createStatement();
            st2.execute("update `order` set `value`=300 where `id`=" + nextId);
            st2.execute("update persons set score=score+1 where id=" + nextId % 1000L + " or id=" + (nextId + 1L) % 1000L);
            con2.commit();
            con2.setAutoCommit(true);
        }
        finally {
            if (st1 != null) {
                st1.close();
            }
            if (con1 != null) {
                con1.close();
            }
            if (st2 != null) {
                st2.close();
            }
            if (con2 != null) {
                con2.close();
            }
        }
        if (id.longValue() % 123L == 0L) {
            throw new RuntimeException("bbbbbb");
        }
    }

    @TxcTransaction(timeout=180000)
    public void delete(AtomicLong id, JdbcTemplate jdbcTemplate1, JdbcTemplate jdbcTemplate2) {
        long nextId = id.getAndIncrement();
        jdbcTemplate1.update("delete from students where value > 100 and id=" + nextId);
        if (id.longValue() % 112L == 0L) {
            throw new RuntimeException("eeeee");
        }
        jdbcTemplate2.update("delete from `order` where `value` > 100 and `id`=" + nextId);
        if (id.longValue() % 111L == 0L) {
            throw new RuntimeException("fffff");
        }
    }

    public static void main(String[] args) {
        String configFile = "standard-mode-client-context.xml";
        if (args.length > 0 && args[0].compareTo("-c") == 0) {
            configFile = "standard-mode-client-cobar-context.xml";
            System.out.println("cobar mode...\n\n");
        } else {
            System.out.println("tddl mode... \n\n");
        }
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(configFile);
        int threadCount = 20;
        final CountDownLatch countDownLatch = new CountDownLatch(threadCount);
        final StandardModeClient2 clienttest = (StandardModeClient2)context.getBean("clientTest2");
        final JdbcTemplate jdbcTemplate1 = (JdbcTemplate)context.getBean("jdbcTemplate1");
        final JdbcTemplate jdbcTemplate2 = (JdbcTemplate)context.getBean("jdbcTemplate2");
        jdbcTemplate1.execute("truncate  students");
        jdbcTemplate1.execute("truncate  students_0001");
        jdbcTemplate1.execute("truncate  students_0002");
        jdbcTemplate2.execute("delete from  `order`");
        jdbcTemplate1.execute("update persons set score=0");
        jdbcTemplate2.execute("update persons set score=0");
        int i = 0;
        while (i < threadCount) {
            final int threadId = i++;
            Thread thread = new Thread(){

                @Override
                public void run() {
                    int i;
                    AtomicLong id = new AtomicLong(threadId * 100 + 10000);
                    System.out.println(Calendar.getInstance().getTime());
                    for (i = 0; i < 50; ++i) {
                        try {
                            clienttest.insert(id, jdbcTemplate1, jdbcTemplate2);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    for (i = 50; i < 100; ++i) {
                        try {
                            clienttest.insert(id, jdbcTemplate1, jdbcTemplate2);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    id.set(threadId * 100 + 10000);
                    for (i = 0; i < 100; ++i) {
                        try {
                            clienttest.update(id, jdbcTemplate1, jdbcTemplate2);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    id.set(threadId * 100 + 10000);
                    for (i = 0; i < 100; ++i) {
                        try {
                            clienttest.delete(id, jdbcTemplate1, jdbcTemplate2);
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    countDownLatch.countDown();
                    System.out.println(Calendar.getInstance().getTime());
                }
            };
            thread.start();
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("at mode txc finish -----------------");
        System.out.println("wait for 3 minute  ------------------");
        try {
            Thread.sleep(180000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("checking result --------------------");
        ArrayList<String> l1 = new ArrayList<String>();
        ArrayList<String> l2 = new ArrayList<String>();
        List ids1 = jdbcTemplate1.queryForList("select id from students where value>100 order by id");
        List ids2 = jdbcTemplate2.queryForList("select id from `order` where value>100 order by id");
        for (Map m : ids1) {
            for (Object o : m.values()) {
                l1.add(o.toString());
            }
        }
        for (Map m : ids2) {
            for (Object o : m.values()) {
                l2.add(o.toString());
            }
        }
        System.out.println("id list on datasource1 which delete is rollbacked,size:" + l1.size() + ", value :" + l1);
        System.out.println("id list on datasource2 which delete is rollbacked,size:" + l2.size() + ", value :" + l2);
        if (l1.size() == l2.size() && l1.containsAll(l2) && l2.containsAll(l1)) {
            System.out.println("the result is good.");
        } else {
            if (!l2.containsAll(l1)) {
                l1.removeAll(l2);
                System.out.println("l1 has extra data:" + l1);
            } else if (!l1.containsAll(l2)) {
                l2.removeAll(l1);
                System.out.println("l2 has extra data:" + l2);
            }
            System.out.println("the result is wrong. please check.");
        }
        List ids3 = jdbcTemplate1.queryForList("select id from students where value=100 order by id");
        List ids4 = jdbcTemplate2.queryForList("select id from `order` where value=100 order by id");
        l1.clear();
        l2.clear();
        for (Map m : ids3) {
            for (Object o : m.values()) {
                l1.add(o.toString());
            }
        }
        for (Map m : ids4) {
            for (Object o : m.values()) {
                l2.add(o.toString());
            }
        }
        System.out.println("id list on datasource1 which keep old value,size:" + l1.size() + ", value :" + l1);
        System.out.println("id list on datasource2 which keep old value,size:" + l2.size() + ", value :" + l2);
        if (l1.size() == l2.size() && l1.containsAll(l2) && l2.containsAll(l1)) {
            System.out.println("the result is good.");
        } else {
            if (!l2.containsAll(l1)) {
                l1.removeAll(l2);
                System.out.println("l1 has extra data:" + l1);
            } else if (!l1.containsAll(l2)) {
                l2.removeAll(l1);
                System.out.println("l2 has extra data:" + l2);
            }
            System.out.println("the result is wrong. please check.");
        }
        int total1 = jdbcTemplate1.queryForInt("select sum(score) from persons");
        int total2 = jdbcTemplate2.queryForInt("select sum(score) from persons");
        System.out.println("failed transacion number:" + (threadCount * 200 - total1) / 2 + "," + (threadCount * 200 - total2) / 2);
        context.close();
        System.exit(0);
    }
}

