import React, {Component} from 'react'
import { Button } from 'antd';
import { PageContainer } from '@ant-design/pro-components';
import QueenEngine, {kQueenBeautyType, kQueenBeautyParams, kQueenBeautyMakeupType, kQueenBeautyFaceShapeType, kQueenBeautyBlend,} from "../../queensdk"
import styles from './index.less';
import { EMsgid, tracker } from '@/utils/stat';
class HomePage extends Component{
  private queenEngine: any;
  private queenEnabled: boolean;
  constructor(props:any) {
    super(props)
    this.queenEngine = null;
    this.queenEnabled = false;
    this.state = {
     
    }
  }

  /**
   * QUEEN SDK 初始化
   */
  queenInitialize = () =>{
    const self = this;
    const startTime = performance.now();
    this.queenEngine = new QueenEngine();
    this.queenEngine.initialize("./", "", function(){
      tracker.queenInitReport({ms: performance.now() - startTime});
    }, function(progress: number){
      self.setState({loadProgress: progress});
    });
  }

  /**
   * 应用基础美颜和高级美颜
   */
  queenEffect = ()=>{
    this.testBaseFaceBeauty();
    this.testAdvancedFaceBeauty();
  }

  /**
   * 基础美颜
   */
  testBaseFaceBeauty() {
    this.queenEnabled = true;
    // 打开磨皮锐化功能开关
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.SkinBuffing, true);
    // 设置磨皮系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.SkinBuffing, 0.9);
    // 设置锐化系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.Sharpen, 0.5);
    // 打开美白功能开关
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.SkinWhiting, true);
    // 设置美白系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.Whitening, 0.5);
  }

  /**
   * 高级美颜
   */
  testAdvancedFaceBeauty() {
    this.queenEnabled = true;
    //高级美颜
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.FaceBuffing, true);
    // 设置去眼袋系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.Pouch, 0.9);
    // 设置去法令纹系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.NasolabialFolds, 0.9);
    // 设置白牙系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.WhiteTeeth, 0.9);
    // 设置口红系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.Lipstick, 0.1);
    // 设置腮红系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.Blush, 0.1);
    // 设置口红色相系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.LipstickColorParam, 0.1);
    // 设置口红饱和度系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.LipstickGlossParam, 0.3);
    // 设置口红明度系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.LipstickBrightnessParam, 0.3);
    // 设置亮眼系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.BrightenEye, 0.9);
    // 设置红润系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.SkinRed, 0.2);
    // 设置去皱纹系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.Wrinkles, 0.9);
    // 设置去暗沉系数
    this.queenEngine.setQueenBeautyParams(kQueenBeautyParams.BrightenFace, 0.3);
  }

   /**
    * 美型
    */
   testFaceShape =()=> {
    this.queenEnabled = true;
    // 打开美型功能开关
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.FaceShape, true);
    // 设置大眼系数
    this.queenEngine.setFaceShape(kQueenBeautyFaceShapeType.BigEye, 0.9);
    // 设置发际线系数
    this.queenEngine.setFaceShape(kQueenBeautyFaceShapeType.HairLine, 1.0);
    // 设置嘴角上扬(微笑)系数
    this.queenEngine.setFaceShape(kQueenBeautyFaceShapeType.Smile, 0.5);
  }

  /**
   * 美妆
   */
  testFaceMakeup=()=>{
    this.applyFaceMakeup();
  }

  /**
   * 配置美妆资源
   */
  async applyFaceMakeup(){
    this.queenEnabled = true;
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.Makeup, true);
    // 设置美妆口红效果的透明度，目前female参数的值统一传YES/true，男性妆容还在优化中    
    const mouthMakeupPackageUrl = "queen_res/makeup/mouth_yaochun/shiliuhong.1.2.3.bin";
    await this.queenEngine.setMakeupWithPackage(kQueenBeautyMakeupType.Mouth, mouthMakeupPackageUrl, "1.2.3.png", kQueenBeautyBlend.LabMix);
    this.queenEngine.setMakeupAlphaWithType(kQueenBeautyMakeupType.Mouth, true, 1.0);

    // 设置美妆眉毛效果的透明度，目前female参数的值统一传YES/true，男性妆容还在优化中    
    const eyeBrowMakeupPackageUrl = "queen_res/makeup/eyebrow/biaozhunmei.2.3.bin";
    await this.queenEngine.setMakeupWithPackage(kQueenBeautyMakeupType.EyeBrow, eyeBrowMakeupPackageUrl, "biaozhunmei.2.3.png", kQueenBeautyBlend.Multiply);
    this.queenEngine.setMakeupAlphaWithType(kQueenBeautyMakeupType.EyeBrow, true, 0.5);

    //设置美妆睫毛效果的透明度，目前female参数的值统一传YES/true，男性妆容还在优化中    
    const eyeashMakeupUrl = "queen_res/makeup/eyelash/chenjing.2.3.png";
    await this.queenEngine.setMakeupWithUrl(kQueenBeautyMakeupType.Eyelash, eyeashMakeupUrl, kQueenBeautyBlend.Multiply);
    this.queenEngine.setMakeupAlphaWithType(kQueenBeautyMakeupType.Eyelash, true, 0.6);
    
    // 设置美妆腮红效果的透明度，目前female参数的值统一传YES/true，男性妆容还在优化中
    const blushMakeupUrl = "queen_res/makeup/blush/blush_wugu.2.3.png";
    await this.queenEngine.setMakeupWithUrl(kQueenBeautyMakeupType.Blush, blushMakeupUrl, kQueenBeautyBlend.LabMix);
    this.queenEngine.setMakeupAlphaWithType(kQueenBeautyMakeupType.Blush, true, 0.6);
  }

  /**
   * 通过MediaStreamTrackProcessor api实现
   * 需要chrome 94+ 版本支持
   * @param stream 
   */
  transformMediaStream = (stream: any) =>{
    const self = this;
    const queenTransformer = new TransformStream({
      transform(frame, controller){
        const videoTimestamp = frame.timestamp;
          if(self.queenEnabled ){
            let startTime = performance.now();
            self.queenEngine.renderWithMediaObject(frame, frame.displayWidth, frame.displayHeight, function(imageBufferData:any , imageWidth:number, imageHeight:number){
                tracker.queenRenderReport({ts: performance.now() - startTime});
                const imageData = new ImageData(new Uint8ClampedArray(imageBufferData), imageWidth, imageHeight);               
                createImageBitmap(imageData).then(newBitmap =>{
                  const newFrame = new VideoFrame(newBitmap, {
                      timestamp: videoTimestamp
                  });
                  newBitmap.close();
                  controller.enqueue(newFrame);
                  frame.close();
                });
            });
          }else{
            controller.enqueue(frame);
          }
     }
    });

    if(this.supportMediaStreamTrack()){
      const videoTrack = stream.getVideoTracks()[0];
      const processor = new MediaStreamTrackProcessor({track: videoTrack});
      const readFrameStream = processor.readable;
      const generator = new MediaStreamTrackGenerator({ kind: 'video' });
      let writeFrameStream = generator.writable;
      readFrameStream.pipeThrough(queenTransformer).pipeTo(writeFrameStream);

      const processedStream = new MediaStream();
      processedStream.addTrack(generator);
      // processedStream.addTrack(stream.getAudioTracks()[0]);
      const video = document.getElementById('source'); 
      if(video){
        video.srcObject = processedStream;
        setTimeout(() => {
          video.play();
        }, 10);
      }     
    }else{
      alert("当前Demo需要Chrome 94+版本浏览器支持.");
    }
  }

  /**
   * 
   * @returns 判断当前浏览器是否支持MediaStreamTrackProcessor
   */
  supportMediaStreamTrack(){
    return typeof MediaStreamTrackProcessor !== 'undefined' || 
    typeof MediaStreamTrackGenerator !== 'undefined';
  }

  /**
   * 增加头像贴纸
   */
  async addSticker(){
    this.queenEnabled = true;
    const sticker1 =  "queen_res/sticker/9.bin";
    await this.queenEngine.addMaterialWithUrl(sticker1);

    const sticker2 =  "queen_res/sticker/10.bin";
    await this.queenEngine.addMaterialWithUrl(sticker2);
  }

  /**
   * 设置滤镜效果
   */
  applyFilterEffect = () =>{
    const self = this;
    this.queenEnabled = true;
    const filterUrl = "queen_res/lookups/A3.png";
    // 资源配置
    this.queenEngine.setLutImageUrl(filterUrl).then(function(){
      // 打开滤镜功能开关
      self.queenEngine.setQueenBeautyType(kQueenBeautyType.LUT, true);
      // 设置滤镜强度
      self.queenEngine.setQueenBeautyParams(kQueenBeautyParams.LUT, 0.5);
    });
  }

  /**
   * 头像贴纸
   */
  applyStickerEffect = ()=>{
    this.queenEnabled = true;
    this.addSticker();
  }

  /**
   * 背景虚化
   */
  bokehBackground = () =>{
    this.queenEnabled = true;
    this.queenEngine.setSegmentBackgroundUrl("");
    this.queenEngine.enableBokehBackground(true);
  }

  /**
   * 背景抠图
   */
  cutoutBackground = () =>{
    this.queenEnabled = true;
    let backgroundPath = "queen_res/background/b2.png";
    this.queenEngine.enableBokehBackground(false);
    this.queenEngine.setSegmentBackgroundUrl(backgroundPath).then(()=>{
    });
  }

  /**
   * 美颜效果重置
   */
  resetEffect = () =>{
    this.queenEnabled = false;
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.SkinBuffing, false);
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.SkinWhiting, false);
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.FaceBuffing, false);
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.FaceShape, false);
    this.queenEngine.setQueenBeautyType(kQueenBeautyType.Makeup, false);

    this.queenEngine.enableBokehBackground(false);
    this.queenEngine.setSegmentBackgroundUrl("").then(()=>{
    });
   
    const sticker1 =  "queen_res/sticker/9.bin";
    this.queenEngine.removeMaterialWithUrl(sticker1);

    const sticker2 =  "queen_res/sticker/10.bin";
    this.queenEngine.removeMaterialWithUrl(sticker2);

    this.queenEngine.setLutImageUrl("").then(()=>{});
  }

  openCamera =(constraints: string)=> {
    if(typeof navigator.mediaDevices !== 'undefined'){
      navigator.mediaDevices.getUserMedia(constraints)
      .then(mediaStream => {
        this.queenInitialize();
        this.transformMediaStream(mediaStream)
      }); 
    }else{
      alert("请开启摄像头支持.");
    }
   
  }   

  componentDidMount(){
    tracker.actionReport(EMsgid.PAGELOAD);
    let constraints = { audio: false, video: { mandatory: { maxWidth: 1280, maxHeight: 960 }}};
    this.openCamera(constraints);        
  }

  componentWillUnmount(){
    this.queenEnabled = false;
    const videoElem = document.querySelector('video');
    if(videoElem?.srcObject){
      const stream = videoElem.srcObject;
      const tracks = stream.getTracks();
      tracks.forEach(function(track) {
        track.stop();
      });
      videoElem.srcObject = null;
    }
    
  }

  render() {
    return (
    <>
    <PageContainer>
      <div className=''>
        RTC场景演示，<a href='https://queen.aliyuncs.com' target='blank'>查看完整Demo</a>
      </div>      
      <div className={styles.action}>
      <Button type="default" onClick={this.queenEffect} >美颜</Button>
      <Button type="default" onClick={this.testFaceShape} >美型</Button>
      <Button type="default" onClick={this.testFaceMakeup} >美妆</Button>
      <Button type="default" onClick={this.applyFilterEffect} >滤镜</Button>
      <Button type="default" onClick={this.bokehBackground} >背景虚化</Button>
      <Button type="default" onClick={this.cutoutBackground} >背景抠图</Button>
      <Button type="default" onClick={this.applyStickerEffect} >头像贴纸</Button>
      <Button type="default" onClick={this.resetEffect} >重置</Button>
      </div>
      <div className={styles.container}>
        <video  controls={false} id="source" width="680" height="510"/>
      </div>
    </PageContainer>
    </>
  );
};
}
export default HomePage;
