from flask import Flask, render_template, request
import oss2
from oss2.credentials import EnvironmentVariableCredentialsProvider

app = Flask(__name__)


@app.route("/")
def hello_world():
    return render_template('index.html')


# 从环境变量中获取访问凭证。运行本代码示例之前，请确保已设置环境变量OSS_ACCESS_KEY_ID和OSS_ACCESS_KEY_SECRET。
auth = oss2.ProviderAuth(EnvironmentVariableCredentialsProvider())
# 将<your-endpoint>替换为Bucket所在地域对应的Endpoint。以华东1（杭州）为例，Endpoint填写为https://oss-cn-hangzhou.aliyuncs.com。
# 将<your-bucket>替换为Bucket名称。
bucket = oss2.Bucket(auth, '<your-endpoint>', '<your-bucket>')
# 指定过期时间，单位秒。
expire_time = 3600



@app.route('/get_presigned_url_for_oss_upload', methods=['GET'])
def generate_presigned_url():
    # 获取用户传入文件名称
    filename = request.args.get('filename')
    # 填写Object完整路径，例如exampledir/exampleobject.png。Object完整路径中不能包含Bucket名称。
    object_name = 'exampledir/' + filename
    # 指定Header。
    headers = dict()
    # 指定Content-Type。
    headers['Content-Type'] = 'image/png'
    # 指定存储类型。
    # headers["x-oss-storage-class"] = "Standard"
    # 生成签名URL时，OSS默认会对Object完整路径中的正斜线（/）进行转义，从而导致生成的签名URL无法直接使用。
    # 设置slash_safe为True，OSS不会对Object完整路径中的正斜线（/）进行转义，此时生成的签名URL可以直接使用。
    url = bucket.sign_url('PUT', object_name, expire_time, slash_safe=True, headers=headers)
    return url


app.run(host="0.0.0.0", port=8000)
