//
//  ViewController.m
//  FaceDetectDemo
//
//  Created by richard on 14/10/2017.
//  Copyright © 2017 com.alipay.faceDetect. All rights reserved.
//

#import "ViewController.h"
#import "RadioButton.h"
#import <AliyunFaceAuthFacade/AliyunFaceAuthFacade.h>

@interface ViewController ()<UITextFieldDelegate >
{
    UITextField * _idTextField;
    UITextField * _nameTextField;
    UITextField * _midTextField;
    UITextField * _muidTextField;
    UILabel     *_switchLabel;
    UISwitch *_switchButton;
    UIButton  *_querryButton;
    NSString  *certifyId;
    UIActivityIndicatorView *_indicator;
    UIButton *_submitInfo; //开始认证的Button
    UIButton *_certifyIdInfo;//获取certifyId的Button
//    UIButton *_certifyIdResult;//certifyId的结果Button，不能点击，只能看
    NSString * _hostChoice;
}
@property(nonatomic,strong)UITextField *certifyIdResult;

@end


@implementation ViewController

//不支持动态切换横竖屏。
- (BOOL)shouldAutorotate{
    return NO;
}


- (void)viewDidLoad {
    
    [super viewDidLoad];
    certifyId = nil;

    UILabel *initLabelDesc = [[UILabel alloc] initWithFrame:CGRectMake(20, 90, 200, 30)];
    initLabelDesc.text = @"认证";
    initLabelDesc.font = [UIFont systemFontOfSize:15];
    initLabelDesc.textColor = [UIColor blueColor];
    [self.view addSubview:initLabelDesc];

    UIView *seperateView = [[UIView alloc] initWithFrame:CGRectMake(20, initLabelDesc.frame.size.height + initLabelDesc.frame.origin.y, self.view.frame.size.width - 40, 1)];
    seperateView.backgroundColor = [UIColor blueColor];
    [self.view addSubview:seperateView];

    UILabel *nameLabelDesc = [[UILabel alloc] initWithFrame:CGRectMake(50, seperateView.frame.size.height + seperateView.frame.origin.y +10, 90, 40)];
    nameLabelDesc.text = @"用户姓名:";
    nameLabelDesc.font = [UIFont systemFontOfSize:18];
    [self.view addSubview:nameLabelDesc];

    _nameTextField = [[UITextField alloc] initWithFrame:CGRectMake(nameLabelDesc.frame.origin.x+nameLabelDesc.frame.size.width,nameLabelDesc.frame.origin.y, self.view.frame.size.width - 20-(nameLabelDesc.frame.origin.x+nameLabelDesc.frame.size.width), 40)];
    _nameTextField.textColor = [UIColor blackColor];
    _nameTextField.font = [UIFont systemFontOfSize:18];
    _nameTextField.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:_nameTextField];
    _nameTextField.placeholder = @"请输入姓名(必填)";
    _nameTextField.borderStyle = UITextBorderStyleRoundedRect;
    _nameTextField.delegate = self;

    UILabel *idLabelDesc = [[UILabel alloc] initWithFrame:CGRectMake(nameLabelDesc.frame.origin.x, nameLabelDesc.frame.origin.y + nameLabelDesc.frame.size.height + 10, 90, 40)];
    idLabelDesc.text = @"身份证号:";
    idLabelDesc.font = [UIFont systemFontOfSize:18];
    [self.view addSubview:idLabelDesc];

    _idTextField = [[UITextField alloc] initWithFrame:CGRectMake(_nameTextField.frame.origin.x,_nameTextField.frame.origin.y + _nameTextField.frame.size.height + 10, self.view.frame.size.width - 20-(nameLabelDesc.frame.origin.x+nameLabelDesc.frame.size.width), 40)];
    _idTextField.textColor = [UIColor blackColor];
    _idTextField.font = [UIFont systemFontOfSize:18];
    _idTextField.backgroundColor = [UIColor whiteColor];
    [self.view addSubview:_idTextField];
    _idTextField.placeholder = @"请输入身份证(必填)";
    _idTextField.borderStyle = UITextBorderStyleRoundedRect;
    _idTextField.delegate = self;
    //_idTextField.secureTextEntry = YES;

    //获取certifyId.
    UIButton *certifyIdInfoButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [certifyIdInfoButton setFrame:CGRectMake((self.view.frame.size.width - 140)/2, idLabelDesc.frame.origin.y + idLabelDesc.frame.size.height + 20, 140, 30)];
    [certifyIdInfoButton setTitle:@"获取certifyId" forState:UIControlStateNormal];
    [certifyIdInfoButton addTarget:self action:@selector(getCertifyId) forControlEvents:UIControlEventTouchUpInside];
    certifyIdInfoButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [self.view addSubview:certifyIdInfoButton];
    _certifyIdInfo = certifyIdInfoButton;
    
    //获取certifyId.
    _certifyIdResult = [[UITextField alloc] init];//[UIButton buttonWithType:UIButtonTypeSystem];
    [_certifyIdResult setFrame:CGRectMake(20/2, certifyIdInfoButton.frame.origin.y + 30 + 8, self.view.frame.size.width - 20, 20)];
    [_certifyIdResult setText:@"还未获取certifyId" ];
    [_certifyIdResult setFont:[UIFont systemFontOfSize:14]];
    [_certifyIdResult setTextAlignment:NSTextAlignmentCenter];
    [_certifyIdResult setContentMode:UIViewContentModeCenter];        
    [_certifyIdResult setTintColor:[UIColor blackColor]];
    [self.view addSubview:_certifyIdResult];
    
    
    // Do any additional setup after loading the view, typically from a nib.
    UIButton *submitButton = [UIButton buttonWithType:UIButtonTypeSystem];
    [submitButton setFrame:CGRectMake((self.view.frame.size.width - 140)/2, _certifyIdResult.frame.origin.y + _certifyIdResult.frame.size.height + 20, 140, 30)];
    [submitButton setTitle:@"开始刷脸认证" forState:UIControlStateNormal];
    [submitButton addTarget:self action:@selector(submitInfo) forControlEvents:UIControlEventTouchUpInside];
    submitButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [self.view addSubview:submitButton];
    _submitInfo = submitButton;


    [AliyunFaceAuthFacade init];// 初始化SDK。
}




- (void)getCertifyId{

    [self alertInfomation:@"在代码里面填入身份证和用户名"];
    certifyId = nil;
}


- (void)submitInfo {
    certifyId = @"shafa369b743ae50519eb61707f80dc7";
    if ([certifyId length]<1) {
        [self alertInfomation:@"还未获取到certifyId"];
        return;
    }
    [_submitInfo setUserInteractionEnabled:NO];
    [self resisnFirstRespond];
    //第一个参数 ,这个参数从服务端拿到值。
//    certifyId =  @"0007494f9fb2d41ba36d7fad6af6875b";
    //第二个参数，extParams , 用于指定设备方向，展现网络菊花等。
    NSMutableDictionary  *extParams = [NSMutableDictionary new];
    //传入当前viewController，用于展现请求网络时的菊花。
    [extParams setValue:self forKey:@"currentCtr"];
    //    [extParams setValue:@"true" forKey:@"uploadLog"];
        
//    //下面是添加设备方位的参数。
//    UIInterfaceOrientation orientation = [[UIApplication sharedApplication] statusBarOrientation];
//    NSString *direction = @"";
//    switch (orientation) {
//        case UIInterfaceOrientationLandscapeLeft:
//            direction = @"left";
//            break;
//        case UIInterfaceOrientationLandscapeRight:
//            direction = @"right";
//            break;
//        default:
//            break;
//    }
//    //只有在iPad的横屏模式下，才传此参数。其他任何情况下都不传这个参数。目前界面不支持横竖屏动态切换。
//    [extParams setValue:direction forKey:@"direction"];
    

    //调用验证接口
    __weak ViewController* weakSelf = self;
    [AliyunFaceAuthFacade verifyWith:certifyId extParams:extParams onCompletion:^(ZIMResponse *response) {
         dispatch_async(dispatch_get_main_queue(), ^{
             
             [weakSelf.certifyIdResult setText:[NSString stringWithFormat:@"需要重新获取certifyId=%@",certifyId]];
             NSString *title = @"刷脸成功";
             switch (response.code) {
                 case 1000:
                     break;
                 case 1003:
                     title = @"用户退出";
                     break;
                 case 2002:
                     title = @"网络错误";
                     break;
                 case 2006:
                     title = @"刷脸失败";
                     break;
                 default:
                     break;
             }
             UIAlertController *alertController = [UIAlertController alertControllerWithTitle:title message:response.retMessageSub preferredStyle:UIAlertControllerStyleAlert];
             [alertController addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
                 [_submitInfo setUserInteractionEnabled:YES];
             }]];
             [self presentViewController:alertController animated:YES completion:nil];
            
         });
    }];
}


- (void)touchesBegan:(NSSet *)touches withEvent:(UIEvent *)event{
    [self resisnFirstRespond];
}
- (void)resisnFirstRespond {
    if ([_idTextField isFirstResponder]) {
        [_idTextField resignFirstResponder];
    }
    if ([_nameTextField isFirstResponder]) {
        [_nameTextField resignFirstResponder];
    }
    if ([_midTextField isFirstResponder]) {
        [_midTextField resignFirstResponder];
    }
    if ([_muidTextField isFirstResponder]) {
        [_muidTextField resignFirstResponder];
    }
}
- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
    // Dispose of any resources that can be recreated.
}

- (BOOL)textFieldShouldReturn:(UITextField *)textField {
    [textField resignFirstResponder];
    return YES;
}
- (BOOL)textField:(UITextField *)textField shouldChangeCharactersInRange:(NSRange)range replacementString:(NSString *)string;
{
    NSString * toBeString = [textField.text stringByReplacingCharactersInRange:range withString:string];
    
    if (_idTextField == textField) {
        if ([toBeString length] > 18) {
            textField.text = [toBeString substringToIndex:18];
            UIAlertController *alertController = [UIAlertController alertControllerWithTitle:@"身份证最多十八位" message:nil preferredStyle:UIAlertControllerStyleAlert];
            [alertController addAction:[UIAlertAction actionWithTitle:@"取消" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
            }]];
            [self presentViewController:alertController animated:YES completion:nil];
            return NO;
        }
    }
    return YES;
}

-(void)alertInfomation:(NSString*)title{
    UIAlertController *alertController = [UIAlertController alertControllerWithTitle:title message:nil preferredStyle:UIAlertControllerStyleAlert];
    [alertController addAction:[UIAlertAction actionWithTitle:@"确定" style:UIAlertActionStyleCancel handler:^(UIAlertAction * _Nonnull action) {
    }]];
    [self presentViewController:alertController animated:YES completion:nil];
}

@end


