//
//  ContentView.swift
//  SwiftiOS
//
//  Created by sanyuan.he on 2020/4/15.
//  Copyright © 2020 sanyuan.he. All rights reserved.
//

import SwiftUI


struct ContentView: View {
    var body: some View {
        
        VStack(alignment: .leading) {
            Text("欢迎使用人脸认证!!");
            Button(action: {
                let extParams: [String : Any] = ["currentCtr": UIApplication.shared.keyWindow?.rootViewController]
                //在实际代码中，请不要使用rootviewController，请获取自己业务的当前页面，然后传入。
                
                //sha329328116dc4376cce9411e88ba30  就是要替换的certifyId。替换后可以直接运行。
                AliyunFaceAuthFacade.verify(with: "sha3e1b7dcf55b26bcfaf87321cf52bd", extParams: extParams) { (response) in
                    DispatchQueue.main.async {
                        var resString = ""
                        switch response.code {
                        case .ZIMResponseSuccess:
                          resString = "认证成功"
                            break;
                        case .ZIMInterrupt:
                            resString = "初始化失败"
                         break
                        case .ZIMTIMEError:
                         resString = "设备时间错误"
                         break
                        case .ZIMNetworkfail:
                         resString = "网络错误"
                         break
                        case .ZIMInternalError:
                         resString = "用户退出"
                         break
                        case .ZIMResponseFail:
                         resString = "刷脸失败 "
                        default:
                            break
                        }
                        NSLog("%@",resString )
                    }
                }
            }) {
               Text("点击开始人脸认证")
            }
        }
    };


}

struct ContentView_Previews: PreviewProvider {
    static var previews: some View {
        ContentView()
    }
    

}
