import { defineConfig } from '@umijs/max';
import { resolve } from 'path'
export default defineConfig({
  dva: {},
  model: {},
  initialState: {},
  request: {},
  alias:{
    utils: resolve(__dirname, './src/utils'),
  },
  layout: {
    title: 'Queen Demo',
  },
  routes: [
    {
      path: '/',
      redirect: '/home',
    },
    {
      name: '美颜示例1',
      path: '/home',
      component: './Home',
    },
    {
      name: '美颜示例2',
      path: '/CanvasData',
      component: './CanvasData',
    },
    {
      name: '图片美颜示例',
      path: '/ImageData',
      component: './ImageData',
    },
    {
      name: '纹理示例',
      path: '/Texture',
      component: './Texture',
    },
    {
      name: '美颜录屏示例',
      path: '/Record',
      component: './Record',
    }
  ],
  devtool: 'eval',
  npmClient: 'yarn',
  hash:true,
  ignoreMomentLocale: true,
  history:{type:'hash'},
  fastRefresh: false
});

