> 本文为您介绍Web端美颜特效SDK（QueenWeb SDK）的接口文档、集成操作及简单使用示例，用于实现美颜特效功能。
## 一、准备工作
### 1.1、前提条件
开发环境要求如下表所示

| 浏览器 | 建议Chrome 84以上版本 |
| --- | --- |
| 开发环境 | Visual Studio Code |
| Node.js | 建议V14以上版本 |

## 1.2、使用说明
本文中引入的QueenWeb SDK的版本号1.0.1仅供参考。
### 1.2.1、集成方式
#### 1.2.1.1、TS项目整合示例

1. 下载后本项目"sdk_dist"目录中获取以下文件，并放到接入项目相应目录下
* sdk_dist/public/queen.wasm
* sdk_dist/public/queen.bin
* sdk_dist/src/queensdk/index.ts
* sdk_dist/src/queensdk/queen.js

1. 将上述文件复制到queenDemo项目相应目录下
2. 导入QueenWeb SDK
```bash
//导入SDK
import QueenEngine, {kQueenBeautyType, kQueenBeautyParams, kQueenBeautyMakeupType, kQueenBeautyFaceShapeType, kQueenBeautyBlend,} from "./queensdk"
```

### 1.2.2、扩展功能
#### 1.2.2.1、实景抠图

1. 添加依赖文件

 * sdk_dist/public/tensorflow/group1-shard1of1.bin
 * sdk_dist/public/tensorflow/model.json 

1. 添加依赖组件
> 如果需要实景抠图功能需要增加以下依赖

```bash
$ cd 项目
$ yarn add @tensorflow/tfjs
$ yarn add @tensorflow/tfjs-backend-webgl

或

$ npm add @tensorflow/tfjs
$ npm add @tensorflow/tfjs-backend-webgl
```
## 1.3、申请License
请提前获取License，获取方式请参见[获取美颜特效SDK License](https://help.aliyun.com/document_detail/312036.htm?spm=a2c4g.11186623.0.0.16d6354dj2hNm9#concept-2115342)。获取后参考以下步骤将LicenseKey配置到工程中。

> 演示版本可以不配置LicenseKey
## 二、Queen Web SDK接入示例
### 2.1、 初始化Queen引擎
```bash
 
 const sdkUrl= "./";//queen sdk bin文件目录
 const sdkLicense = "";//queen sdk 授权license
 const queenCanvasId = "canvas";//渲染使用的canvas id，可不传
 let queenEngine = new QueenEngine();
 queenEngine.initialize(sdkUrl, sdkLicense, function(){
    //初始化完成
 }, function(progress){
    //progress：加载进展条
 }, queenCanvasId);
```
### 2.2、配置美颜参数
```bash
// 开启基础美颜
queenEngine.setQueenBeautyType(kQueenBeautyType.SkinBuffing, true);
// 设置磨皮系数
queenEngine.setQueenBeautyParams(kQueenBeautyParams.SkinBuffing, 0.7);
// 设置锐化系数
queenEngine.setQueenBeautyParams(kQueenBeautyParams.Sharpen, 0.5);
// 打开美白功能开关
queenEngine.setQueenBeautyType(kQueenBeautyType.SkinWhiting, true);
// 设置美白系数
queenEngine.setQueenBeautyParams(kQueenBeautyParams.Whitening, 0.6);
// 设置红润系数
queenEngine.setQueenBeautyParams(kQueenBeautyParams.SkinRed, 0.2);
```
### 2.3、基于imageData对象渲染
```bash
const ctx = document.getElementById("sourceCanvas").getContext('2d');
const imgData = ctx.getImageData(0, 0, weblCtx.canvas.width, weblCtx.canvas.height);
queenEngine.render(new Uint8Array(imageSource.data), weblCtx.canvas.width, weblCtx.canvas.height, drawWithImageData) 

function drawWithImageData(imageBufferData, imgWidth, imgHeight) {
    let ctx = document.getElementById("effectCanvas").getContext("2d");
    let imageBuffer = new Uint8ClampedArray(imageBufferData);
    let imageData = new ImageData(imageBuffer, imgWidth, imgHeight);
    ctx.clearRect(0, 0, imgWidth, imgHeight);
    ctx.putImageData(imageData, 0, 0);
}
```
### 2.4、纹理渲染
```bash
const canvas = document.getElementById("sourceCanvas")
let outTexture = queenEngine.renderMediaObjectToTexture(canvas, canvas.width, canvas.height)
drawTexture(outTexture)
...
```
### 2.5、图片渲染

```bash
fetch(图片地址)
.then(r => r.blob())
.then(createImageBitmap)
.then(img => {
  queenEngine.renderWithImageData(img, img.width, img.height, function(imageBufferData, imageWidth, imageHeight){
    const canvas = document.getElementById('playCanvas');  //canvas画布 
    const ctx = canvas.getContext("2d");
    const imageBuffer = new Uint8ClampedArray(imageBufferData);
    const imageData = new ImageData(imageBuffer, imageWidth, imageHeight);
    ctx.clearRect(0, 0, imageWidth, imageHeight);
    ctx.putImageData(imageData, 0, 0);
});
});
```
## 三、Queen Web SDK接口说明
### 3.1、 美颜特效渲染
#### 3.1.1、 基于imageData对象渲染
```bash
/**
 * 图片渲染 
 * 返回ImageData对象
 * @param imageData 图片ImageData
 * @param imageWidth 宽
 * @param imageHeight 高
 * @param renderCallback 图片渲染回调
 */
render = function(imageData, imageWidth, imageHeight, renderCallback);
```
#### 3.1.2、基于纹理渲染
```bash
/**
 * 基于纹理渲染
 * 输入媒体对象返回纹理对象
 * @param mediaElement  媒体对象 imageElement、videoElement、canvasElement、videoframe、imagebitmap
 * @param width 媒体对像宽度
 * @param height 媒体对像高度
 * @returns 
 */
renderMediaObjectToTexture = function(mediaElement, width, height);
```
#### 3.1.3、纹理渲染
```bash
**
 * 基于纹理id渲染
 * 输入纹理id 返回纹理id
 * @param inTextureId 输入纹理id
 * @param width 媒体对像宽度
 * @param height 媒体对像高度
 * @returns 
 */
renderTextureId = function(inTextureId, width, height);
```
#### 3.1.4、美颜引擎注销
```bash
**
 * 美颜引擎注销
 */
engineDestory = function();
```
### 3.2、Animoji表情
#### 3.2.1、Animoji初始化
```typescript
/**
   * Animoji初始化
   * @param animojiUrl animoji资源地址
   * @param width 宽
   * @param height 高
   * @param scale 放大尺寸
   * @returns 
   */
  animojiInit = function (animojiUrl: string, width: number, height: number, scale: number)
```
#### 3.2.2、Animoji 图片渲染
```typescript
/**
   * Animoji 图片渲染
   * @param imageData 图片imageData
   * @param imageWidth 宽
   * @param imageHeight 高
   * @param renderCallBack 渲染回调 
   */
  animojiRender = function (imageData: Uint8Array, imageWidth: number, imageHeight: number, renderCallBack: any)
```
#### 3.2.3、Animoji纹理渲染
```typescript
/**
 * Animoji纹理渲染
 * 返回渲染后纹理
 * @param imageSource 媒体对象 image、video、canvas、videoframe、imagebitmap
 * @param imageWidth 宽
 * @param imageHeight 高
 */
animojirenderMediaObjectToTexture = function (mediaSource: any, imageWidth: number, imageHeight: number)
```
#### 3.2.4、Animoji大小调整
```typescript
/**
 * Animoji大小调整
 * @param scale 推荐：0.8~1.5
 */
animojiResize = function (scale: number)
```
#### 3.2.5、设置Animoji背景模式
```typescript
/**
* 设置Animoji背景模式
* @param mode 背景模式：0：无，1：摄像头背景 2：指定背景图片
* @param backgroundImgUrl 背景图片，如果mode=2时需要指定
*/
setAnimojiBackgroundWithMode = function (mode, backgroundImgUrl)
```
#### 3.2.6、Animoji引擎注销
```typescript
 /**
 * Animoji引擎注销
 */
animojiDestroy = function ()
```
### 3.3、背景抠图
#### 3.3.1、 绿幕/蓝幕抠图
```bash
/**
  * 绿幕/蓝幕抠图
  * 开启此抠图功能，纯色背景抠图（setPureColorToBackground）会关闭。
  * @param isBlue 绿幕:false，蓝幕:true
  * @param backgroundImgUrl 背景图片Url
	*/
setGreenScreenWithUrl = function (isBlue, backgroundImgUrl)
```
#### 3.3.2、实景抠图
```bash
/**
 * 实景AI抠图
 * @param backgroundImgUrl 背景图片Url
 */
setSegmentBackgroundUrl = function (backgroundImgUrl)
```
#### 3.3.3、纯色抠图
```bash
/**
 * 纯色背景抠图。
 * @param backgroundImgUrl 背景图片Url
 */
setPureColorBackgroundUrl = function (backgroundImgUrl)
```
### 3.4、参数配置
#### 3.4.1、配置美颜类型
```bash
 /**
   * 配置美颜类型
   * @param type kQueenBeautyType枚举
   * @param enable 是否启用
   */
  setQueenBeautyType = function (type: number, enable: boolean)
```
#### 3.4.2、配置美颜参数值
```bash
/**
   * 参数类型
   * @param param kQueenBeautyParams检举
   * @param value 参数值
   */
setQueenBeautyParams = function (param: number, value: number);
```
#### 3.4.3、配置LUT滤镜
```bash
/**
 * @brief 设置滤镜图片,设置滤镜图片前需要将kQueenBeautyTypeLUT打开
 * @param imageUrl 所要设置的滤镜图片的地址
 */
setLutImageUrl = function (imageUrl: string)
```
#### 3.4.4、设置美型类型
```bash
/**
*  @brief 设置美型类型,设置前需要将kQueenBeautyType.FaceShape打开
*  @param faceShapeType  需要设置美型的类型，参考QueenBeautyFaceShapeType
*  @param value 需要设置的值
*/
setFaceShape = function (faceShapeType: number, value: number)
```
#### 3.4.5、美妆API
##### 3.4.5.1、设置美妆类型和图片素材路径
```bash
/**
* @brief 设置美妆类型和图片素材路径，设置美妆需要将kQueenBeautyType.Makeup 打开
* @param makeupType 美妆类型
* @param imageUrl 美妆素材地址，一般为zip包
* @param blend 混合类型
*/
setMakeupWithUrl = function (makeupType: number, imageUrl: string, blend: number)
```
##### 3.4.5.2、设置美妆类型和图片素材路径
```typescript
/**
* @brief 设置美妆类型和图片素材路径，设置美妆需要将kQueenBeautyType.Makeup 打开
* @param makeupType 美妆类型
* @param packageUrl 资源压缩包url
* @param imageName 包内图片名称
* @param blend 混合类型
*/
setMakeupWithPackage = function (makeupType: number, packageUrl: string, imageName: string, blend: number);

/**
* @brief 设置美妆类型和图片素材路径，设置美妆需要将kQueenBeautyType.Makeup 打开
* @param makeupType 美妆类型
* @param imagePaths 美妆素材地址集合
* @param blend 混合类型
*/
setMakeupWithType = function (makeupType: number, imagePaths: string, blend: number)

/**
* @brief 设置美妆类型和图片素材路径
* @param makeupType 美妆类型
* @param imagePaths 美妆素材地址集合（多个资源则,号分开）
* @param blend 混合类型
* @param fps 对应的帧率
*/
setMakeupWithTypeFps = function (makeupType: number, imagePaths: string, blend: number, fps: number)
```
##### 3.4.5.3、设置美妆透明度
```typescript
 /**
* @brief 设置女性美妆透明度，可指定性别
* @param makeupType 美妆类型
* @param alpha 妆容透明度
*/
setMakeupFemaleAlpha = function (makeupType: number, alpha: number)

/**
* @brief 设置男性美妆透明度，可指定性别
* @param makeupType 美妆类型
* @param alpha 妆容透明度
*/
setMakeupMaleAlpha = function (makeupType: number, alpha: number)

/**
* @brief 设置美妆透明度，可指定性别
* @param makeupType 美妆类型
* @param isFeMale 是否是女性，女性:true，男性:false，（男性为接口预留，这里均传女性即true即可）
* @param alpha 妆容透明度
*/
setMakeupAlphaWithType = function (makeupType: number, isFeMale: boolean, alpha: number)
```
##### 3.4.5.4、设置美妆类型的混合类型
```typescript
 /**
  * @brief 设置美妆类型的混合类型
  * @param makeupType 美妆类型
  * @param blend 混合类型
  */
  setMakeupBlendWithType = function (makeupType: number, blend: number)
```
##### 3.4.5.5、清除所有美妆
```typescript
  /**
  * @brief 清除所有美妆
  */
  resetAllMakeupType = function ()
```
#### 3.4.6、贴纸API
##### 3.4.6.1、增加贴纸
```typescript
/**
* @brief 增加贴纸/贴图/实景抠图需要替换的背景，素材统一接口，支持GLTF,TAOPAI,MEDIAAI 类型
* @param materialZipUrl 要添加的素材的Url
*/
addMaterialWithUrl = function (materialZipUrl: string)
```
##### 3.4.6.2、移除贴纸
```typescript
 /**
  * @brief 删除贴纸/贴图/实景抠图需要替换的背景
  * @param materialZipUrl 要删除的素材的Url
  */
removeMaterialWithUrl = function (materialZipUrl: string)
```
#### 3.4.7、功能调试
##### 3.4.7.1、展示人脸识别点位
```typescript
  /**
  * @brief 展示人脸识别点位
  * @param show 是否展示
  */
  showFaceDetectPoint = function (show: boolean)
```
##### 3.4.7.2、展示人脸区域三角剖分线
```typescript
/**
  * @brief 展示人脸区域三角剖分线
  * @param show 是否展示
  */
  showMakeupLine = function (show: boolean) 
```
### 3.5、资源载入
参数配置中所有的url均需要转成path才能正常使用，需要通过下面的API将url资源文件载入到Queen引擎中生成path。
#### 3.5.1、通过url载入资源
```typescript
 /** 
 * 载入url资源到引擎
 * @param url url链接
 * @param needUnZip 是否需要解压
 * @returns 
 */
loadResourceFileWithUrl = function (url: string, needUnZip: boolean)

  /** 
 * 载入url资源到引擎
 * @param url url链接
 * @param saveFileName 保存文件名
 * @param needUnZip 是否需要解压
 * @returns 
 */
loadResourceFileWithUrlSaveAs = function (url: string, saveFileName:string, needUnZip: boolean) {
    
```
#### 3.5.2、通过arrayBuffer写入
```typescript
/**
 * 通过buffer写入资源
 * @param buffer arrayBuffer数据
 * @param saveFileName 保存文件名
 * @param needUnZip 是否需要解压
 * @param loadCallback 成功回调
 * @returns 
 */
loadResourceFileWithData = function(buffer: ArrayBuffer, saveFileName: string, needUnZip: boolean);
```


